package com.bizunited.platform.rbac.server.starter.repository;

import com.bizunited.platform.rbac.server.starter.entity.RoleUserMappingEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * 角色与用户关联的持久层接口定义
 * @Author: zengxingwang
 * @Date: 2020/3/30 16:01
 */
@Repository("RoleUserMappingRepository")
public interface RoleUserMappingRepository extends
        JpaRepository<RoleUserMappingEntity, String>,
        JpaSpecificationExecutor<RoleUserMappingEntity> {


  /**
   * 根据角色编码和用户账号查询统计
   * @param roleCode
   * @param userAccount
   * @return
   */
  @Query(value="select count(*) from engine_role_user_mapping where role_code = :roleCode and user_account = :userAccount", nativeQuery=true)
  long countByRoleCodeAndUserAccount(@Param("roleCode") String roleCode, @Param("userAccount") String userAccount);

  /**
   * 删除指定用户与角色的关联信息
   * @param account
   */
  @Modifying
  @Query(value="delete from engine_role_user_mapping where user_account = :userAccount", nativeQuery=true)
  void deleteByUserAccount(@Param("userAccount") String account);

  /**
   * 根据角色查询
   * @param roleCode
   * @return
   */
  @Query("select count(*) from RoleUserMappingEntity rum where rum.role.roleCode = :roleCode")
  long countByRole(@Param("roleCode") String roleCode);
}
