package com.bizunited.platform.rbac.server.starter.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

/**
 * 角色与组织机构的关联模型
 *
 * @author zhaowenyu
 * @date 2020/4/2 15:20
 */
@Entity
@ApiModel(value = "RoleUserGroupMappingEntity", description = "角色与用户组的关联模型")
@Table(name = "engine_role_group_mapping", uniqueConstraints = @UniqueConstraint(columnNames = {"role_code", "group_code"}))
@org.hibernate.annotations.Table(appliesTo = "engine_role_group_mapping", comment = "角色与用户组的关联模型")
public class RoleUserGroupMappingEntity extends UuidEntity {

  private static final long serialVersionUID = -6614851458728098410L;

  /**
   * 角色编码
   */
  @ApiModelProperty("角色编码")
  @ManyToOne(fetch = FetchType.LAZY)
  @SaturnColumn(description = "角色编码")
  @JoinColumn(name = "role_code", nullable = false, referencedColumnName = "role_code", columnDefinition = "varchar(64) COMMENT '角色编码'")
  private RoleEntity role;

  /**
   * 用户组编码
   */
  @ApiModelProperty("用户组编码")
  @SaturnColumn(description = "用户组编码")
  @Column(name = "group_code", nullable = false, columnDefinition = "varchar(128) COMMENT '组织机构编码'")
  private String groupCode;

  public RoleEntity getRole() {
	return role;
  }

  public void setRole(RoleEntity role) {
	this.role = role;
  }

  public String getGroupCode() {
	return groupCode;
  }

  public void setGroupCode(String groupCode) {
	this.groupCode = groupCode;
  }
}
