/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.starter.repository.internal;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.rbac.server.starter.entity.CompetenceEntity;
import com.bizunited.platform.rbac.server.starter.repository.internal.CompetenceRepositoryCustom;
import com.bizunited.platform.rbac.server.vo.CompetenceVo;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="CompetenceRepositoryCustomImpl")
public class CompetenceRepositoryImpl
implements CompetenceRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    private static final String COMMENT = "comment";
    private static final String RESOURCE = "resource";
    private static final String TSTATUS = "tstatus";
    private static final String METHODS = "methods";

    @Override
    public Page<CompetenceEntity> findByConditions(Pageable pageable, CompetenceVo competence) {
        StringBuilder hql = new StringBuilder("from CompetenceEntity co where co.viewItem = 0");
        StringBuilder countHql = new StringBuilder("select count(*) from CompetenceEntity co where co.viewItem = 0 ");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        if (competence != null) {
            if (StringUtils.isNotBlank((CharSequence)competence.getComment())) {
                condition.append(" AND co.comment like CONCAT('%', :comment,'%') ");
                parameter.put(COMMENT, competence.getComment());
            }
            if (StringUtils.isNotBlank((CharSequence)competence.getMethods())) {
                condition.append(" AND co.methods = :methods ");
                parameter.put(METHODS, competence.getMethods());
            }
            if (competence.getTstatus() != null) {
                condition.append(" AND co.tstatus = :tstatus ");
                parameter.put(TSTATUS, competence.getTstatus());
            }
        }
        hql.append((CharSequence)condition).append(" order by co.sortIndex");
        countHql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameter, pageable, false, null);
    }

    @Override
    public List<CompetenceEntity> findAllByConditions(CompetenceVo competence) {
        StringBuilder hql = new StringBuilder("from CompetenceEntity co where co.viewItem = 1");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        if (competence != null) {
            if (StringUtils.isNotBlank((CharSequence)competence.getComment())) {
                condition.append(" AND co.comment like CONCAT('%', :comment,'%') ");
                parameter.put(COMMENT, competence.getComment());
            }
            if (StringUtils.isNotBlank((CharSequence)competence.getResource())) {
                condition.append(" AND co.resource like CONCAT(:resource,'%')  ");
                parameter.put(RESOURCE, competence.getResource());
            }
            if (competence.getTstatus() != null) {
                condition.append(" AND co.tstatus = :tstatus ");
                parameter.put(TSTATUS, competence.getTstatus());
            }
        }
        hql.append((CharSequence)condition).append(" order by co.createDate desc");
        Query query = this.entityManager.createQuery(hql.toString());
        parameter.forEach((k, v) -> query.setParameter(k, v));
        return query.getResultList();
    }
}

