package com.bizunited.platform.rbac.server.starter.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

/**
 * 角色与用户的关联表
 * @Author: zengxingwang
 * @Date: 2020/3/30 14:55
 */
@ApiModel(value = "RoleUserMappingEntity" , description="角色与用户的关联模型")
@Entity
@Table(name = "engine_role_user_mapping", uniqueConstraints = @UniqueConstraint(columnNames = {"role_code", "user_account"}))
@org.hibernate.annotations.Table(appliesTo = "engine_role_user_mapping" , comment = "角色与用户的关联模型")
public class RoleUserMappingEntity extends UuidEntity {

  private static final long serialVersionUID = 7649043001002183691L;

  /**
   * 角色编码
   */
  @ApiModelProperty("角色编码")
  @ManyToOne(fetch = FetchType.LAZY)
  @SaturnColumn(description="角色编码")
  @JoinColumn(name = "role_code", nullable = false, referencedColumnName = "role_code", columnDefinition = "varchar(64) COMMENT '角色编码'")
  private RoleEntity role;

  /**
   * 用户账号
   */
  @ApiModelProperty(name="userAccount" , value="用户账号" , required=true)
  @Column(name = "user_account", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '用户账号'")
  @SaturnColumn(description="用户账号")
  private String userAccount;

  public RoleEntity getRole() {
    return role;
  }

  public void setRole(RoleEntity role) {
    this.role = role;
  }

  public String getUserAccount() {
    return userAccount;
  }

  public void setUserAccount(String userAccount) {
    this.userAccount = userAccount;
  }
}