package com.bizunited.platform.rbac.server.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.rbac.server.service.RolePositionLevelMappingService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;


/**
 * @author: weikangning
 * @Date: 2020/8/16 21:28
 * @Description: 职位级别
 */
@RestController
@RequestMapping("/v1/nebula/rolePositionLevelMapping")
public class RolePositionLevelMappingController extends BaseController {

  @Autowired
  private RolePositionLevelMappingService rolePositionLevelMappingService;
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(RolePositionMappingController.class);

  /**
   * 将指定职位级别绑定一个或多个角色
   *
   * @param positionLevelCode
   * @param roleIds
   * @return
   */
  @ApiOperation(value = "将指定职位级别绑定一个或多个角色")
  @PatchMapping("bindPositionLevelRoles")
  public ResponseModel bindPositionLevelRoles(
          @RequestParam @ApiParam("职位级别编码") String positionLevelCode,
          @RequestParam @ApiParam("当前要绑定的一个或多个角色id") String[] roleIds) {
    try {
      rolePositionLevelMappingService.bindPositionLevelRoles(positionLevelCode, roleIds);
      return this.buildHttpResult();
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 将指定职位级别重新绑定一个或多个角色
   *
   * @param positionLevelCode
   * @param roleIds
   * @return
   */
  @ApiOperation(value = "将指定职位级别重新绑定一个或多个角色")
  @PatchMapping("rebindPositionLevelRoles")
  public ResponseModel rebindPositionLevelRoles(
          @RequestParam @ApiParam("职位级别编码") String positionLevelCode,
          @RequestParam(required = false) @ApiParam("当前要绑定的一个或多个角色id") String[] roleIds) {
    try {
      rolePositionLevelMappingService.rebindPositionLevelRoles(positionLevelCode, roleIds);
      return this.buildHttpResult();
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 将指定职位级别解除一个或多个角色的绑定
   *
   * @param positionLevelCode
   * @param roleIds
   * @return
   */
  @ApiOperation(value = "将指定职位级别解除一个或多个角色的绑定")
  @PatchMapping("unbindPositionLevelRoles")
  public ResponseModel unbindPositionLevelRoles(
          @RequestParam @ApiParam("职位级别编码") String positionLevelCode,
          @RequestParam @ApiParam("当前要解绑定的一个或多个角色id") String[] roleIds) {
    try {
      rolePositionLevelMappingService.unbindPositionLevelRoles(positionLevelCode, roleIds);
      return this.buildHttpResult();
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }
}
