/**
 * 权限.
 */
package com.bizunited.platform.rbac.server.starter.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import java.util.Date;
import java.util.Set;

/**
 * 系统功能信息的数据持久层描述
 * @author yinwenjie
 * @version V2.0
 */
@ApiModel(value = "CompetenceEntity" , description="系统功能信息的数据持久层描述")
@Entity
@Table(name = "engine_competence" , indexes={@Index(columnList="parent_id,view_item,sort_index"),
                                             @Index(columnList="resource,methods"),
                                             @Index(columnList="extract_uri")})
@org.hibernate.annotations.Table(appliesTo = "engine_competence" , comment = "系统功能信息的数据持久层描述")
public class CompetenceEntity extends UuidEntity {

  private static final long serialVersionUID = -7742962048681654604L;

  /** 权限URL串. **/
  @ApiModelProperty(name="resource" , value="权限URL串")
  @Column(name = "resource", nullable = false, columnDefinition = "varchar(255) COMMENT '权限URL串'")
  @SaturnColumn(description="权限URL串")
  private String resource = "";

  /** 菜单编码 **/
  @ApiModelProperty(name="code" , value="菜单编码")
  @Column(name = "code", nullable = false, columnDefinition = "varchar(255) COMMENT '菜单编码'")
  @SaturnColumn(description="code")
  private String code = "";

  /**
   * 涉及的方法描述<br>
   * 例如：POST或者POST|GET|DELETE
   */
  @ApiModelProperty(name="methods" , value="涉及的方法描述，例如：POST或者POST|GET|DELETE", required=true)
  @Column(name = "methods", length=64 , nullable = false, columnDefinition = "varchar(64) COMMENT '涉及的方法描述'")
  @SaturnColumn(description="涉及的方法描述")
  private String methods = "";

  /** 创建时间. **/
  @ApiModelProperty(name="createDate" , value="创建时间", required=true)
  @Column(name = "create_date", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description="创建时间")
  private Date createDate = new Date();
  
  /** 修改时间. **/
  @ApiModelProperty(name="modifyDate" , value="修改时间", required=true)
  @Column(name = "modify_date" , nullable=false, columnDefinition = "datetime COMMENT '修改时间'")
  @SaturnColumn(description="修改时间")
  private Date modifyDate = new Date();

  /** 状态 1正常, 0禁用（枚举）. **/
  @ApiModelProperty(name="tstatus" , value="状态 1正常, 0禁用（枚举）", required=true)
  @Column(name = "tstatus", nullable = false, columnDefinition = "int(11) COMMENT '状态 1正常, 0禁用（枚举）'")
  @SaturnColumn(description="功能状态")
  private Integer tstatus = 1;

  /** 功能备注（功能中文名）. **/
  @ApiModelProperty(name="comment" , value="备注" , required=true)
  @Column(name = "comment" , nullable = false, length = 1024, columnDefinition = "varchar(1024) COMMENT '功能备注（功能中文名）'")
  @SaturnColumn(description="功能备注（功能中文名）")
  private String comment = "";

  /**
   * 菜单说明
   */
  @ApiModelProperty("菜单说明")
  @SaturnColumn(description = "菜单说明")
  @Column(name = "description", length = 512, columnDefinition = "varchar(512) COMMENT '菜单说明'")
  private String description;
  /**
   * 当前功能项是否显示在菜单树中
   */
  @ApiModelProperty(name="viewItem" , value="当前功能项是否显示在菜单树中 1：显示的菜单树；0：不显示在菜单树" , required=true)
  @Column(name="view_item" , nullable=false, columnDefinition = "int(11) COMMENT '当前功能项是否显示在菜单树中 1：显示的菜单树；0：不显示在菜单树'")
  @SaturnColumn(description="功能项是否显示在菜单树中")
  private Integer viewItem = 0;
  /**
   * 功能排序信息，数字越大排序越靠后
   */
  @Column(name="sort_index" , nullable=false, columnDefinition = "int(11) COMMENT '功能排序信息，数字越大排序越靠后'")
  @SaturnColumn(description="功能排序信息")
  private Integer sortIndex = 100;
  /**
   * 图表标识信息
   */
  @Column(name="icon" , length=32 , nullable=true, columnDefinition = "varchar(32) COMMENT '图表标识'")
  @SaturnColumn(description="图表标识")
  private String icon = "";
  /**
   * 这个路径是否是带有匹配符的动态路径；1：动态路径；0：非动态路径
   */
  @Column(name="extract_uri" , nullable=false, columnDefinition = "int(11) COMMENT '这个路径是否是带有匹配符的动态路径；1：动态路径；0：非动态路径'")
  @SaturnColumn(description="带有匹配符的动态路径")
  private Integer extractUri = 0;
  /** 标签 **/
  @ApiModelProperty(name="tag" , value="标签")
  @Column(name = "tag" , columnDefinition = "varchar(255) COMMENT '标签'")
  @SaturnColumn(description="标签")
  private String tag;
  /**
   * 菜单对应的角色信息
   */
  @ApiModelProperty(name="roles" , value="状态 1正常, 0禁用（枚举）" , required=false , hidden=true)
  @ManyToMany(mappedBy = "competences")
  @SaturnColumn(description="菜单对应的角色信息")
  private Set<RoleEntity> roles;

  /**
   * 权限对应的按钮信息
   */
  @ApiModelProperty(name="buttons", value="权限对应的按钮信息", required=false , hidden=true)
  @OneToMany(mappedBy = "competence")
  @SaturnColumn(description="权限对应的按钮信息")
  private Set<ButtonEntity> buttons;
  /**
   * 当前功能对应的父级功能，注意可能没有。如果没有父级功能，说明当前这个功能可能就是一个最顶级的父级功能
   */
  @ApiModelProperty(name="parent" , value="当前功能对应的父级功能，注意可能没有。如果没有父级功能，说明当前这个功能可能就是一个最顶级的父级功能" , required=false , hidden=true)
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="parent_id" , nullable=true , columnDefinition = "varchar(255) COMMENT '当前功能对应的父级功能'")
  @SaturnColumn(description="当前功能对应的父级功能")
  private CompetenceEntity parent;

  /**
   * 角色下级
   */
  @OrderBy("createDate desc")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "parent")
  @ApiModelProperty("菜单下级")
  @SaturnColumn(description = "菜单下级")
  private Set<CompetenceEntity> children;

  /**
   * 菜单类型
   */
  @ApiModelProperty(name="type" , value="菜单类型")
  @Column(name = "type" , nullable = true, columnDefinition = "varchar(255) COMMENT '菜单类型'")
  @SaturnColumn(description="菜单类型")
  private String type;

  /**
   * 当前项目名工程名
   */
  @ApiModelProperty("项目名")
  @Column(name="project_name", nullable = false, columnDefinition = "varchar(255) default '' comment '工程名'")
  @SaturnColumn(description = "工程名")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public Set<CompetenceEntity> getChildren() {
    return children;
  }

  public void setChildren(Set<CompetenceEntity> children) {
    this.children = children;
  }

  public String getResource() {
    return resource;
  }
  public void setResource(String resource) {
    this.resource = resource;
  }
  public String getMethods() {
    return methods;
  }
  public void setMethods(String methods) {
    this.methods = methods;
  }
  public Date getCreateDate() {
    return createDate;
  }
  public void setCreateDate(Date createDate) {
    this.createDate = createDate;
  }
  public Date getModifyDate() {
    return modifyDate;
  }
  public void setModifyDate(Date modifyDate) {
    this.modifyDate = modifyDate;
  }
  public Integer getTstatus() {
    return tstatus;
  }
  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }
  public Set<ButtonEntity> getButtons() {
    return buttons;
  }
  public void setButtons(Set<ButtonEntity> buttons) {
    this.buttons = buttons;
  }
  public Set<RoleEntity> getRoles() {
    return roles;
  }
  public void setRoles(Set<RoleEntity> roles) {
    this.roles = roles;
  }
  public String getComment() {
    return comment;
  }
  public void setComment(String comment) {
    this.comment = comment;
  }
  public CompetenceEntity getParent() {
    return parent;
  }
  public void setParent(CompetenceEntity parent) {
    this.parent = parent;
  }
  public Integer getViewItem() {
    return viewItem;
  }
  public void setViewItem(Integer viewItem) {
    this.viewItem = viewItem;
  }
  public Integer getSortIndex() {
    return sortIndex;
  }
  public void setSortIndex(Integer sortIndex) {
    this.sortIndex = sortIndex;
  }
  public String getIcon() {
    return icon;
  }
  public void setIcon(String icon) {
    this.icon = icon;
  }
  public Integer getExtractUri() {
    return extractUri;
  }
  public void setExtractUri(Integer extractUri) {
    this.extractUri = extractUri;
  }
  public String getTag() {
    return tag;
  }
  public void setTag(String tag) {
    this.tag = tag;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }
}