package com.bizunited.platform.rbac.server.starter.repository;

import com.bizunited.platform.rbac.server.starter.entity.RolePositionMappingEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 *
 * 角色与岗位关联的持久层接口定义
 * @author: pangdajin
 * @date: 31/03/2020 10:00
 */
@Repository("RolePositionMappingRepository")
public interface RolePositionMappingRepository extends JpaRepository<RolePositionMappingEntity, String>,
    JpaSpecificationExecutor<RolePositionMappingEntity> {
  /**
   * 根据角色和岗位编码查询统计
   * @param role
   * @param positionCode
   * @return select count(*) from RoleOrgMappingEntity rom where rom.role = :role and rom.orgCode = :orgCode
   */
  @Query(value = "SELECT COUNT(*) FROM RolePositionMappingEntity rpm WHERE rpm.role.roleCode = :role AND rpm.positionCode = :positionCode and rpm.projectName=:projectName ")
  long countByRoleAndPositionAndProjectName(@Param("role") String role, @Param("positionCode") String positionCode, @Param("projectName") String projectName);

  /**
   * 根据角色查询统计
   * @param role
   * @return
   */
  @Query(value = "SELECT COUNT(*) FROM RolePositionMappingEntity rpm WHERE rpm.role.roleCode = :role and rpm.projectName=:projectName ")
  long countByRoleAndProjectName(@Param("role") String role, @Param("projectName") String projectName);

  /**
   * 根据岗位编码查询统计
   * @param positionCode
   * @return
   */
  @Query(value = "SELECT COUNT(*) FROM RolePositionMappingEntity rpm WHERE rpm.positionCode = :positionCode and rpm.projectName=:projectName ")
  long countByPositionCodeAndProject(@Param("positionCode") String positionCode, @Param("projectName") String projectName);

  /**
   * 根据角色和岗位编码查询
   * @param role
   * @param positionCode
   * @return
   */
  @Query("from RolePositionMappingEntity rpm where rpm.role.roleCode = :role and rpm.positionCode = :positionCode and rpm.projectName=:projectName ")
  RolePositionMappingEntity findByRoleAndPositionCodeAndProjectName(@Param("role") String role, @Param("positionCode") String positionCode, @Param("projectName") String projectName);

  /**
   * 根据角色查询
   * @param role
   * @return
   */
  @Query("from RolePositionMappingEntity rpm where rpm.role.roleCode = :role and rpm.projectName=:projectName ")
  List<RolePositionMappingEntity> findByRoleAndProjectName(@Param("role") String role, @Param("projectName") String projectName);

  /**
   * 根据岗位查询
   * @param positionCode
   * @return
   */
  @Query("from RolePositionMappingEntity rpm where rpm.positionCode = :positionCode and rpm.projectName=:projectName ")
  List<RolePositionMappingEntity> findByPositionCodeAndProjectName(@Param("positionCode") String positionCode, @Param("projectName") String projectName);

  /**
   * 给定一个指定的岗位信息，解除这个岗位信息和所有角色的绑定关系
   * @param positionCode
   * @return
   */
  @Modifying
  @Query(value = "DELETE  FROM engine_role_position_mapping WHERE position_code = :positionCode and project_name=:projectName" , nativeQuery = true)
  void unbindPositionCodeByProjectName(@Param("positionCode") String positionCode, @Param("projectName") String projectName);
  
  /**
   * 给定角色信息，删除这个角色已绑定的所有岗位信息
   * @param roleCode
   * @return
   */
  @Modifying
  @Query(value = "DELETE FROM engine_role_position_mapping WHERE role_code = :roleCode and project_name=:projectName" , nativeQuery = true)
  void unbindRoleCodeByProjectName(@Param("roleCode") String roleCode, @Param("projectName") String projectName);
}