package com.bizunited.platform.rbac.server.starter.service.internal;

import com.bizunited.platform.common.enums.RbacRelationEnum;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.rbac.server.service.RbacSettingService;
import com.bizunited.platform.rbac.server.starter.entity.RbacSettingEntity;
import com.bizunited.platform.rbac.server.starter.repository.RbacSettingRepository;
import com.bizunited.platform.rbac.server.vo.RbacSettingVo;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.transaction.Transactional;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

/**
 * rbac环境配置服务实现类
 * @Author: Paul Chan
 * @Date: 2019-11-25 15:57
 */
@Service("RbacSettingServiceImpl")
public class RbacSettingServiceImpl implements RbacSettingService {

  @Autowired
  private RbacSettingRepository rbacSettingRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;


  @Override
  @Transactional
  public RbacSettingVo init() {
    List<RbacSettingEntity> settings = rbacSettingRepository.findAll();
    if(!CollectionUtils.isEmpty(settings)) {
      settings = settings.stream().filter(rbacSettingEntity -> StringUtils.equals(rbacSettingEntity.getProjectName(), ApplicationContextUtils.getProjectName())).collect(Collectors.toList());
      return nebulaToolkitService.copyObjectByWhiteList(settings.get(0), RbacSettingVo.class, HashSet.class, ArrayList.class);
    }
    RbacSettingEntity setting = new RbacSettingEntity();
    setting.setUserRoleRelation(RbacRelationEnum.MANY_TO_MANY.getRelation());
    setting.setRoleGroupRelation(RbacRelationEnum.MANY_TO_ONE.getRelation());
    setting.setRoleOrgRelation(RbacRelationEnum.MANY_TO_ONE.getRelation());
    setting.setRolePositionRelation(RbacRelationEnum.MANY_TO_ONE.getRelation());
    setting.setProjectName(ApplicationContextUtils.getProjectName());
    rbacSettingRepository.save(setting);
    return nebulaToolkitService.copyObjectByWhiteList(setting, RbacSettingVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  @Transactional
  public RbacSettingVo update(RbacSettingVo setting) {
    Validate.notBlank(setting.getId(), "更新时主键ID不能为空!!!");
    RbacSettingEntity rbacSetting = rbacSettingRepository.findById(setting.getId()).orElse(null);
    Validate.notNull(rbacSetting, "更新对象不存在，请检查！！！");
    if(setting.getUserRoleRelation() != null) {
      rbacSetting.setUserRoleRelation(setting.getUserRoleRelation());
    }
    if(setting.getRoleGroupRelation() != null) {
      rbacSetting.setRoleGroupRelation(setting.getRoleGroupRelation());
    }
    if(setting.getRoleOrgRelation() != null) {
      rbacSetting.setRoleOrgRelation(setting.getRoleOrgRelation());
    }
    if(setting.getRolePositionRelation() != null) {
      rbacSetting.setRolePositionRelation(setting.getRolePositionRelation());
    }
    rbacSettingRepository.save(rbacSetting);
    return nebulaToolkitService.copyObjectByWhiteList(rbacSetting, RbacSettingVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  public RbacSettingVo findRbacSetting() {
    List<RbacSettingEntity> settings = rbacSettingRepository.findAll();
    if(CollectionUtils.isEmpty(settings)) {
      return this.init();
    }else{
      settings = settings.stream().filter(rbacSettingEntity -> StringUtils.equals(ApplicationContextUtils.getProjectName(), rbacSettingEntity.getProjectName())).collect(Collectors.toList());
    }
    return nebulaToolkitService.copyObjectByWhiteList(settings.get(0), RbacSettingVo.class, HashSet.class, ArrayList.class);
  }

}
