/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.starter.repository;

import com.bizunited.platform.rbac.server.starter.entity.RoleOrgMappingEntity;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="RoleOrgMappingRepository")
public interface RoleOrgMappingRepository
extends JpaRepository<RoleOrgMappingEntity, String>,
JpaSpecificationExecutor<RoleOrgMappingEntity> {
    @Modifying
    @Query(value="delete from engine_role_org_mapping where role_code = :roleCode and project_name=:projectName", nativeQuery=true)
    public void deleteByRoleCodeAndProjectName(@Param(value="roleCode") String var1, @Param(value="projectName") String var2);

    @Modifying
    @Query(value="delete from engine_role_org_mapping where org_code = :orgCode and project_name=:projectName", nativeQuery=true)
    public void deleteByOrgCodeAndProjectName(@Param(value="orgCode") String var1, @Param(value="projectName") String var2);

    @Query(value="select count(*) from RoleOrgMappingEntity rom where rom.role.roleCode = :role and rom.orgCode = :orgCode and rom.projectName=:projectName ")
    public long countByRoleAndOrgCodeAndProjectName(@Param(value="role") String var1, @Param(value="orgCode") String var2, @Param(value="projectName") String var3);

    @Query(value="select count(*) from RoleOrgMappingEntity rom where rom.role.roleCode = :role and rom.projectName=:projectName ")
    public long countByRoleAndProjectName(@Param(value="role") String var1, @Param(value="projectName") String var2);

    @Query(value="select count(*) from RoleOrgMappingEntity rom where rom.orgCode = :orgCode and rom.projectName=:projectName ")
    public long countByOrgCodeAndProjectName(@Param(value="orgCode") String var1, @Param(value="projectName") String var2);

    @Query(value="from RoleOrgMappingEntity rom where rom.role.roleCode = :role and rom.orgCode = :orgCode and rom.projectName=:projectName ")
    public RoleOrgMappingEntity findByRoleAndOrgCodeAndProjectName(@Param(value="role") String var1, @Param(value="orgCode") String var2, @Param(value="projectName") String var3);

    @Query(value="select rom from RoleOrgMappingEntity rom inner join rom.role r where rom.orgCode = :orgCode and r.id in :roleIds")
    public Set<RoleOrgMappingEntity> findByOrgCodeAndRoleIds(@Param(value="orgCode") String var1, @Param(value="roleIds") String[] var2);

    @Query(value="select rom from RoleOrgMappingEntity rom where rom.role.roleCode = :role and rom.projectName=:projectName order by rom.orgCode ASC")
    public Set<RoleOrgMappingEntity> findByRoleAndProjectName(@Param(value="role") String var1, @Param(value="projectName") String var2);

    @Query(value="select ro from RoleOrgMappingEntity ro inner join fetch ro.role r where ro.orgCode = :orgCode and ro.projectName=:projectName ")
    public Set<RoleOrgMappingEntity> findDetailsByOrgCodeAndProjectName(@Param(value="orgCode") String var1, @Param(value="projectName") String var2);
}

