/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.starter.repository;

import com.bizunited.platform.rbac.server.starter.entity.RolePositionMappingEntity;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="RolePositionMappingRepository")
public interface RolePositionMappingRepository
extends JpaRepository<RolePositionMappingEntity, String>,
JpaSpecificationExecutor<RolePositionMappingEntity> {
    @Query(value="SELECT COUNT(*) FROM RolePositionMappingEntity rpm WHERE rpm.role.roleCode = :role AND rpm.positionCode = :positionCode and rpm.projectName=:projectName ")
    public long countByRoleAndPositionAndProjectName(@Param(value="role") String var1, @Param(value="positionCode") String var2, @Param(value="projectName") String var3);

    @Query(value="SELECT COUNT(*) FROM RolePositionMappingEntity rpm WHERE rpm.role.roleCode = :role and rpm.projectName=:projectName ")
    public long countByRoleAndProjectName(@Param(value="role") String var1, @Param(value="projectName") String var2);

    @Query(value="SELECT COUNT(*) FROM RolePositionMappingEntity rpm WHERE rpm.positionCode = :positionCode and rpm.projectName=:projectName ")
    public long countByPositionCodeAndProject(@Param(value="positionCode") String var1, @Param(value="projectName") String var2);

    @Query(value="from RolePositionMappingEntity rpm where rpm.role.roleCode = :role and rpm.positionCode = :positionCode and rpm.projectName=:projectName ")
    public RolePositionMappingEntity findByRoleAndPositionCodeAndProjectName(@Param(value="role") String var1, @Param(value="positionCode") String var2, @Param(value="projectName") String var3);

    @Query(value="from RolePositionMappingEntity rpm where rpm.role.roleCode = :role and rpm.projectName=:projectName ")
    public List<RolePositionMappingEntity> findByRoleAndProjectName(@Param(value="role") String var1, @Param(value="projectName") String var2);

    @Query(value="from RolePositionMappingEntity rpm where rpm.positionCode = :positionCode and rpm.projectName=:projectName ")
    public List<RolePositionMappingEntity> findByPositionCodeAndProjectName(@Param(value="positionCode") String var1, @Param(value="projectName") String var2);

    @Modifying
    @Query(value="DELETE  FROM engine_role_position_mapping WHERE position_code = :positionCode and project_name=:projectName", nativeQuery=true)
    public void unbindPositionCodeByProjectName(@Param(value="positionCode") String var1, @Param(value="projectName") String var2);

    @Modifying
    @Query(value="DELETE FROM engine_role_position_mapping WHERE role_code = :roleCode and project_name=:projectName", nativeQuery=true)
    public void unbindRoleCodeByProjectName(@Param(value="roleCode") String var1, @Param(value="projectName") String var2);
}

