/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.starter.service.internal;

import com.bizunited.platform.common.enums.RbacRelationEnum;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.rbac.server.service.RbacSettingService;
import com.bizunited.platform.rbac.server.starter.entity.RbacSettingEntity;
import com.bizunited.platform.rbac.server.starter.repository.RbacSettingRepository;
import com.bizunited.platform.rbac.server.vo.RbacSettingVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="RbacSettingServiceImpl")
public class RbacSettingServiceImpl
implements RbacSettingService {
    @Autowired
    private RbacSettingRepository rbacSettingRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Transactional
    public RbacSettingVo init() {
        List settings = this.rbacSettingRepository.findAll();
        if (!CollectionUtils.isEmpty((Collection)settings)) {
            settings = settings.stream().filter(rbacSettingEntity -> StringUtils.equals((CharSequence)rbacSettingEntity.getProjectName(), (CharSequence)ApplicationContextUtils.getProjectName())).collect(Collectors.toList());
            return (RbacSettingVo)this.nebulaToolkitService.copyObjectByWhiteList(settings.get(0), RbacSettingVo.class, HashSet.class, ArrayList.class, new String[0]);
        }
        RbacSettingEntity setting = new RbacSettingEntity();
        setting.setUserRoleRelation(RbacRelationEnum.MANY_TO_MANY.getRelation());
        setting.setRoleGroupRelation(RbacRelationEnum.MANY_TO_ONE.getRelation());
        setting.setRoleOrgRelation(RbacRelationEnum.MANY_TO_ONE.getRelation());
        setting.setRolePositionRelation(RbacRelationEnum.MANY_TO_ONE.getRelation());
        setting.setProjectName(ApplicationContextUtils.getProjectName());
        this.rbacSettingRepository.save((Object)setting);
        return (RbacSettingVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)setting, RbacSettingVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public RbacSettingVo update(RbacSettingVo setting) {
        Validate.notBlank((CharSequence)setting.getId(), (String)"\u66f4\u65b0\u65f6\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a!!!", (Object[])new Object[0]);
        RbacSettingEntity rbacSetting = this.rbacSettingRepository.findById(setting.getId()).orElse(null);
        Validate.notNull((Object)((Object)rbacSetting), (String)"\u66f4\u65b0\u5bf9\u8c61\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01\uff01\uff01", (Object[])new Object[0]);
        if (setting.getUserRoleRelation() != null) {
            rbacSetting.setUserRoleRelation(setting.getUserRoleRelation());
        }
        if (setting.getRoleGroupRelation() != null) {
            rbacSetting.setRoleGroupRelation(setting.getRoleGroupRelation());
        }
        if (setting.getRoleOrgRelation() != null) {
            rbacSetting.setRoleOrgRelation(setting.getRoleOrgRelation());
        }
        if (setting.getRolePositionRelation() != null) {
            rbacSetting.setRolePositionRelation(setting.getRolePositionRelation());
        }
        this.rbacSettingRepository.save((Object)rbacSetting);
        return (RbacSettingVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)rbacSetting, RbacSettingVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public RbacSettingVo findRbacSetting() {
        List settings = this.rbacSettingRepository.findAll();
        if (CollectionUtils.isEmpty((Collection)settings)) {
            return this.init();
        }
        settings = settings.stream().filter(rbacSettingEntity -> StringUtils.equals((CharSequence)ApplicationContextUtils.getProjectName(), (CharSequence)rbacSettingEntity.getProjectName())).collect(Collectors.toList());
        return (RbacSettingVo)this.nebulaToolkitService.copyObjectByWhiteList(settings.get(0), RbacSettingVo.class, HashSet.class, ArrayList.class, new String[0]);
    }
}

