/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.starter.service.internal;

import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.service.RoleUserMappingService;
import com.bizunited.platform.rbac.server.starter.entity.RoleEntity;
import com.bizunited.platform.rbac.server.starter.entity.RoleUserMappingEntity;
import com.bizunited.platform.rbac.server.starter.repository.RoleUserMappingRepository;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;

public class RoleUserMappingServiceImpl
implements RoleUserMappingService {
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private RoleUserMappingRepository roleUserMappingRepository;

    @Transactional
    public void bindUserRoles(String account, String[] roleCodes) {
        Validate.notBlank((CharSequence)account, (String)"\u7ed1\u5b9a\u6743\u9650\u65f6\uff0c\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserVo user = this.userService.findByAccount(account);
        Validate.notNull((Object)user, (String)"\u7528\u6237\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((roleCodes != null && roleCodes.length > 0 ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u8bf7\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u89d2\u8272\u540d\u4fe1\u606f", (Object[])new Object[0]);
        Set roles = this.roleService.findByRoleCodes((Set)Sets.newHashSet((Object[])roleCodes));
        Validate.notNull((Object)roles, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u591a\u4e2a\u89d2\u8272\uff08\u540d\uff09\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((!roles.isEmpty() && roles.size() == roleCodes.length ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u591a\u4e2a\u89d2\u8272\uff08\u540d\uff09\u4fe1\u606f!!", (Object[])new Object[0]);
        for (RoleVo role : roles) {
            long count = this.roleUserMappingRepository.countByRoleCodeAndUserAccountAndProjectName(role.getRoleCode(), user.getAccount(), ApplicationContextUtils.getProjectName());
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u89d2\u8272\u7f16\u7801[%s]\u4e0e\u7528\u6237[%s]\u91cd\u590d\u7ed1\u5b9a\u8bf7\u68c0\u67e5", (Object[])new Object[]{role.getRoleCode(), user.getAccount()});
            RoleUserMappingEntity entity = new RoleUserMappingEntity();
            RoleEntity currentRole = new RoleEntity();
            currentRole.setId(role.getId());
            currentRole.setRoleCode(role.getRoleCode());
            entity.setRole(currentRole);
            entity.setUserAccount(user.getAccount());
            entity.setProjectName(ApplicationContextUtils.getProjectName());
            this.roleUserMappingRepository.save((Object)entity);
        }
    }

    @Transactional
    public void reBindUserRoles(String account, String[] roleCodes) {
        Validate.notBlank((CharSequence)account, (String)"\u7ed1\u5b9a\u6743\u9650\u65f6\uff0c\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserVo user = this.userService.findByAccount(account);
        Validate.notNull((Object)user, (String)"\u7528\u6237\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.notEmpty((Object[])roleCodes, (String)"\u7ed1\u5b9a\u6216\u8005\u89e3\u7ed1\u5fc5\u987b\u4fdd\u8bc1\u7528\u6237\u62e5\u6709\u81f3\u5c11\u4e00\u4e2a\u76f4\u63a5\u7ed1\u5b9a\u7684\u89d2\u8272!!", (Object[])new Object[0]);
        Set roles = this.roleService.findByRoleCodes((Set)Sets.newHashSet((Object[])roleCodes));
        Validate.notNull((Object)roles, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u591a\u4e2a\u89d2\u8272\uff08\u540d\uff09\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((!roles.isEmpty() && roles.size() == roleCodes.length ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u591a\u4e2a\u89d2\u8272\uff08\u540d\uff09\u4fe1\u606f!!", (Object[])new Object[0]);
        this.roleUserMappingRepository.deleteByUserAccountAndProjectName(user.getAccount(), ApplicationContextUtils.getProjectName());
        for (RoleVo role : roles) {
            long count = this.roleUserMappingRepository.countByRoleCodeAndUserAccountAndProjectName(role.getRoleCode(), user.getAccount(), ApplicationContextUtils.getProjectName());
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u89d2\u8272\u7f16\u7801[%s]\u4e0e\u7528\u6237[%s]\u91cd\u590d\u7ed1\u5b9a\u8bf7\u68c0\u67e5", (Object[])new Object[]{role.getRoleCode(), user.getAccount()});
            RoleUserMappingEntity entity = new RoleUserMappingEntity();
            RoleEntity currentRole = new RoleEntity();
            currentRole.setId(role.getId());
            currentRole.setRoleCode(role.getRoleCode());
            entity.setRole(currentRole);
            entity.setUserAccount(user.getAccount());
            entity.setProjectName(ApplicationContextUtils.getProjectName());
            this.roleUserMappingRepository.save((Object)entity);
        }
    }
}

