package com.bizunited.platform.rbac.server.starter.repository;

import com.bizunited.platform.rbac.server.starter.entity.RoleOrgMappingEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * 角色与组织机构关联的持久曾接口定义
 * @Author: Paul Chan
 * @Date: 2020-04-01 14:08
 */
@Repository("RoleOrgMappingRepository")
public interface RoleOrgMappingRepository extends JpaRepository<RoleOrgMappingEntity, String>,
    JpaSpecificationExecutor<RoleOrgMappingEntity> {

  /**
   * 删除指定的角色和组织机构之前的所有绑定关系
   * @param orgCode
   */
  @Modifying
  @Query(value="delete from engine_role_org_mapping where role_code = :roleCode and project_name=:projectName" , nativeQuery = true)
  public void deleteByRoleCodeAndProjectName(@Param("roleCode") String roleCode, @Param("projectName") String projectName);
  
  /**
   * 删除指定的组织机构和所有角色之前的绑定关系
   * @param orgCode
   */
  @Modifying
  @Query(value="delete from engine_role_org_mapping where org_code = :orgCode and project_name=:projectName" , nativeQuery = true)
  public void deleteByOrgCodeAndProjectName(@Param("orgCode") String orgCode, @Param("projectName") String projectName);
  
  /**
   * 根据角色和组织机构编码查询统计
   * @param role
   * @param orgCode
   * @return
   */
  @Query("select count(*) from RoleOrgMappingEntity rom where rom.role.roleCode = :role and rom.orgCode = :orgCode and rom.projectName=:projectName ")
  long countByRoleAndOrgCodeAndProjectName(@Param("role") String roleId, @Param("orgCode") String orgCode, @Param("projectName") String projectName);

  /**
   * 根据角色查询统计
   * @param role
   * @return
   */
  @Query("select count(*) from RoleOrgMappingEntity rom where rom.role.roleCode = :role and rom.projectName=:projectName ")
  long countByRoleAndProjectName(@Param("role") String role, @Param("projectName") String projectName);

  /**
   * 根据组织机构编码查询统计
   * @param orgCode
   * @return
   */
  @Query("select count(*) from RoleOrgMappingEntity rom where rom.orgCode = :orgCode and rom.projectName=:projectName ")
  long countByOrgCodeAndProjectName(@Param("orgCode") String orgCode, @Param("projectName") String projectName);

  /**
   * 根据角色和组织机构编码查询
   * @param role
   * @param orgCode
   */
  @Query("from RoleOrgMappingEntity rom where rom.role.roleCode = :role and rom.orgCode = :orgCode and rom.projectName=:projectName ")
  RoleOrgMappingEntity findByRoleAndOrgCodeAndProjectName(@Param("role") String role, @Param("orgCode") String orgCode, @Param("projectName") String projectName);

  /**
   * 根据组织机构编码和角色ID查询关联信息
   * @param roleIds
   * @return
   */
  @Query("select rom from RoleOrgMappingEntity rom inner join rom.role r where rom.orgCode = :orgCode and r.id in :roleIds")
  Set<RoleOrgMappingEntity> findByOrgCodeAndRoleIds(@Param("orgCode") String orgCode, @Param("roleIds") String[] roleIds);

  /**
   * 根据角色查询
   * @param role
   * @return
   */
  @Query("select rom from RoleOrgMappingEntity rom where rom.role.roleCode = :role and rom.projectName=:projectName order by rom.orgCode ASC")
  Set<RoleOrgMappingEntity> findByRoleAndProjectName(@Param("role") String role, @Param("projectName") String projectName);

  /**
   * 根据组织机构编码查询
   * @param orgCode
   * @return
   */
  @Query("select ro from RoleOrgMappingEntity ro inner join fetch ro.role r where ro.orgCode = :orgCode and ro.projectName=:projectName ")
  Set<RoleOrgMappingEntity> findDetailsByOrgCodeAndProjectName(@Param("orgCode") String orgCode, @Param("projectName") String projectName);
}
