package com.bizunited.platform.rbac.server.starter.repository;

import com.bizunited.platform.rbac.server.starter.entity.RoleUserGroupMappingEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

/**
 * 角色与用户组关联的持久层接口定义
 * @author zhaowenyu
 * @date 2020/4/2 15:36
 */
@Repository("RoleUserGroupMappingRepository")
public interface RoleUserGroupMappingRepository extends JpaRepository<RoleUserGroupMappingEntity, String>,
		JpaSpecificationExecutor<RoleUserGroupMappingEntity> {
  
  
  /**
   * 删除指定用户组和所有角色的关联信息
   * @param roleCode
   */
  @Modifying
  @Query(value = "delete from engine_role_group_mapping where group_code = :groupCode and project_name=:projectName " , nativeQuery = true)
  public void deleteByGroupCodeAndProjectName(@Param("groupCode") String groupCode, @Param("projectName") String projectName);
  
  /**
   * 删除指定角色和所有用户组的关联信息
   * @param roleCode
   */
  @Modifying
  @Query(value = "delete from engine_role_group_mapping where role_code = :roleCode and project_name=:projectName " , nativeQuery = true)
  public void deleteByRoleCodeAndProjectName(@Param("roleCode") String roleCode, @Param("projectName") String projectName);
  
  /**
   * 根据角色和用户组编码查询统计
   *
   * @param role
   * @param groupCode
   * @return
   */
  @Query("select count(*) from RoleUserGroupMappingEntity rgm where rgm.role.roleCode = :role and rgm.groupCode = :groupCode and rgm.projectName=:projectName ")
  long countByRoleAndGroupCodeProjectName(@Param("role") String role, @Param("groupCode") String groupCode, @Param("projectName") String projectName);
  /**
   * 根据角色查询统计
   *
   * @param role
   * @return
   */
  @Query("select count(*) from RoleUserGroupMappingEntity rgm where rgm.role.roleCode = :role and rgm.projectName=:projectName ")
  long countByRoleAndProjectName(@Param("role") String role, @Param("projectName") String projectName);
  /**
   * 根据组织机构编码查询统计
   *
   * @param groupCode
   * @return
   */
  @Query("select count(*) from RoleUserGroupMappingEntity rgm where rgm.groupCode = :groupCode and rgm.projectName=:projectName ")
  long countByUserGroupCodeAndProjectName(@Param("groupCode") String groupCode, @Param("projectName") String projectName);
  /**
   * 根据角色和用户组编码查询
   *
   * @param role
   * @param groupCode
   */
  @Query("from RoleUserGroupMappingEntity rgm where rgm.role.roleCode = :role and rgm.groupCode = :groupCode and rgm.projectName=:projectName ")
  RoleUserGroupMappingEntity findByRoleAndGroupCodeAndProjectName(@Param("role") String role, @Param("groupCode") String groupCode, @Param("projectName") String projectName);
  /**
   * 根据用户组编码查询角色编码集合
   * @param userGroupCode
   * @return
   */
  @Query(value = "SELECT role_code FROM engine_role_group_mapping WHERE group_code = :userGroupCode and project_name=:projectName ", nativeQuery = true)
  Set<String> findByGroupCodeAndProjectName(@Param("userGroupCode") String userGroupCode, @Param("projectName") String projectName);
  /**
   * 根据角色编码查询用户组编码集合
   * @param roleCode
   * @return
   */
  @Query(value = "SELECT group_code FROM engine_role_group_mapping WHERE role_code = :roleCode and project_name=:projectName ", nativeQuery = true)
  Set<String> findByRoleCodeAndProjectName(@Param("roleCode") String roleCode, @Param("projectName") String projectName);
  /**
   * 根据角色编码查询绑定用户组
   * @param roleCode
   * @return
   */
  @Query(value = "SELECT rgm.group_code FROM engine_role_group_mapping rgm WHERE rgm.role_code = :roleCode and rgm.project_name=:projectName ", nativeQuery = true)
  List<String> findGroupCodesByRoleCodeAndProjectName(@Param("roleCode") String roleCode, @Param("projectName") String projectName);
}
