/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.starter.service.internal;

import com.bizunited.platform.common.enums.RbacRelationEnum;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.rbac.server.service.RbacSettingService;
import com.bizunited.platform.rbac.server.service.RoleOrgMappingService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.starter.entity.RoleEntity;
import com.bizunited.platform.rbac.server.starter.entity.RoleOrgMappingEntity;
import com.bizunited.platform.rbac.server.starter.repository.RoleOrgMappingRepository;
import com.bizunited.platform.rbac.server.vo.RbacSettingVo;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.user.common.service.organization.OrganizationService;
import com.bizunited.platform.user.common.vo.OrganizationVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class RoleOrgMappingServiceImpl
implements RoleOrgMappingService {
    @Autowired
    private RbacSettingService rbacSettingService;
    @Autowired
    private RoleOrgMappingRepository roleOrgMappingRepository;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private RoleService roleService;

    @Transactional
    public void bindOrgs(String roleId, String[] orgCodes) {
        Validate.notBlank((CharSequence)roleId, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u89d2\u8272\u4fe1\u606f!", (Object[])new Object[0]);
        Validate.notEmpty((Object[])orgCodes, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u89d2\u8272\u7ed1\u5b9a\u65f6,\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u7ec4\u7ec7\u673a\u6784\u7f16\u53f7\u4fe1\u606f!", (Object[])new Object[0]);
        RoleVo role = this.roleService.findById(roleId);
        Validate.notNull((Object)role, (String)"\u672a\u627e\u5230\u89d2\u8272\u4fe1\u606f", (Object[])new Object[0]);
        RbacSettingVo rbacSetting = this.rbacSettingService.findRbacSetting();
        for (String orgCode : orgCodes) {
            OrganizationVo org = this.organizationService.findByCode(orgCode);
            Validate.notNull((Object)org, (String)"\u672a\u627e\u5230\u7ec4\u7ec7\u673a\u6784\uff1a%s", (Object[])new Object[]{orgCode});
            this.validateBindOrg(rbacSetting, role, org);
            RoleOrgMappingEntity mapping = new RoleOrgMappingEntity();
            RoleEntity currentRole = new RoleEntity();
            currentRole.setId(roleId);
            currentRole.setRoleCode(role.getRoleCode());
            mapping.setRole(currentRole);
            mapping.setOrgCode(orgCode);
            mapping.setProjectName(ApplicationContextUtils.getProjectName());
            this.roleOrgMappingRepository.save((Object)mapping);
        }
    }

    @Transactional
    public void rebindOrgs(String roleId, String[] orgCodes) {
        Validate.notBlank((CharSequence)roleId, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u89d2\u8272\u4fe1\u606f!", (Object[])new Object[0]);
        String[] currentOrgCodes = orgCodes;
        if (currentOrgCodes == null) {
            currentOrgCodes = new String[]{};
        }
        RoleVo role = this.roleService.findById(roleId);
        Validate.notNull((Object)role, (String)"\u672a\u627e\u5230\u89d2\u8272\u4fe1\u606f", (Object[])new Object[0]);
        this.roleOrgMappingRepository.deleteByRoleCodeAndProjectName(role.getRoleCode(), ApplicationContextUtils.getProjectName());
        RbacSettingVo rbacSetting = this.rbacSettingService.findRbacSetting();
        for (String orgCode : currentOrgCodes) {
            OrganizationVo org = this.organizationService.findByCode(orgCode);
            Validate.notNull((Object)org, (String)"\u672a\u627e\u5230\u7ec4\u7ec7\u673a\u6784\uff1a%s", (Object[])new Object[]{orgCode});
            this.validateBindOrg(rbacSetting, role, org);
            RoleOrgMappingEntity mapping = new RoleOrgMappingEntity();
            RoleEntity currentRole = new RoleEntity();
            currentRole.setId(roleId);
            currentRole.setRoleCode(role.getRoleCode());
            mapping.setRole(currentRole);
            mapping.setOrgCode(orgCode);
            mapping.setProjectName(ApplicationContextUtils.getProjectName());
            this.roleOrgMappingRepository.save((Object)mapping);
        }
    }

    @Transactional
    public void unbindOrgs(String roleId, String[] orgCodes) {
        Validate.notBlank((CharSequence)roleId, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u89d2\u8272\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u89d2\u8272\u4fe1\u606f!", (Object[])new Object[0]);
        Validate.isTrue((orgCodes != null && orgCodes.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u89d2\u8272\u89e3\u7ed1\u65f6,\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u7ec4\u7ec7\u673a\u6784\u7f16\u53f7\u4fe1\u606f!", (Object[])new Object[0]);
        RoleVo role = this.roleService.findById(roleId);
        Validate.notNull((Object)role, (String)"\u672a\u627e\u5230\u89d2\u8272\u4fe1\u606f:%s", (Object[])new Object[]{roleId});
        for (String orgCode : orgCodes) {
            RoleOrgMappingEntity mapping = this.roleOrgMappingRepository.findByRoleAndOrgCodeAndProjectName(role.getId(), orgCode, ApplicationContextUtils.getProjectName());
            if (mapping == null) continue;
            this.roleOrgMappingRepository.delete((Object)mapping);
        }
    }

    private void validateBindOrg(RbacSettingVo rbacSetting, RoleVo role, OrganizationVo org) {
        Validate.notNull((Object)org, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7ec4\u7ec7\u673a\u6784", (Object[])new Object[0]);
        Validate.notNull((Object)role, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u89d2\u8272", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)role.getId(), (String)"\u672a\u627e\u5230\u5bf9\u5e94\u89d2\u8272ID", (Object[])new Object[0]);
        String orgCode = org.getCode();
        long count = this.roleOrgMappingRepository.countByRoleAndOrgCodeAndProjectName(role.getRoleCode(), orgCode, ApplicationContextUtils.getProjectName());
        Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{org.getOrgName()});
        int bindRelation = rbacSetting.getRoleOrgRelation();
        if (bindRelation == RbacRelationEnum.MANY_TO_MANY.getRelation()) {
            count = this.roleOrgMappingRepository.countByRoleAndOrgCodeAndProjectName(role.getRoleCode(), orgCode, ApplicationContextUtils.getProjectName());
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u7ec4\u7ec7\u591a\u5bf9\u591a\uff0c\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[]{org.getOrgName()});
        }
        if (bindRelation == RbacRelationEnum.MANY_TO_ONE.getRelation()) {
            count = this.roleOrgMappingRepository.countByRoleAndProjectName(role.getRoleCode(), ApplicationContextUtils.getProjectName());
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u7ec4\u7ec7\u591a\u5bf9\u4e00\uff0c\u6307\u5b9a\u89d2\u8272[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[]{role.getRoleName()});
        }
        if (bindRelation == RbacRelationEnum.ONE_TO_MANY.getRelation()) {
            count = this.roleOrgMappingRepository.countByOrgCodeAndProjectName(orgCode, ApplicationContextUtils.getProjectName());
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u7ec4\u7ec7\u4e00\u5bf9\u591a\uff0c\u6307\u5b9a\u7ec4\u7ec7[%s]\u5df2\u7ed1\u5b9a\u89d2\u8272\u89d2\u8272\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[]{org.getOrgName()});
        }
        if (bindRelation == RbacRelationEnum.ONE_TO_ONE.getRelation()) {
            long countOrganization = this.roleOrgMappingRepository.countByRoleAndProjectName(role.getRoleCode(), ApplicationContextUtils.getProjectName());
            Validate.isTrue((countOrganization == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u7ec4\u7ec7\u4e00\u5bf9\u4e00\uff0c\u6307\u5b9a\u89d2\u8272[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[]{role.getRoleName()});
            long countRole = this.roleOrgMappingRepository.countByOrgCodeAndProjectName(orgCode, ApplicationContextUtils.getProjectName());
            Validate.isTrue((countRole == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u7ec4\u7ec7\u4e00\u5bf9\u4e00\uff0c\u6307\u5b9a\u7ec4\u7ec7[%s]\u4e0e\u89d2\u8272\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[]{org.getOrgName()});
        }
    }

    @Transactional
    public void bindOrgRoles(String orgCode, String[] roleIds) {
        Validate.notBlank((CharSequence)orgCode, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f!", (Object[])new Object[0]);
        Validate.notEmpty((Object[])roleIds, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u89d2\u8272\u7ed1\u5b9a\u65f6,\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u89d2\u8272ID\u4fe1\u606f!", (Object[])new Object[0]);
        OrganizationVo org = this.organizationService.findByCode(orgCode);
        Validate.notNull((Object)org, (String)"\u672a\u627e\u5230\u7ec4\u7ec7\u673a\u6784\uff1a%s", (Object[])new Object[]{orgCode});
        RbacSettingVo rbacSetting = this.rbacSettingService.findRbacSetting();
        for (String roleId : roleIds) {
            RoleVo role = this.roleService.findById(roleId);
            Validate.notNull((Object)"\u672a\u627e\u5230\u89d2\u8272\uff1a%s", (String)roleId, (Object[])new Object[0]);
            this.validateBindOrg(rbacSetting, role, org);
            RoleOrgMappingEntity mapping = new RoleOrgMappingEntity();
            RoleEntity currentRole = new RoleEntity();
            currentRole.setId(roleId);
            currentRole.setRoleCode(role.getRoleCode());
            mapping.setRole(currentRole);
            mapping.setOrgCode(orgCode);
            this.roleOrgMappingRepository.save((Object)mapping);
        }
    }

    @Transactional
    public void rebindOrgRoles(String orgCode, String[] roleIds) {
        Validate.notBlank((CharSequence)orgCode, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f!", (Object[])new Object[0]);
        String[] currentRoleIds = roleIds;
        if (currentRoleIds == null) {
            currentRoleIds = new String[]{};
        }
        OrganizationVo org = this.organizationService.findByCode(orgCode);
        Validate.notNull((Object)org, (String)"\u672a\u627e\u5230\u7ec4\u7ec7\u673a\u6784\uff1a%s", (Object[])new Object[]{orgCode});
        this.roleOrgMappingRepository.deleteByOrgCodeAndProjectName(orgCode, ApplicationContextUtils.getProjectName());
        RbacSettingVo rbacSetting = this.rbacSettingService.findRbacSetting();
        for (String roleId : currentRoleIds) {
            RoleVo role = this.roleService.findById(roleId);
            Validate.notNull((Object)"\u672a\u627e\u5230\u89d2\u8272\uff1a%s", (String)roleId, (Object[])new Object[0]);
            this.validateBindOrg(rbacSetting, role, org);
            RoleOrgMappingEntity mapping = new RoleOrgMappingEntity();
            RoleEntity currentRole = new RoleEntity();
            currentRole.setId(roleId);
            currentRole.setRoleCode(role.getRoleCode());
            mapping.setRole(currentRole);
            mapping.setOrgCode(orgCode);
            mapping.setProjectName(ApplicationContextUtils.getProjectName());
            this.roleOrgMappingRepository.save((Object)mapping);
        }
    }

    @Transactional
    public void unbindOrgRoles(String orgCode, String[] roleIds) {
        Validate.notBlank((CharSequence)orgCode, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u89d2\u8272\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f!", (Object[])new Object[0]);
        Validate.isTrue((roleIds != null && roleIds.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u89d2\u8272\u89e3\u7ed1\u65f6,\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u89d2\u8272ID\u4fe1\u606f!", (Object[])new Object[0]);
        OrganizationVo org = this.organizationService.findByCode(orgCode);
        Validate.notNull((Object)org, (String)"\u672a\u627e\u5230\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff1a%s", (Object[])new Object[]{orgCode});
        Set<RoleOrgMappingEntity> mappings = this.roleOrgMappingRepository.findByOrgCodeAndRoleIds(orgCode, roleIds);
        if (!CollectionUtils.isEmpty(mappings)) {
            this.roleOrgMappingRepository.deleteAll(mappings);
        }
    }

    public List<OrganizationVo> findByRoleId(String roleId) {
        if (StringUtils.isBlank((CharSequence)roleId)) {
            return Lists.newArrayList();
        }
        RoleVo role = this.roleService.findById(roleId);
        if (role == null) {
            return Lists.newArrayList();
        }
        Set<RoleOrgMappingEntity> roleOrgs = this.roleOrgMappingRepository.findByRoleAndProjectName(role.getRoleCode(), ApplicationContextUtils.getProjectName());
        if (CollectionUtils.isEmpty(roleOrgs)) {
            return Lists.newArrayList();
        }
        ArrayList<OrganizationVo> orgs = new ArrayList<OrganizationVo>();
        for (RoleOrgMappingEntity roleOrg : roleOrgs) {
            OrganizationVo org = this.organizationService.findByCode(roleOrg.getOrgCode());
            if (org == null) continue;
            orgs.add(org);
        }
        return orgs;
    }
}

