/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.starter.service.internal;

import com.bizunited.platform.common.enums.RbacRelationEnum;
import com.bizunited.platform.rbac.server.service.RbacSettingService;
import com.bizunited.platform.rbac.server.service.RolePositionLevelMappingService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.starter.entity.RoleEntity;
import com.bizunited.platform.rbac.server.starter.entity.RolePositionLevelMappingEntity;
import com.bizunited.platform.rbac.server.starter.repository.RolePositionLevelMappingRepository;
import com.bizunited.platform.rbac.server.vo.RbacSettingVo;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.user.common.service.position.PositionLevelService;
import com.bizunited.platform.user.common.vo.PositionLevelVo;
import java.util.HashSet;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RolePositionLevelMappingServiceImpl
implements RolePositionLevelMappingService {
    @Autowired
    private RolePositionLevelMappingRepository rolePositionLevelMappingRepository;
    @Autowired
    private PositionLevelService positionLevelService;
    @Autowired
    private RbacSettingService rbacSettingService;
    @Autowired
    private RoleService roleService;

    @Transactional
    public void bindPositionLevelRoles(String positionLevelCode, String[] roleIds) {
        Validate.notBlank((CharSequence)positionLevelCode, (String)"\u8fdb\u884c\u804c\u4f4d\u7ea7\u522b-\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u804c\u4f4d\u7ea7\u522b\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((roleIds != null && roleIds.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u804c\u4f4d\u7ea7\u522b-\u89d2\u8272\u7ed1\u5b9a\u65f6,\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u89d2\u8272id\u4fe1\u606f!!", (Object[])new Object[0]);
        RbacSettingVo rbacSetting = this.rbacSettingService.findRbacSetting();
        PositionLevelVo positionLevelVo = this.positionLevelService.findByCode(positionLevelCode);
        Validate.notNull((Object)positionLevelVo, (String)"\u672a\u627e\u5230\u804c\u4f4d\u7ea7\u522b\uff1a%s", (Object[])new Object[]{positionLevelCode});
        for (String roleId : roleIds) {
            RoleVo role = this.roleService.findById(roleId);
            Validate.notNull((Object)role, (String)"\u672a\u627e\u5230\u89d2\u8272\u4fe1\u606f\uff1a%s", (Object[])new Object[]{roleId});
            this.validateBindPosition(rbacSetting, role, positionLevelVo);
            RolePositionLevelMappingEntity mapping = new RolePositionLevelMappingEntity();
            RoleEntity currentRole = new RoleEntity();
            currentRole.setId(roleId);
            currentRole.setRoleCode(role.getRoleCode());
            mapping.setRole(currentRole);
            mapping.setPositionLevelCode(positionLevelCode);
            this.rolePositionLevelMappingRepository.save((Object)mapping);
        }
    }

    @Transactional
    public void rebindPositionLevelRoles(String positionLevelCode, String[] roleIds) {
        Validate.notBlank((CharSequence)positionLevelCode, (String)"\u4f20\u5165\u7684\u804c\u4f4d\u7ea7\u522b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        PositionLevelVo positionLevelVo = this.positionLevelService.findByCode(positionLevelCode);
        Validate.notNull((Object)positionLevelVo, (String)"\u672a\u627e\u5230\u804c\u4f4d\u7ea7\u522b\uff1a%s", (Object[])new Object[]{positionLevelCode});
        HashSet<String> currentRoleIds = new HashSet<String>();
        if (roleIds != null) {
            for (String roleId : roleIds) {
                currentRoleIds.add(roleId);
            }
        }
        this.rolePositionLevelMappingRepository.unbindPositionLevelCode(positionLevelCode);
        this.bindPositionLevelRoles(positionLevelCode, roleIds);
    }

    @Transactional
    public void unbindPositionLevelRoles(String positionLevelCode, String[] roleIds) {
        Validate.notBlank((CharSequence)positionLevelCode, (String)"\u8fdb\u884c\u804c\u4f4d\u7ea7\u522b-\u89d2\u8272\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u804c\u4f4d\u7ea7\u522b\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((roleIds != null && roleIds.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u804c\u4f4d\u7ea7\u522b-\u89d2\u8272\u89e3\u7ed1\u65f6,\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u89d2\u8272id\u4fe1\u606f!!", (Object[])new Object[0]);
        for (String roleId : roleIds) {
            RoleVo role = this.roleService.findById(roleId);
            Validate.notNull((Object)role, (String)"\u672a\u627e\u5230\u89d2\u8272\u4fe1\u606f\uff1a%s", (Object[])new Object[]{roleId});
            RolePositionLevelMappingEntity mapping = this.rolePositionLevelMappingRepository.findByRoleAndPositionLevelCode(role.getRoleCode(), positionLevelCode);
            if (mapping == null) continue;
            this.rolePositionLevelMappingRepository.delete((Object)mapping);
        }
    }

    private void validateBindPosition(RbacSettingVo rbacSetting, RoleVo role, PositionLevelVo positionLevelVo) {
        long count = this.rolePositionLevelMappingRepository.countByRoleAndPositionLevel(role.getRoleCode(), positionLevelVo.getCode());
        Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u6307\u5b9a\u804c\u4f4d\u7ea7\u522b[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{positionLevelVo.getName()});
        if (rbacSetting.getRolePositionRelation() == RbacRelationEnum.MANY_TO_ONE.getRelation()) {
            count = this.rolePositionLevelMappingRepository.countByRole(role.getRoleCode());
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u804c\u4f4d\u7ea7\u522b\u591a\u5bf9\u4e00\uff0c\u6307\u5b9a\u89d2\u8272[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u804c\u4f4d\u7ea7\u522b\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{role.getRoleName()});
        }
    }
}

