/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.starter.service.internal;

import com.bizunited.platform.common.enums.RbacRelationEnum;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.rbac.server.service.RbacSettingService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.service.RoleUserGroupMappingService;
import com.bizunited.platform.rbac.server.starter.entity.RoleEntity;
import com.bizunited.platform.rbac.server.starter.entity.RoleUserGroupMappingEntity;
import com.bizunited.platform.rbac.server.starter.repository.RoleUserGroupMappingRepository;
import com.bizunited.platform.rbac.server.vo.RbacSettingVo;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.user.common.service.userGroup.UserGroupService;
import com.bizunited.platform.user.common.vo.UserGroupVo;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class RoleUserGroupMappingServiceImpl
implements RoleUserGroupMappingService {
    @Autowired
    private RbacSettingService rbacSettingService;
    @Autowired
    private RoleUserGroupMappingRepository roleUserGroupMappingRepository;
    @Autowired
    private UserGroupService userGroupService;
    @Autowired
    private RoleService roleService;

    @Transactional
    public void bindUserGroups(String roleId, String[] userGroupCodes) {
        Validate.notBlank((CharSequence)roleId, (String)"\u8fdb\u884c\u7528\u6237\u7ec4-\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u89d2\u8272\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((userGroupCodes != null && userGroupCodes.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u7528\u6237\u7ec4-\u89d2\u8272\u7ed1\u5b9a\u65f6,\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u7ec4\u7ec7\u673a\u6784\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[0]);
        RoleVo role = this.roleService.findById(roleId);
        Validate.notNull((Object)role, (String)"\u672a\u627e\u5230\u89d2\u8272\u4fe1\u606f", (Object[])new Object[0]);
        RbacSettingVo rbacSettingVo = this.rbacSettingService.findRbacSetting();
        for (String code : userGroupCodes) {
            UserGroupVo userGroupVo = this.userGroupService.findByCode(code);
            Validate.notNull((Object)userGroupCodes, (String)"\u672a\u627e\u5230\u7528\u6237\u7ec4\uff1a%s", (Object[])new Object[]{code});
            this.validateBindRole(rbacSettingVo, role, userGroupVo);
            RoleUserGroupMappingEntity entity = new RoleUserGroupMappingEntity();
            RoleEntity currentRole = new RoleEntity();
            currentRole.setId(roleId);
            currentRole.setRoleCode(role.getRoleCode());
            entity.setRole(currentRole);
            entity.setGroupCode(code);
            this.roleUserGroupMappingRepository.save((Object)entity);
        }
    }

    @Transactional
    public void unbindUserGroups(String roleId, String[] userGroupCodes) {
        Validate.notBlank((CharSequence)roleId, (String)"\u8fdb\u884c\u7528\u6237\u7ec4-\u89d2\u8272\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u89d2\u8272\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((userGroupCodes != null && userGroupCodes.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u7528\u6237\u7ec4-\u89d2\u8272\u89e3\u7ed1\u65f6,\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u7528\u6237\u7ec4\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[0]);
        RoleVo role = this.roleService.findById(roleId);
        Validate.notNull((Object)role, (String)"\u672a\u627e\u5230\u89d2\u8272\u4fe1\u606f", (Object[])new Object[0]);
        for (String code : userGroupCodes) {
            RoleUserGroupMappingEntity entity = this.roleUserGroupMappingRepository.findByRoleAndGroupCodeAndProjectName(role.getRoleCode(), code, ApplicationContextUtils.getProjectName());
            if (entity == null) continue;
            this.roleUserGroupMappingRepository.delete((Object)entity);
        }
    }

    @Transactional
    public void reBindUserGroup(String roleId, String[] userGroupCodes) {
        Validate.notBlank((CharSequence)roleId, (String)"\u89d2\u8272\u7ed1\u5b9a\u7528\u6237\u7ec4\u65f6\uff0c\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RoleVo role = this.roleService.findById(roleId);
        Validate.notNull((Object)role, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u89d2\u8272\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        String[] currentUserGroupCodes = userGroupCodes;
        if (currentUserGroupCodes == null) {
            currentUserGroupCodes = new String[]{};
        }
        this.roleUserGroupMappingRepository.deleteByRoleCodeAndProjectName(role.getRoleCode(), ApplicationContextUtils.getProjectName());
        RbacSettingVo rbacSettingVo = this.rbacSettingService.findRbacSetting();
        for (String groupCode : currentUserGroupCodes) {
            UserGroupVo userGroupVo = this.userGroupService.findByCode(groupCode);
            Validate.notNull((Object)userGroupVo, (String)"\u672a\u627e\u5230\u7528\u6237\u7ec4\uff1a%s", (Object[])new Object[]{groupCode});
            this.validateBindRole(rbacSettingVo, role, userGroupVo);
            RoleUserGroupMappingEntity mapping = new RoleUserGroupMappingEntity();
            RoleEntity currentRole = new RoleEntity();
            currentRole.setId(roleId);
            currentRole.setRoleCode(role.getRoleCode());
            mapping.setRole(currentRole);
            mapping.setGroupCode(groupCode);
            mapping.setProjectName(ApplicationContextUtils.getProjectName());
            this.roleUserGroupMappingRepository.save((Object)mapping);
        }
    }

    private void validateBindRole(RbacSettingVo rbacSettingVo, RoleVo role, UserGroupVo userGroupVo) {
        long count = this.roleUserGroupMappingRepository.countByRoleAndGroupCodeProjectName(role.getId(), userGroupVo.getGroupCode(), ApplicationContextUtils.getProjectName());
        Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6\u6307\u5b9a\u7528\u6237\u7ec4[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userGroupVo.getGroupName()});
        int bindRelation = rbacSettingVo.getRoleGroupRelation();
        if (bindRelation == RbacRelationEnum.MANY_TO_MANY.getRelation()) {
            count = this.roleUserGroupMappingRepository.countByRoleAndGroupCodeProjectName(role.getRoleCode(), userGroupVo.getGroupCode(), ApplicationContextUtils.getProjectName());
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u7528\u6237\u7ec4\u591a\u5bf9\u591a\uff0c\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userGroupVo.getGroupName()});
        }
        if (bindRelation == RbacRelationEnum.MANY_TO_ONE.getRelation()) {
            count = this.roleUserGroupMappingRepository.countByRoleAndProjectName(role.getRoleCode(), ApplicationContextUtils.getProjectName());
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u7528\u6237\u7ec4\u591a\u5bf9\u4e00\uff0c\u6307\u5b9a\u89d2\u8272[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u7528\u6237\u7ec4\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{role.getRoleName()});
        }
        if (bindRelation == RbacRelationEnum.ONE_TO_MANY.getRelation()) {
            count = this.roleUserGroupMappingRepository.countByUserGroupCodeAndProjectName(userGroupVo.getGroupCode(), ApplicationContextUtils.getProjectName());
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u7528\u6237\u7ec4\u4e00\u5bf9\u591a\uff0c\u6307\u5b9a\u7528\u6237\u7ec4[%s]\u89d2\u8272\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userGroupVo.getGroupName()});
        }
        if (bindRelation == RbacRelationEnum.ONE_TO_ONE.getRelation()) {
            count = this.roleUserGroupMappingRepository.countByRoleAndProjectName(role.getRoleCode(), ApplicationContextUtils.getProjectName());
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u7528\u6237\u7ec4\u4e00\u5bf9\u4e00\uff0c\u6307\u5b9a\u89d2\u8272[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u7528\u6237\u7ec4\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{role.getRoleName()});
            long countRole = this.roleUserGroupMappingRepository.countByUserGroupCodeAndProjectName(userGroupVo.getGroupCode(), ApplicationContextUtils.getProjectName());
            Validate.isTrue((countRole == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u7528\u6237\u7ec4\u4e00\u5bf9\u4e00\uff0c\u6307\u5b9a\u7528\u6237\u7ec4[%s]\u89d2\u8272\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{userGroupVo.getGroupName()});
        }
    }

    @Transactional
    public void bindUserGroupRoles(String userGroupCode, String[] roleIds) {
        Validate.notBlank((CharSequence)userGroupCode, (String)"\u8fdb\u884c\u7528\u6237\u7ec4-\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7528\u6237\u7ec4\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((roleIds != null && roleIds.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u7528\u6237\u7ec4-\u89d2\u8272\u7ed1\u5b9a\u65f6,\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u89d2\u8272id\u4fe1\u606f!!", (Object[])new Object[0]);
        UserGroupVo userGroupVo = this.userGroupService.findByCode(userGroupCode);
        Validate.notNull((Object)userGroupVo, (String)"\u672a\u627e\u5230\u7528\u6237\u7ec4: %s", (Object[])new Object[]{userGroupCode});
        RbacSettingVo rbacSetting = this.rbacSettingService.findRbacSetting();
        for (String roleId : roleIds) {
            RoleVo role = this.roleService.findById(roleId);
            Validate.notNull((Object)role, (String)"\u672a\u627e\u5230\u89d2\u8272\u4fe1\u606f\uff1a%s", (Object[])new Object[]{roleId});
            this.validateBindRole(rbacSetting, role, userGroupVo);
            RoleUserGroupMappingEntity mapping = new RoleUserGroupMappingEntity();
            RoleEntity currentRole = new RoleEntity();
            currentRole.setId(role.getId());
            currentRole.setRoleCode(role.getRoleCode());
            mapping.setRole(currentRole);
            mapping.setGroupCode(userGroupCode);
            mapping.setProjectName(ApplicationContextUtils.getProjectName());
            this.roleUserGroupMappingRepository.saveAndFlush((Object)mapping);
        }
    }

    @Transactional
    public void unbindUserGroupRoles(String userGroupCode, String[] roleIds) {
        Validate.notBlank((CharSequence)userGroupCode, (String)"\u8fdb\u884c\u7528\u6237\u7ec4-\u89d2\u8272\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u7528\u6237\u7ec4\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((roleIds != null && roleIds.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u7528\u6237\u7ec4-\u89d2\u8272\u7ed1\u5b9a\u65f6,\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u89d2\u8272id\u4fe1\u606f!!", (Object[])new Object[0]);
        for (String roleId : roleIds) {
            RoleVo role = this.roleService.findById(roleId);
            Validate.notNull((Object)role, (String)"\u672a\u627e\u5230\u89d2\u8272\u4fe1\u606f\uff1a%s", (Object[])new Object[]{roleId});
            RoleUserGroupMappingEntity mapping = this.roleUserGroupMappingRepository.findByRoleAndGroupCodeAndProjectName(role.getRoleCode(), userGroupCode, ApplicationContextUtils.getProjectName());
            if (mapping == null) continue;
            this.roleUserGroupMappingRepository.delete((Object)mapping);
        }
    }

    @Transactional
    public void reBindUserGroupRoles(String userGroupCode, String[] roleCodes) {
        Validate.notBlank((CharSequence)userGroupCode, (String)"\u7528\u6237\u7ec4\u91cd\u65b0\u8fdb\u884c\u89d2\u8272\u7ed1\u5b9a\uff0c\u7528\u6237\u7ec4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserGroupVo userGroupVo = this.userGroupService.findByCode(userGroupCode);
        Validate.notNull((Object)userGroupVo, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7528\u6237\u7ec4\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        String[] currentRoleCodes = roleCodes;
        if (currentRoleCodes == null) {
            currentRoleCodes = new String[]{};
        }
        this.roleUserGroupMappingRepository.deleteByGroupCodeAndProjectName(userGroupVo.getGroupCode(), ApplicationContextUtils.getProjectName());
        RbacSettingVo rbacSettingVo = this.rbacSettingService.findRbacSetting();
        for (String roleCode : currentRoleCodes) {
            RoleVo role = this.roleService.findByCode(roleCode);
            Validate.notNull((Object)role, (String)"\u672a\u627e\u5230\u7f16\u7801\u4e3a[%s]\u89d2\u8272,\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{roleCode});
            this.validateBindRole(rbacSettingVo, role, userGroupVo);
            RoleUserGroupMappingEntity mapping = new RoleUserGroupMappingEntity();
            RoleEntity currentRole = new RoleEntity();
            currentRole.setId(role.getId());
            currentRole.setRoleCode(role.getRoleCode());
            mapping.setRole(currentRole);
            mapping.setGroupCode(userGroupCode);
            mapping.setProjectName(ApplicationContextUtils.getProjectName());
            this.roleUserGroupMappingRepository.save((Object)mapping);
        }
    }

    public List<UserGroupVo> findByRoleCode(String roleCode) {
        if (StringUtils.isBlank((CharSequence)roleCode)) {
            return Lists.newArrayList();
        }
        List<String> groupCodes = this.roleUserGroupMappingRepository.findGroupCodesByRoleCodeAndProjectName(roleCode, ApplicationContextUtils.getProjectName());
        List userGroups = this.userGroupService.findByGroupCodes(groupCodes);
        if (CollectionUtils.isEmpty((Collection)userGroups)) {
            return Lists.newArrayList();
        }
        return userGroups;
    }
}

