package com.bizunited.platform.rbac.server.starter.repository;

import com.bizunited.platform.rbac.server.starter.entity.RoleEntity;
import com.bizunited.platform.rbac.server.starter.repository.internal.RoleRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

/**
 * @author yinwenjie
 */
@Repository("RoleRepository")
public interface RoleRepository
    extends
      JpaRepository<RoleEntity, String>,
      JpaSpecificationExecutor<RoleEntity>,
      RoleRepositoryCustom {
  
  /**
   * 形成功能和角色的绑定关系，如果重复绑定，则会报错
   * @param competenceId
   * @param roleId
   */
  @Modifying
  @Query(value="insert into engine_role_competence_mapping(role_id , competence_id) values (:roleId , :competenceId)" , nativeQuery=true)
  void bindCompetence(@Param("competenceId") String competenceId, @Param("roleId") String roleId);
  /**
   * 查询符合角色状态的信息
   * @param useStatus
   * @return
   */
  List<RoleEntity> findByTstatus(@Param("useStatus") Integer useStatus);
  /**
   * 按照填写的角色业务编号进行判断
   * @param roleCode
   * @return
   */
  RoleEntity findByRoleCode(String roleCode);
  /**
   * 查询指定的后台用户所绑定的角色信息(只包括角色基本信息)
   * @return
   */
  @Query("select distinct r from RoleEntity r inner join fetch r.roleUserMapping a where a.userAccount = :userAccount")
  List<RoleEntity> findByUserAccount(@Param("userAccount") String userAccount);
  /**
   * 查询指定的功能描述所绑定的角色信息
   * @param competenceId 功能描述信息
   * @return 
   */
  @Query("select distinct r from RoleEntity r inner join r.buttons b inner join b.competences c where c.id = :competenceId")
  List<RoleEntity> findByCompetenceId(@Param("competenceId") String competenceId);
  /**
   * 按照角色名，查询指定的角色信息
   * @param roleName
   * @return
   */
  RoleEntity findByRoleName(String roleName);

  /**
   * 查询多个角色信息
   * @param ids
   * @return
   */
  @Query("from RoleEntity m where m.id in :ids")
  Set<RoleEntity> findByIds(@Param("ids") List<String> ids);

  /**
   * 查询根角色
   * @return
   */
  Set<RoleEntity> findByParentIsNull();

  /**
   * 根据岗位编码查询关联的角色信息
   * @param positionCode
   * @return
   */
  @Query("select r from RoleEntity r inner join r.rolePositionMappings rpm where rpm.positionCode = :positionCode")
  Set<RoleEntity> findByPosition(@Param("positionCode") String positionCode);

  /**
   * 根据岗位编码批量查询绑定的角色
   * @param positionCodes
   * @return
   */
  @Query("select  r from RoleEntity r inner join r.rolePositionMappings rpm where rpm.positionCode in :positionCodes")
  Set<RoleEntity> findByPositions(@Param("positionCodes") List<String> positionCodes);

  /**
   * 根据组织机构编码查询角色
   * @param orgCode
   */
  @Query("select r from RoleEntity r inner join r.roleOrgMappings rom where rom.orgCode = :orgCode")
  Set<RoleEntity> findByOrgCode(@Param("orgCode") String orgCode);

  /**
   * 根据用户组编码查询角色
   * @param userGroupCode
   * @return
   */
  @Query("select r  from  RoleEntity r inner join r.roleUserGroupMappings rgm where rgm.groupCode = :userGroupCode")
  Set<RoleEntity> findByUserGroupCode(@Param("userGroupCode") String userGroupCode);

  /**
   * 根据多个角色名称查询
   * @param roleNames
   * @return
   */
  @Query("from RoleEntity r where r.roleName in :roleNames")
  Set<RoleEntity> findByRoleNames(@Param("roleNames") Set<String> roleNames);

  /**
   * 根据角色编码删除
   * @param roleCode
   */
  @Modifying
  @Query(value = "delete from engine_role where role_code = :roleCode" , nativeQuery = true)
  void deleteByRoleCode(@Param("roleCode") String roleCode);

  /**
   * 根据多个角色编码查询
   * @param roleCodes
   * @return
   */
  @Query("from RoleEntity r where r.roleCode in :roleCodes")
  Set<RoleEntity> findByRoleCodes(@Param("roleCodes") Set<String> roleCodes);
}
