package com.bizunited.platform.rbac.server.starter.service.internal;

import java.util.Set;

import javax.transaction.Transactional;

import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;

import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.service.RoleUserMappingService;
import com.bizunited.platform.rbac.server.starter.entity.RoleEntity;
import com.bizunited.platform.rbac.server.starter.entity.RoleUserMappingEntity;
import com.bizunited.platform.rbac.server.starter.repository.RoleUserMappingRepository;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import com.google.common.collect.Sets;

public class RoleUserMappingServiceImpl implements RoleUserMappingService {

  @Autowired
  private UserService userService;
  @Autowired
  private RoleService roleService;
  @Autowired
  private RoleUserMappingRepository roleUserMappingRepository;
  
  @Override
  @Transactional
  public void bindUserRoles(String account, String[] roleCodes) {
    Validate.notBlank(account, "绑定权限时，用户账号不能为空");
    UserVo user = userService.findByAccount(account);
    Validate.notNull(user, "用户不存在");
    Validate.isTrue(roleCodes != null && roleCodes.length > 0 , "在进行角色绑定时，请至少传入一个角色名信息");
    // 查询role names
    Set<RoleVo> roles = this.roleService.findByRoleCodes(Sets.newHashSet(roleCodes));
    Validate.notNull(roles , "未找到指定的多个角色（名）信息!!");
    Validate.isTrue(!roles.isEmpty() && roles.size() == roleCodes.length  , "未找到指定的多个角色（名）信息!!");

    // 开始添加（不用做存在性判断，没有自然会报错）
    for (RoleVo role : roles) {
      // 一般来说，这里抛出异常就是重复绑定
      long count = roleUserMappingRepository.countByRoleCodeAndUserAccount(role.getRoleCode(), user.getAccount());
      Validate.isTrue(count == 0L, "角色编码[%s]与用户[%s]重复绑定请检查", role.getRoleCode(), user.getAccount());
      RoleUserMappingEntity entity = new RoleUserMappingEntity();
      RoleEntity currentRole = new RoleEntity();
      currentRole.setId(role.getId());
      currentRole.setRoleCode(role.getRoleCode());
      entity.setRole(currentRole);
      entity.setUserAccount(user.getAccount());
      roleUserMappingRepository.save(entity);
    }
  }

  @Override
  @Transactional
  public void reBindUserRoles(String account, String[] roleCodes) {
    Validate.notBlank(account, "绑定权限时，用户账号不能为空");
    UserVo user = userService.findByAccount(account);
    Validate.notNull(user, "用户不存在");
    Validate.notEmpty(roleCodes, "绑定或者解绑必须保证用户拥有至少一个直接绑定的角色!!");
    // 查询role names
    Set<RoleVo> roles = this.roleService.findByRoleCodes(Sets.newHashSet(roleCodes));
    Validate.notNull(roles , "未找到指定的多个角色（名）信息!!");
    Validate.isTrue(!roles.isEmpty() && roles.size() == roleCodes.length  , "未找到指定的多个角色（名）信息!!");
    
    // 首先删除以前的绑定信息
    this.roleUserMappingRepository.deleteByUserAccount(user.getAccount());
    // 然后重新进行绑定
    for (RoleVo role : roles) {
      // 一般来说，这里抛出异常就是重复绑定
      long count = roleUserMappingRepository.countByRoleCodeAndUserAccount(role.getRoleCode(), user.getAccount());
      Validate.isTrue(count == 0L, "角色编码[%s]与用户[%s]重复绑定请检查", role.getRoleCode(), user.getAccount());
      RoleUserMappingEntity entity = new RoleUserMappingEntity();
      RoleEntity currentRole = new RoleEntity();
      currentRole.setId(role.getId());
      currentRole.setRoleCode(role.getRoleCode());
      entity.setRole(currentRole);
      entity.setUserAccount(user.getAccount());
      roleUserMappingRepository.save(entity);
    }
  }

}
