package com.bizunited.platform.rbac.server.starter.repository.internal;


import com.bizunited.platform.user.common.vo.PositionLevelSimpleVo;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * @author: chengzhongxiang
 * @Date: 2020-9-25 15:57:58
 * @Description:
 */
@Repository("RolePositionLevelMappingRepositoryCustom")
public interface RolePositionLevelMappingRepositoryCustom {

  /**
   * 分页查询
   * @param condition
   * @param pageable
   * @return
   */
  Page<PositionLevelSimpleVo> findByConditions(Map<String,Object> condition, Pageable pageable);

  /**
   * 根据职级编码查询角色和职级信息
   * @param positionLevelCode
   * @return
   */
  List<PositionLevelSimpleVo> findDetailsByPositionLevelCode(@Param("positionLevelCode") String positionLevelCode);
}
