package com.bizunited.platform.rbac.server.starter.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

/**
 *角色与岗位关联模型
 *@author: pangdajin
 *@date: 31/03/2020 10:00
 */
@Entity
@ApiModel(value = "RolePositionMappingEntity" , description="角色与岗位关联模型")
@Table(name = "engine_role_position_mapping",uniqueConstraints = @UniqueConstraint(columnNames = {"role_code","position_code"}))
@org.hibernate.annotations.Table(appliesTo = "engine_role_position_mapping",comment = "角色与岗位关联模型")
public class RolePositionMappingEntity extends UuidEntity {

  private static final long serialVersionUID = 3168525731382051580L;

  /**
   * 角色编码
   */
  @ApiModelProperty("角色编码")
  @ManyToOne(fetch = FetchType.LAZY)
  @SaturnColumn(description="角色编码")
  @JoinColumn(name = "role_code", nullable = false, referencedColumnName = "role_code", columnDefinition = "varchar(64) COMMENT '角色编码'")
  private RoleEntity role;

  /**
   * 岗位的唯一编号
   */
  @SaturnColumn(description = "岗位的唯一编号")
  @ApiModelProperty(name = "positionCode", value = "岗位的唯一编号", required = true)
  @Column(name = "position_code", nullable = false, columnDefinition = "varchar(128) COMMENT '岗位的唯一编号'")
  private String positionCode;


  public String getPositionCode() {
    return positionCode;
  }
  public void setPositionCode(String positionCode) {
    this.positionCode = positionCode;
  }

  public RoleEntity getRole() {
    return role;
  }

  public void setRole(RoleEntity role) {
    this.role = role;
  }
}
