/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.starter.controller;

import com.alibaba.fastjson.JSONArray;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/roles"})
public class RoleController
extends BaseController {
    @Autowired
    private RoleService roleService;
    @Value(value="${rbac.ignoreMethodCheckRoles:ADMIN}")
    private String[] ignoreMethodCheckRoles;
    private static final Logger LOGGER = LoggerFactory.getLogger(RoleController.class);

    @ApiOperation(value="\u6dfb\u52a0\u4e00\u4e2a\u89d2\u8272\u4fe1\u606f")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseModel addRole(@RequestBody @ApiParam(value="role", name="\u65b0\u5efa\u7684\u89d2\u8272\u5bf9\u8c61") RoleVo role) {
        try {
            if (role == null) {
                throw new IllegalArgumentException("role info not be null!");
            }
            RoleVo currentRole = this.roleService.create(role);
            return this.buildHttpResultW(currentRole, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u4e00\u4e2a\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f\uff0c\u6ce8\u610f\u914d\u7f6e\u5728roles.sDeny\u5c5e\u6027\u7684\u4fe1\u606f\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u3002\u4e14\u6307\u5b9a\u7684\u4e00\u4e2a\u89d2\u8272\u53ea\u80fd\u4fee\u6539\u89d2\u8272\u7684comment\u4fe1\u606f")
    @RequestMapping(value={""}, method={RequestMethod.PATCH})
    public ResponseModel updateRole(@RequestBody @ApiParam(value="role", name="\u4fee\u6539\u7684\u89d2\u8272\u5bf9\u8c61") RoleVo role) {
        try {
            RoleVo currentRole = this.roleService.update(role);
            return this.buildHttpResultW(currentRole, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u91cd\u65b0\u542f\u7528\u67d0\u4e00\u4e2a\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f")
    @RequestMapping(value={"/enable"}, method={RequestMethod.PATCH})
    public ResponseModel enableRole(@RequestBody String[] roleIds) {
        try {
            this.roleService.enable(roleIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7981\u7528\u67d0\u4e00\u4e2a\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f\uff08\u76f8\u5f53\u4e8e\u5220\u9664\uff09<br>\u53ea\u662f\u7cfb\u7edf\u4e2d\u4e0d\u80fd\u771f\u6b63\u7684\u5220\u9664\u67d0\u4e00\u4e2a\u89d2\u8272\uff0c\u53ea\u80fd\u662f\u5c06\u8fd9\u4e2a\u89d2\u8272\u4f5c\u5e9f\u6389\u6216\u8005\u6062\u590d\u6b63\u5e38\u72b6\u6001")
    @RequestMapping(value={"/disable"}, method={RequestMethod.PATCH})
    public ResponseModel disableRole(@RequestBody String[] roleIds) {
        try {
            this.roleService.disable(roleIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByOrgCode"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u67e5\u8be2\u7ed1\u5b9a\u7684\u89d2\u8272")
    public ResponseModel findByOrgCode(@RequestParam @ApiParam(value="\u7ec4\u7ec7\u673a\u6784\u7f16\u7801") String orgCode) {
        try {
            List roles = this.roleService.findByOrgCode(orgCode);
            return this.buildHttpResultW(roles, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u5c97\u4f4d\u7f16\u53f7\u67e5\u8be2\u76f4\u63a5\u5173\u8054\u7684\u89d2\u8272")
    @GetMapping(value={"/findByPositionCode"})
    public ResponseModel findByPositionCode(@ApiParam(value="\u5c97\u4f4d\u7f16\u53f7") @RequestParam String positionCode) {
        try {
            Set result = this.roleService.findByPositionCode(positionCode);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u7ec4\u7f16\u7801\u67e5\u8be2\u7ed1\u5b9a\u7684\u89d2\u8272")
    @GetMapping(value={"/findByGroupCode"})
    public ResponseModel findByGroupCode(@ApiParam(name="userGroupCode", value="\u7528\u6237\u7ec4\u7f16\u7801") @RequestParam(value="userGroupCode") String userGroupCode) {
        try {
            List roles = this.roleService.findByGroupCode(userGroupCode);
            return this.buildHttpResult(roles);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8be5\u63a5\u53e3\u65b9\u6cd5\u7528\u4e8e\u67e5\u8be2\u7b26\u5408\u6307\u5b9a\u72b6\u6001\u7684\u89d2\u8272\u4fe1\u606f\uff0c\u53ea\u8fd4\u56de\u89d2\u8272\u7684\u57fa\u672c\u4fe1\u606f\uff0c\u6ca1\u6709\u4efb\u4f55\u7684\u5173\u8054\u4fe1\u606f\u4f46\u662f\u5305\u62ec\u4e86\u53ef\u80fd\u5b58\u5728\u7684\u4fee\u6539\u8005\u4fe1\u606f\u3002")
    @RequestMapping(value={"/findByStatus"}, method={RequestMethod.GET})
    public ResponseModel findByStatus(Integer status) {
        try {
            List roles = this.roleService.findByStatus(status);
            return this.buildHttpResultW(roles, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u4e00\u4e2a\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f\uff0c\u53ea\u67e5\u8be2\u8fd9\u4e2a\u89d2\u8272\u7684\u57fa\u672c\u4fe1\u606f")
    @RequestMapping(value={"/find/{roleId}"}, method={RequestMethod.GET})
    public ResponseModel findById(@PathVariable(value="roleId") String roleId) {
        try {
            RoleVo currentRole = this.roleService.findById(roleId);
            return this.buildHttpResultW(currentRole, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u5df2\u62e5\u6709\u7684\u89d2\u8272\u4fe1\u606f\uff0c\u5305\u62ec\u81ea\u5df1\u7ed1\u5b9a\u7684\uff0c\u6240\u5c5e\u7ec4\u7ec7\u673a\u6784\u7684\uff0c\u6240\u5c5e\u7528\u6237\u7ec4\u7684\uff0c\u751a\u81f3\u7b2c\u4e09\u65b9\u7cfb\u7edf\u7684\uff0c\u7b49\u7b49", notes="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u5df2\u62e5\u6709\u7684\u89d2\u8272\u4fe1\u606f\uff0c\u5305\u62ec\u81ea\u5df1\u7ed1\u5b9a\u7684\uff0c\u6240\u5c5e\u7ec4\u7ec7\u673a\u6784\u7684\uff0c\u6240\u5c5e\u7528\u6237\u7ec4\u7684\uff0c\u751a\u81f3\u7b2c\u4e09\u65b9\u7cfb\u7edf\u7684\uff0c\u7b49\u7b49,\u56e0\u4e3a\u6709\u4e3b\u526f\u5c97\u4f4d\u4e4b\u5206\uff0c\u5728\u67e5\u8be2\u7528\u6237\u7684\u89d2\u8272\u7528\u4e8e\u6743\u9650\u9a8c\u8bc1\u65f6\uff0c\u5c97\u4f4d\u7ed1\u5b9a\u7684\u89d2\u8272\u53ea\u4f1a\u67e5\u8be2\u4e3b\u5c97\u4f4d\u7ed1\u5b9a\u7684\u89d2\u8272\uff0c\u7528\u6237\u89d2\u8272\u7ef4\u62a4\u65f6\uff0c\u5219\u8fd4\u56de\u7528\u6237\u6240\u6709\u5c97\u4f4d\u7ed1\u5b9a\u7684\u89d2\u8272")
    @RequestMapping(value={"/findAllByUserId"}, method={RequestMethod.GET})
    public ResponseModel findAllByUserId(@ApiParam(value="\u6307\u5b9a\u7684\u4eba\u5458\u6570\u636e\u7f16\u53f7") @RequestParam String userId, @RequestParam(defaultValue="0") @ApiParam(value="\u67e5\u8be2\u7c7b\u578b\uff0c\u4e0d\u4f20\u9ed8\u8ba4\u4e3a0\uff0c0\uff1a\u53ea\u662f\u67e5\u8be2\u7528\u6237\u7684\u89d2\u8272\u7528\u4e8e\u6743\u9650\u9a8c\u8bc1\uff0c1\uff1a\u67e5\u8be2\u7528\u6237\u7684\u89d2\u8272\u7528\u4e8e\u89d2\u8272\u7ef4\u62a4") Integer type) {
        try {
            List nowList = this.roleService.findAllByUserId(userId, type);
            return this.buildHttpResult(nowList);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237ID\u67e5\u8be2\u7528\u6237\u76f4\u63a5\u5173\u8054\u7684\u89d2\u8272\uff0c\u4e0d\u5305\u62ec\u89d2\u8272\u7684\u4efb\u4f55\u5173\u8054\u4fe1\u606f")
    @GetMapping(value={"/findByUserId"})
    public ResponseModel findByUserId(@ApiParam(value="\u6307\u5b9a\u7684\u4eba\u5458\u6570\u636e\u7f16\u53f7") @RequestParam String userId) {
        try {
            Set roleSet = this.roleService.findByUserId(userId);
            return this.buildHttpResultW(roleSet, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237account\u8d26\u6237\u4fe1\u606f\u67e5\u8be2\u7528\u6237\u76f4\u63a5\u5173\u8054\u7684\u89d2\u8272\uff0c\u4e0d\u5305\u62ec\u89d2\u8272\u7684\u4efb\u4f55\u5173\u8054\u4fe1\u606f")
    @GetMapping(value={"/findByUserAccount"})
    public ResponseModel findByUserAccount(@ApiParam(value="\u6307\u5b9a\u7684\u4eba\u5458account\u8d26\u6237\u4fe1\u606f") @RequestParam String userAccount) {
        try {
            Set roleSet = this.roleService.findByUserAccount(userAccount);
            return this.buildHttpResultW(roleSet, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8be5\u65b9\u6cd5\u7ed9\u5b9a\u4e00\u6279\u89d2\u8272\u540d\uff0c\u7cfb\u7edf\u4f1a\u8fd4\u56de\u8fd9\u6279\u89d2\u8272\u540d\u4e2d\uff0c\u662f\u5426\u6709\u4e00\u4e2a\u6216\u8005\u591a\u4e2a\u89d2\u8272\u62e5\u6709\u7ba1\u7406\u5458\u6027\u8d28\u7684\u89d2\u8272\u3002\u800c\u5224\u5b9a\u5177\u6709\u8d85\u7ea7\u7ba1\u7406\u5458\u6027\u8d28\u89d2\u8272\u7684\u7528\u6237\u4f1a\u88ab\u8fd4\u56de", notes="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u5df2\u62e5\u6709\u7684\u89d2\u8272\u4fe1\u606f\uff0c\u5305\u62ec\u81ea\u5df1\u7ed1\u5b9a\u7684\uff0c\u6240\u5c5e\u7ec4\u7ec7\u673a\u6784\u7684\uff0c\u6240\u5c5e\u7528\u6237\u7ec4\u7684\uff0c\u751a\u81f3\u7b2c\u4e09\u65b9\u7cfb\u7edf\u7684\uff0c\u7b49\u7b49")
    @RequestMapping(value={"/findByIgnoreRoles"}, method={RequestMethod.GET})
    public ResponseModel findByIgnoreRoles(@ApiParam(value="\u5f53\u524d\u9700\u8981\u9a8c\u8bc1\u7684\u662f\u5426\u5177\u6709\u672c\u5730\u8d85\u7ea7\u7ba1\u7406\u5458") @RequestParam(name="roleNames") String[] roleNames) {
        try {
            Validate.isTrue((roleNames != null && roleNames.length > 0 ? 1 : 0) != 0, (String)"\u8981\u8fdb\u884c\u5224\u5b9a\u7684\u89d2\u8272\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
            Sets.SetView intersections = Sets.intersection((Set)Sets.newHashSet((Object[])this.ignoreMethodCheckRoles), (Set)Sets.newHashSet((Object[])roleNames));
            if (intersections == null || intersections.isEmpty()) {
                return this.buildHttpResult();
            }
            JSONArray results = new JSONArray();
            for (String item : intersections) {
                results.add((Object)item);
            }
            return this.buildHttpResult(results);
        }
        catch (RuntimeException e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8be5\u63a5\u53e3\u65b9\u6cd5\u7528\u4e8e\u67e5\u8be2\u6240\u6709\u89d2\u8272\u4fe1\u606f\uff0c\u65e0\u8bba\u5b83\u4eec\u7684\u72b6\u6001\u5982\u4f55(\u53ea\u63a8\u8350\u7684\u7ba1\u7406\u7aef\u4f7f\u7528\u8be5\u63a5\u53e3\uff0c\u5728\u4e1a\u52a1\u7aef\u4e0d\u63a8\u8350)\u3002<br>\u53ea\u8fd4\u56de\u89d2\u8272\u7684\u57fa\u672c\u4fe1\u606f\uff0c\u6ca1\u6709\u4efb\u4f55\u7684\u5173\u8054\u4fe1\u606f\u4f46\u662f\u5305\u62ec\u4e86\u53ef\u80fd\u7684\u4fee\u6539\u8005\u4fe1\u606f")
    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResponseModel findAll() {
        try {
            List roles = this.roleService.findAll();
            return this.buildHttpResultW(roles, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u591a\u4e2a\u89d2\u8272\u4fe1\u606f")
    @RequestMapping(value={"/findByIds"}, method={RequestMethod.POST})
    public ResponseModel findByIds(@RequestBody List<String> ids) {
        try {
            Set roles = this.roleService.findByIds(ids);
            return this.buildHttpResultW(roles, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u6811\u72b6\u5173\u7cfb")
    @GetMapping(value={"/findRoleTree"})
    public ResponseModel findRoleTree() {
        try {
            Set roles = this.roleService.findRoleTree();
            return this.buildHttpResult(roles);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u540d\u79f0\uff0c\u6216\u5219\u89d2\u8272\u7f16\u7801\uff0c\u6216\u5219\u89d2\u8272\u7f16\u7801\u67e5\u8be2\u89d2\u8272\u4fe1\u606f \uff08\u89d2\u8272\u540d\u79f0\u652f\u6301\u6a21\u7cca\u67e5\u8be2\uff09")
    @GetMapping(value={"/findByConditions"})
    public ResponseModel findByConditions(@ApiParam(value="\u89d2\u8272\u540d\u79f0") @RequestParam(name="roleName", required=false) String roleName, @ApiParam(value="\u89d2\u8272\u7f16\u7801") @RequestParam(name="roleCode", required=false) String roleCode, @ApiParam(value="\u89d2\u8272\u72b6\u6001") @RequestParam(name="tstatus", required=false) Integer tstatus, @ApiParam(value="\u5206\u9875\u53c2\u6570") @PageableDefault(size=50) Pageable pageable) {
        try {
            HashMap<String, Object> conditions = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((CharSequence)roleName)) {
                conditions.put("roleName", roleName);
            }
            if (StringUtils.isNotBlank((CharSequence)roleCode)) {
                conditions.put("roleCode", roleCode);
            }
            if (tstatus != null) {
                conditions.put("tstatus", tstatus);
            }
            InvokeParams invokeParams = new InvokeParams();
            invokeParams.putInvokeParams(conditions);
            Page roles = this.roleService.findByConditions(invokeParams, pageable);
            return this.buildHttpResultW(roles, new String[]{"parent"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u7f16\u7801\u67e5\u8be2")
    @GetMapping(value={"/findByCode"})
    public ResponseModel findByCode(String roleCode) {
        try {
            RoleVo role = this.roleService.findByCode(roleCode);
            return this.buildHttpResultW(role, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u7f16\u7801\u5220\u9664\uff08\u53ea\u80fd\u5220\u9664\u65e0\u7ed1\u5b9a\u5173\u7cfb\u7684\u89d2\u8272\uff09")
    @GetMapping(value={"/deleteByCodes"})
    public ResponseModel deleteByCodes(@ApiParam(value="\u89d2\u8272\u7f16\u7801\u6570\u7ec4", required=true) @RequestParam(name="roleCodes", required=true) String[] roleCodes) {
        try {
            this.roleService.deleteByCodes(roleCodes);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

