/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.starter.service.internal;

import com.bizunited.platform.common.enums.NormalStatusEnum;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.starter.entity.RoleEntity;
import com.bizunited.platform.rbac.server.starter.entity.RoleOrgMappingEntity;
import com.bizunited.platform.rbac.server.starter.entity.RolePositionMappingEntity;
import com.bizunited.platform.rbac.server.starter.repository.RoleOrgMappingRepository;
import com.bizunited.platform.rbac.server.starter.repository.RolePositionMappingRepository;
import com.bizunited.platform.rbac.server.starter.repository.RoleRepository;
import com.bizunited.platform.rbac.server.starter.repository.RoleUserGroupMappingRepository;
import com.bizunited.platform.rbac.server.starter.repository.RoleUserMappingRepository;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.user.common.service.organization.OrganizationService;
import com.bizunited.platform.user.common.service.position.PositionService;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.service.userGroup.UserGroupService;
import com.bizunited.platform.user.common.vo.OrganizationVo;
import com.bizunited.platform.user.common.vo.PositionVo;
import com.bizunited.platform.user.common.vo.UserGroupVo;
import com.bizunited.platform.user.common.vo.UserVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Sort;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.util.CollectionUtils;

public class RoleServiceImpl
implements RoleService {
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private UserService userService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private UserGroupService userGroupService;
    @Autowired
    private RolePositionMappingRepository rolePositionMappingRepository;
    @Autowired
    private RoleOrgMappingRepository roleOrgMappingRepository;
    @Autowired
    private RoleUserGroupMappingRepository roleUserGroupMappingRepository;
    @Autowired
    private RoleUserMappingRepository roleUserMappingRepository;
    @Value(value="${rbac.ignoreMethodCheckRoles}")
    private String[] ignoreMethodCheckRoles;
    @Value(value="${rbac.roles.deleteDeny}")
    private String[] deleteDenys;

    @Transactional
    public RoleVo create(RoleVo role) {
        this.validateRoleBeforeAdd(role);
        RoleEntity roleEntity = (RoleEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)role, RoleEntity.class, HashSet.class, ArrayList.class, new String[]{"parent"}));
        this.roleRepository.saveAndFlush((Object)roleEntity);
        role.setId(roleEntity.getId());
        return role;
    }

    @Transactional
    public RoleVo update(RoleVo role) {
        Validate.notNull((Object)role, (String)"\u89d2\u8272\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String roleId = role.getId();
        String updateComment = role.getComment();
        Validate.notEmpty((CharSequence)roleId, (String)"\u89d2\u8272\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Optional op = this.roleRepository.findById(roleId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u672a\u627e\u5230\u8be5\u89d2\u8272", (Object[])new Object[0]);
        RoleEntity currentRole = (RoleEntity)((Object)op.get());
        String currentName = currentRole.getRoleName();
        for (String deleteDeny : this.deleteDenys) {
            if (!StringUtils.equals((CharSequence)currentName, (CharSequence)deleteDeny)) continue;
            throw new AccessDeniedException("\u8fd9\u4e2a\u89d2\u8272\u4e3a\u7cfb\u7edf\u7279\u5b9a\u9ed8\u8ba4\u89d2\u8272\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
        }
        if (!StringUtils.isBlank((CharSequence)updateComment)) {
            currentRole.setComment(updateComment);
        }
        if (role.getParent() != null) {
            Validate.notBlank((CharSequence)role.getParent().getId(), (String)"\u672a\u627e\u5230\u8be5\u89d2\u8272\u7684\u7236\u7ea7\u89d2\u8272\u7684id\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            RoleEntity parentRole = this.roleRepository.findById(role.getParent().getId()).orElse(null);
            Validate.notNull((Object)((Object)parentRole), (String)"\u672a\u627e\u5230\u89d2\u8272\u7684\u7236\u7ea7\u89d2\u8272", (Object[])new Object[0]);
            currentRole.setParent(parentRole);
            HashSet<String> roleStack = new HashSet<String>();
            roleStack.add(role.getParent().getId());
            this.handleCircular(currentRole, roleStack);
        } else {
            currentRole.setParent(null);
        }
        currentRole.setRoleName(role.getRoleName());
        currentRole.setRoleType(role.getRoleType());
        currentRole.setIsDeny(role.getIsDeny());
        this.roleRepository.saveAndFlush((Object)currentRole);
        return role;
    }

    private void handleCircular(RoleEntity parent, Set<String> roleStack) {
        if (CollectionUtils.isEmpty(parent.getChildren())) {
            return;
        }
        for (RoleEntity roleEntity : parent.getChildren()) {
            Validate.isTrue((!roleStack.contains(roleEntity.getId()) ? 1 : 0) != 0, (String)"\u5f62\u6210\u5faa\u73af\u4f9d\u8d56\uff0c\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            roleStack.add(roleEntity.getId());
            this.handleCircular(roleEntity, roleStack);
        }
    }

    @Transactional
    public void disable(String[] roleIds) {
        Validate.notEmpty((Object[])roleIds, (String)"\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        for (String roleId : roleIds) {
            RoleEntity currentRole = this.roleRepository.findById(roleId).orElse(null);
            Validate.notNull((Object)((Object)currentRole), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            for (String deleteDeny : this.deleteDenys) {
                if (!StringUtils.equals((CharSequence)currentRole.getRoleName(), (CharSequence)deleteDeny)) continue;
                throw new AccessDeniedException("\u8be5\u89d2\u8272\u4e0d\u80fd\u7981\u7528\uff01");
            }
            currentRole.setTstatus(0);
            this.roleRepository.save((Object)currentRole);
        }
    }

    @Transactional
    public void enable(String[] roleIds) {
        Validate.notEmpty((Object[])roleIds, (String)"\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        for (String roleId : roleIds) {
            RoleEntity currentRole = this.roleRepository.findById(roleId).orElse(null);
            Validate.notNull((Object)((Object)currentRole), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            currentRole.setTstatus(1);
            this.roleRepository.save((Object)currentRole);
        }
    }

    private void validateRoleBeforeAdd(RoleVo role) {
        Validate.notNull((Object)role, (String)"\u89d2\u8272\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)role.getRoleName(), (String)"\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        role.setRoleName(role.getRoleName().toUpperCase());
        RoleEntity oldRole = this.roleRepository.findByRoleCode(role.getRoleCode());
        Validate.isTrue((oldRole == null ? 1 : 0) != 0, (String)"\u5f53\u524d\u8bbe\u5b9a\u7684\u89d2\u8272\u7f16\u53f7\uff08role code\uff09\u5df2\u7ecf\u88ab\u4f7f\u7528\uff0c\u8bf7\u66f4\u6362!", (Object[])new Object[0]);
        Date currentTime = new Date();
        role.setCreateDate(currentTime);
        if (StringUtils.isBlank((CharSequence)role.getComment())) {
            role.setComment("[\u672a\u586b\u5199]");
        }
        Validate.isTrue((role.getTstatus() == null || role.getTstatus() == 1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u89d2\u8272\u5fc5\u987b\u662f\u72b6\u6001\u6b63\u5e38\u7684", (Object[])new Object[0]);
        role.setTstatus(Integer.valueOf(1));
        if (role.getParent() != null) {
            Validate.notBlank((CharSequence)role.getParent().getId(), (String)"\u672a\u627e\u5230\u8be5\u89d2\u8272\u7684\u7236\u7ea7\u89d2\u8272\u7684id\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            RoleEntity parentRole = this.roleRepository.findById(role.getParent().getId()).orElse(null);
            Validate.notNull((Object)((Object)parentRole), (String)"\u672a\u627e\u5230\u89d2\u8272\u7684\u7236\u7ea7\u89d2\u8272", (Object[])new Object[0]);
        }
    }

    public Set<RoleVo> findByUserId(String userId) {
        if (StringUtils.isBlank((CharSequence)userId)) {
            return Sets.newHashSet();
        }
        UserVo userVo = this.userService.findByUserId(userId);
        if (userVo == null) {
            return Sets.newHashSet();
        }
        String account = userVo.getAccount();
        return this.findByUserAccount(account);
    }

    public Set<RoleVo> findByUserAccount(String account) {
        if (StringUtils.isBlank((CharSequence)account)) {
            return Sets.newHashSet();
        }
        List<RoleEntity> roles = this.roleRepository.findByUserAccount(account);
        Collection roleVos = this.nebulaToolkitService.copyCollectionByWhiteList(roles, RoleEntity.class, RoleVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Sets.newHashSet((Iterable)roleVos);
    }

    public List<RoleVo> findAllByUserId(String userId, Integer type) {
        Set orgs;
        Set groups;
        HashMap<String, String> sourceMap = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)userId)) {
            return Collections.emptyList();
        }
        HashSet<RoleEntity> resultRoles = new HashSet<RoleEntity>();
        UserVo userVo = this.userService.findByUserId(userId);
        if (userVo == null) {
            return Lists.newArrayList();
        }
        List<RoleEntity> roles = this.roleRepository.findByUserAccount(userVo.getAccount());
        if (roles != null && !roles.isEmpty()) {
            this.setSource(Sets.newHashSet(roles), sourceMap, "user");
            resultRoles.addAll(roles);
        }
        if ((groups = this.userGroupService.findByUserId(userId)) != null && !groups.isEmpty()) {
            for (UserGroupVo item2 : groups) {
                Set<RoleEntity> userGroupRoles = this.roleRepository.findByUserGroupCode(item2.getGroupCode());
                userGroupRoles = userGroupRoles.stream().filter(r -> r.getTstatus() == NormalStatusEnum.ENABLE.getStatus()).collect(Collectors.toSet());
                this.setSource(userGroupRoles, sourceMap, "group");
                resultRoles.addAll(userGroupRoles);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(orgs = this.organizationService.findOrgByUserId(userId)))) {
            for (OrganizationVo item3 : orgs) {
                Set<RoleEntity> orgRoles = this.roleRepository.findByOrgCode(item3.getCode());
                orgRoles = orgRoles.stream().filter(r -> r.getTstatus() == NormalStatusEnum.ENABLE.getStatus()).collect(Collectors.toSet());
                this.setSource(orgRoles, sourceMap, "org");
                resultRoles.addAll(orgRoles);
            }
        }
        Set<Object> positionRoles = new HashSet();
        if (type != null && type.equals(1)) {
            List positions = this.positionService.findByUserId(userId);
            if (!CollectionUtils.isEmpty((Collection)positions)) {
                List<String> positionCodes = positions.stream().map(PositionVo::getCode).collect(Collectors.toList());
                positionRoles = this.roleRepository.findByPositions(positionCodes);
            }
        } else {
            PositionVo positionVo = this.positionService.findMainPositionByUserId(userId);
            if (positionVo != null) {
                positionRoles = this.roleRepository.findByPosition(positionVo.getCode());
            }
        }
        resultRoles.addAll(positionRoles);
        this.setSource(positionRoles, sourceMap, "position");
        if (resultRoles.isEmpty()) {
            return Collections.emptyList();
        }
        List roleEntitys = resultRoles.stream().filter(item -> item.getTstatus() == 1).collect(Collectors.toList());
        ArrayList<RoleVo> roleVos = new ArrayList<RoleVo>();
        for (RoleEntity entity : roleEntitys) {
            RoleVo roleVo = (RoleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, RoleVo.class, HashSet.class, ArrayList.class, new String[0]);
            String sourceName = (String)sourceMap.get(roleVo.getId());
            roleVo.setSource(sourceName);
            roleVo.setParent(this.findParentRole(entity));
            roleVos.add(roleVo);
        }
        return roleVos.stream().sorted(Comparator.comparing(RoleVo::getCreateDate)).collect(Collectors.toList());
    }

    private void setSource(Set<RoleEntity> roles, Map<String, String> sourceMap, String source) {
        if (CollectionUtils.isEmpty(roles)) {
            return;
        }
        for (RoleEntity role : roles) {
            if (sourceMap.containsKey(role.getId())) {
                String value = sourceMap.get(role.getId()) + "," + source;
                sourceMap.put(role.getId(), value);
                continue;
            }
            sourceMap.put(role.getId(), source);
        }
    }

    public List<RoleVo> findByCompetenceId(String competenceId) {
        if (StringUtils.isBlank((CharSequence)competenceId)) {
            return Lists.newArrayList();
        }
        List<RoleEntity> roles = this.roleRepository.findByCompetenceId(competenceId);
        if (roles == null || roles.isEmpty()) {
            return Lists.newArrayList();
        }
        Collection roleVos = this.nebulaToolkitService.copyCollectionByWhiteList(roles, RoleEntity.class, RoleVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)roleVos);
    }

    public List<RoleVo> findByStatus(Integer useStatus) {
        if (useStatus == null) {
            return Collections.emptyList();
        }
        List<RoleEntity> rolesList = this.roleRepository.findByTstatus(useStatus);
        if (rolesList == null || rolesList.isEmpty()) {
            return Collections.emptyList();
        }
        Collection roleVos = this.nebulaToolkitService.copyCollectionByWhiteList(rolesList, RoleEntity.class, RoleVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)roleVos);
    }

    public RoleVo findById(String roleId) {
        Validate.notNull((Object)roleId, (String)"\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Optional op = this.roleRepository.findById(roleId);
        if (!op.isPresent()) {
            return null;
        }
        return (RoleVo)this.nebulaToolkitService.copyObjectByWhiteList(op.get(), RoleVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<RoleVo> findAll() {
        List rolesList = this.roleRepository.findAll(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createDate")}));
        if (rolesList == null || rolesList.isEmpty()) {
            return Collections.emptyList();
        }
        Collection roleVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)rolesList, RoleEntity.class, RoleVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)roleVos);
    }

    @Transactional
    public void deleteByCodes(String[] roleCodes) {
        Validate.notEmpty((Object[])roleCodes, (String)"\u5220\u9664\u65f6\uff0c\u81f3\u5c11\u6709\u4e00\u4e2a\u89d2\u8272\u7f16\u7801", (Object[])new Object[0]);
        for (String roleCode : roleCodes) {
            long roleOrgMappings = this.roleOrgMappingRepository.countByRole(roleCode);
            Validate.isTrue((roleOrgMappings == 0L ? 1 : 0) != 0, (String)"\u89d2\u8272\u7f16\u7801[%s]\u4e0e\u7ec4\u7ec7\u673a\u6784\u5b58\u5728\u5173\u8054\u5173\u7cfb\uff0c\u4e0d\u80fd\u5220\u9664", (Object[])new Object[]{roleCode});
            long rolePositionMappings = this.rolePositionMappingRepository.countByRole(roleCode);
            Validate.isTrue((rolePositionMappings == 0L ? 1 : 0) != 0, (String)"\u89d2\u8272\u7f16\u7801[%s]\u4e0e\u5c97\u4f4d\u5b58\u5728\u5173\u8054\u5173\u7cfb\uff0c\u4e0d\u80fd\u5220\u9664", (Object[])new Object[]{roleCode});
            long roleUserGroupMappings = this.roleUserGroupMappingRepository.countByRole(roleCode);
            Validate.isTrue((roleUserGroupMappings == 0L ? 1 : 0) != 0, (String)"\u89d2\u8272\u7f16\u7801[%s]\u4e0e\u7528\u6237\u7ec4\u5b58\u5728\u5173\u8054\u5173\u7cfb\uff0c\u4e0d\u80fd\u5220\u9664", (Object[])new Object[]{roleCode});
            long roleUserMappings = this.roleUserMappingRepository.countByRole(roleCode);
            Validate.isTrue((roleUserMappings == 0L ? 1 : 0) != 0, (String)"\u89d2\u8272\u7f16\u7801[%s]\u4e0e\u7528\u6237\u5b58\u5728\u5173\u8054\u5173\u7cfb\uff0c\u4e0d\u80fd\u5220\u9664", (Object[])new Object[]{roleCode});
            this.roleRepository.deleteByRoleCode(roleCode);
        }
    }

    public Set<RoleVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Sets.newHashSet();
        }
        Set<RoleEntity> roles = this.roleRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(roles)) {
            return Sets.newHashSet();
        }
        Collection rvos = this.nebulaToolkitService.copyCollectionByWhiteList(roles, RoleEntity.class, RoleVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Sets.newHashSet((Iterable)rvos);
    }

    public Set<RoleVo> findRoleTree() {
        LinkedHashSet<RoleVo> roleSet = new LinkedHashSet<RoleVo>();
        Set<RoleEntity> rootRoles = this.roleRepository.findByParentIsNull();
        if (CollectionUtils.isEmpty(rootRoles)) {
            return Sets.newHashSet();
        }
        for (RoleEntity roleEntity : rootRoles) {
            RoleVo roleVo = (RoleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)roleEntity, RoleVo.class, HashSet.class, ArrayList.class, new String[0]);
            roleVo.setChildren(this.findChildrenRole(roleEntity));
            roleSet.add(roleVo);
        }
        return roleSet;
    }

    public Set<RoleVo> findChildrenRole(RoleEntity roleEntity) {
        LinkedHashSet<RoleVo> roleVoSet = new LinkedHashSet<RoleVo>();
        Set<RoleEntity> children = roleEntity.getChildren();
        if (CollectionUtils.isEmpty(children)) {
            return Sets.newHashSet();
        }
        for (RoleEntity child : children) {
            RoleVo roleVo = (RoleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)child, RoleVo.class, HashSet.class, ArrayList.class, new String[0]);
            roleVo.setChildren(this.findChildrenRole(child));
            roleVoSet.add(roleVo);
        }
        return roleVoSet;
    }

    private RoleVo findParentRole(RoleEntity child) {
        RoleEntity parent = child.getParent();
        if (parent == null) {
            return null;
        }
        if ((parent = (RoleEntity)this.roleRepository.findById(parent.getId()).orElse(null)) == null) {
            return null;
        }
        RoleVo roleVo = (RoleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)parent, RoleVo.class, HashSet.class, ArrayList.class, new String[0]);
        roleVo.setParent(this.findParentRole(parent));
        return roleVo;
    }

    public List<RoleVo> findByConditions(Map<String, Object> conditions) {
        List roleSet = this.roleRepository.findByConditions(conditions);
        if (CollectionUtils.isEmpty((Collection)roleSet)) {
            return Lists.newArrayList();
        }
        Collection roleVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)roleSet, RoleEntity.class, RoleVo.class, HashSet.class, ArrayList.class, new String[]{"parent"});
        return Lists.newArrayList((Iterable)roleVos);
    }

    public RoleVo findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        RoleEntity role = this.roleRepository.findByRoleCode(code);
        if (role == null) {
            return null;
        }
        return (RoleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)role, RoleVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Set<RoleVo> findByRoleNames(Set<String> roleNames) {
        Set<RoleEntity> roles = this.roleRepository.findByRoleNames(roleNames);
        if (CollectionUtils.isEmpty(roles)) {
            Sets.newHashSet();
        }
        Collection collection = this.nebulaToolkitService.copyCollectionByWhiteList(roles, RoleEntity.class, RoleVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Sets.newHashSet((Iterable)collection);
    }

    public List<RoleVo> findByOrgCode(String orgCode) {
        if (StringUtils.isBlank((CharSequence)orgCode)) {
            return Lists.newArrayList();
        }
        Set<RoleOrgMappingEntity> orgOrgs = this.roleOrgMappingRepository.findDetailsByOrgCode(orgCode);
        if (CollectionUtils.isEmpty(orgOrgs)) {
            return Lists.newArrayList();
        }
        List roles = orgOrgs.stream().map(RoleOrgMappingEntity::getRole).collect(Collectors.toList());
        Collection collection = this.nebulaToolkitService.copyCollectionByWhiteList(roles, RoleEntity.class, RoleVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)collection);
    }

    public Set<RoleVo> findByPositionCode(String positionCode) {
        Validate.notBlank((CharSequence)positionCode, (String)"\u4f20\u5165\u7684\u5c97\u4f4d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01", (Object[])new Object[0]);
        List<RolePositionMappingEntity> mappings = this.rolePositionMappingRepository.findByPositionCode(positionCode);
        HashSet<RoleVo> roleSet = new HashSet<RoleVo>();
        for (RolePositionMappingEntity mapping : mappings) {
            RoleEntity role = mapping.getRole();
            if (role == null) continue;
            RoleVo roleVo = (RoleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)role, RoleVo.class, HashSet.class, ArrayList.class, new String[0]);
            roleSet.add(roleVo);
        }
        return roleSet;
    }

    public List<RoleVo> findByGroupCode(String userGroupCode) {
        if (StringUtils.isBlank((CharSequence)userGroupCode)) {
            return Lists.newArrayList();
        }
        Set<RoleEntity> roles = this.roleRepository.findByUserGroupCode(userGroupCode);
        if (CollectionUtils.isEmpty(roles)) {
            return Lists.newArrayList();
        }
        Collection collection = this.nebulaToolkitService.copyCollectionByWhiteList(roles, RoleEntity.class, RoleVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)collection);
    }

    public Set<RoleVo> findByRoleCodes(Set<String> roleCodes) {
        Set<RoleEntity> roles = this.roleRepository.findByRoleCodes(roleCodes);
        if (CollectionUtils.isEmpty(roles)) {
            Sets.newHashSet();
        }
        Collection collection = this.nebulaToolkitService.copyCollectionByWhiteList(roles, RoleEntity.class, RoleVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Sets.newHashSet((Iterable)collection);
    }
}

