/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.rbac.server.service.RoleUserGroupMappingService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/roleUserGroupMapping"})
public class RoleUserGroupMappingController
extends BaseController {
    @Autowired
    private RoleUserGroupMappingService roleUserGroupMappingService;
    @Value(value="${rbac.ignoreMethodCheckRoles:ADMIN}")
    private String[] ignoreMethodCheckRoles;
    private static final Logger LOGGER = LoggerFactory.getLogger(RoleUserGroupMappingController.class);

    @ApiOperation(value="\u7528\u6237\u7ec4\u4e0e\u89d2\u8272\u7ed1\u5b9a")
    @PatchMapping(value={"/bindUserGroups"})
    public ResponseModel bindUserGroups(@ApiParam(name="roleId", value="\u89d2\u8272id") @RequestParam(value="roleId") String roleId, @ApiParam(name="userGroupCodes", value="\u7528\u6237\u7ec4\u7f16\u7801") @RequestParam(value="groupCodes") String[] userGroupCodes) {
        try {
            this.roleUserGroupMappingService.bindUserGroups(roleId, userGroupCodes);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u89e3\u9664\u6307\u5b9a\u89d2\u8272\u548c\u7528\u6237\u7ec4\u7684\u7ed1\u5b9a\u5173\u7cfb")
    @PatchMapping(value={"/unbindUserGroups"})
    public ResponseModel unbindUserGroups(@RequestParam @ApiParam(value="\u89d2\u8272id") String roleId, @RequestParam @ApiParam(value="\u7528\u6237\u7ec4\u7f16\u7801") String[] userGroupCodes) {
        try {
            this.roleUserGroupMappingService.unbindUserGroups(roleId, userGroupCodes);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7ed9\u6307\u5b9aid\u7684\u89d2\u8272\u91cd\u65b0\u8fdb\u884c\u7528\u6237\u7ec4\u7ed1\u5b9a\uff0c\u6309\u7167\u6700\u65b0\u7ed9\u5b9a\u7684\u7528\u6237\u7ec4\u8fdb\u884c\u7ed1\u5b9a")
    @PostMapping(value={"/reBindUserGroups"})
    public ResponseModel reBindUserGroups(@ApiParam(name="roleId", value="\u89d2\u8272Id") @RequestParam(name="roleId") String roleId, @ApiParam(name="userGroupCodes", value="\u7528\u6237\u7ec4\u7f16\u7801\u53ef\u4ee5\u4e0d\u4f20\u6216\u8005\u4f20\u7a7a", required=false) @RequestParam(name="userGroupCodes", required=false) String[] userGroupCodes) {
        try {
            this.roleUserGroupMappingService.reBindUserGroup(roleId, userGroupCodes);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5c06\u6307\u5b9a\u7528\u6237\u7ec4\u7ed1\u5b9a\u4e00\u4e2a\u6216\u591a\u4e2a\u89d2\u8272")
    @PatchMapping(value={"/bindUserGroupRoles"})
    public ResponseModel bindUserGroupRoles(@RequestParam @ApiParam(value="\u7528\u6237\u7ec4\u7f16\u7801") String userGroupCode, @RequestParam @ApiParam(value="\u4e00\u4e2a\u6216\u591a\u4e2a\u89d2\u8272ID") String[] roleIds) {
        try {
            this.roleUserGroupMappingService.bindUserGroupRoles(userGroupCode, roleIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u89e3\u9664\u6307\u5b9a\u7528\u6237\u7ec4\u4e0e\u89d2\u8272\u7684\u7ed1\u5b9a\u5173\u7cfb")
    @PatchMapping(value={"/unbindUserGroupRoles"})
    public ResponseModel unbindUserGroupRoles(@RequestParam @ApiParam(value="\u7528\u6237\u7ec4\u7f16\u7801") String userGroupCode, @RequestParam @ApiParam(value="\u4e00\u4e2a\u6216\u591a\u4e2a\u89d2\u8272ID") String[] roleIds) {
        try {
            this.roleUserGroupMappingService.unbindUserGroupRoles(userGroupCode, roleIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7ed9\u6307\u5b9a\u7f16\u7801\u7684\u7528\u6237\u7ec4\u91cd\u65b0\u8fdb\u884c\u89d2\u8272\u7ed1\u5b9a\uff0c\u6309\u7167\u6700\u65b0\u7ed9\u5b9a\u7684\u89d2\u8272\u8fdb\u884c\u7ed1\u5b9a")
    @PostMapping(value={"/reBindUserGroupRoles"})
    public ResponseModel reBindUserGroupRoles(@ApiParam(name="userGroupCode", value="\u7528\u6237\u7ec4\u7f16\u7801") @RequestParam(name="userGroupCode") String userGroupCode, @ApiParam(name="roleCodes", value="\u89d2\u8272\u7f16\u7801\u53ef\u4ee5\u4e0d\u4f20\u6216\u8005\u4f20\u7a7a", required=false) @RequestParam(name="roleCodes", required=false) String[] roleCodes) {
        try {
            this.roleUserGroupMappingService.reBindUserGroupRoles(userGroupCode, roleCodes);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findUserGroupByRoleCode"})
    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u7f16\u7801\u67e5\u8be2\u7ed1\u5b9a\u7528\u6237\u7ec4")
    public ResponseModel findByRoleCode(@RequestParam(value="roleCode") @ApiParam(value="\u89d2\u8272\u7f16\u7801") String roleCode) {
        try {
            List userGroups = this.roleUserGroupMappingService.findByRoleCode(roleCode);
            return this.buildHttpResultW(userGroups, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

