package com.bizunited.platform.rbac.server.starter.repository.internal;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.rbac.server.starter.entity.RoleExtendEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName : RoleExtendEntityRepositoryCustomImpl
 * @Description :
 * @Author : chengzhongxiang
 * @Date: 2020-09-22 15:55
 */

@Repository("RoleExtendEntityRepositoryCustomImpl")
public class RoleExtendEntityRepositoryCustomImpl implements RoleExtendEntityRepositoryCustom, PageRepositoryImpl {

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  private static final String ROLENAME = "roleName";
  private static final String ROLECODE = "roleCode";
  private static final String TSTATUS = "tstatus";

  /**
   * 根据角色名称，或则角色编码，或则角色编码查询角色信息 （角色名称支持模糊查询）
   * @param conditions
   * @param pageable
   * @return
   */
  @Override
  public Page<RoleExtendEntity> queryPage(Map<String, Object> conditions, Pageable pageable) {
    /*
     * 目前的查询条件是：角色名称（模糊）、角色编码、角色状态
     * */
    StringBuilder hql = new StringBuilder("from RoleExtendEntity re left join fetch re.roleEntity r where 1 = 1");
    StringBuilder countHql = new StringBuilder("select count(*) from RoleExtendEntity re left join re.roleEntity r where 1 = 1 ");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameter = new HashMap<>();

    // 角色名称
    Object roleName = conditions.get(ROLENAME);
    if(roleName != null) {
      condition.append(" AND r.roleName like CONCAT('%', :roleName, '%') ");
      parameter.put(ROLENAME, roleName);
    }

    //角色编码
    Object roleCode = conditions.get(ROLECODE);
    if(roleCode != null) {
      condition.append(" AND r.roleCode like CONCAT('%', :roleCode, '%')");
      parameter.put(ROLECODE, roleCode);
    }

    //角色状态
    Object tstatus = conditions.get(TSTATUS);
    if(tstatus != null) {
      condition.append(" AND r.tstatus = :tstatus ");
      parameter.put(TSTATUS, tstatus);
    }
    condition.append(" AND re.deleteFlag = 0 ");
    hql.append(condition).append(" order by r.roleCode desc");
    countHql.append(condition);

    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameter, pageable, false, null);

  }
}
