package com.bizunited.platform.rbac.server.starter.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;
import java.util.Date;
import java.util.Set;

/**
 * 页面按钮数据持久化描述
 * @Author: Paul Chan
 * @Date: 2020-01-08 17:05
 */
@Entity
@Table(name = "engine_button", uniqueConstraints = {@UniqueConstraint(name = "unique_code_project_name", columnNames = {"code", "project_name"})})
@ApiModel(value = "ButtonEntity" , description="页面按钮数据持久化描述")
@org.hibernate.annotations.Table(appliesTo = "engine_button", comment = "页面按钮数据持久化描述")
public class ButtonEntity extends UuidEntity {
  private static final long serialVersionUID = 5188415361499519018L;

  /**
   * 关联的菜单,应该只能关联viewItem为1的菜单
   */
  @ApiModelProperty("关联的菜单")
  @ManyToOne(fetch = FetchType.LAZY)
  @SaturnColumn(description = "关联的菜单")
  @JoinColumn(name = "competence_id", nullable = false, columnDefinition = "varchar(255) COMMENT '菜单ID'")
  private CompetenceEntity competence;

  /**
   * 关联的角色
   */
  @ApiModelProperty("关联的角色")
  @ManyToMany(fetch = FetchType.LAZY, mappedBy = "buttons")
  @SaturnColumn(description = "关联的角色")
  private Set<RoleEntity> roles;

  /** 按钮编码 **/
  @Column(name = "code", nullable = false,  columnDefinition = "varchar(255) COMMENT '按钮编码'")
  @ApiModelProperty(name="code" , value="按钮编码，系统中唯一存在" , required=true)
  @SaturnColumn(description="按钮编码")
  private String code;

  /**
   * 按钮名称
   */
  @Column(name = "name", nullable = false, columnDefinition = "varchar(255) COMMENT '按钮名称'")
  @ApiModelProperty(name="name" , value="按钮名称" , required=true)
  @SaturnColumn(description="按钮名称")
  private String name;

  /**
   * 按钮说明
   */
  @Column(name = "button_desc", columnDefinition = "varchar(255) COMMENT '按钮说明'")
  @ApiModelProperty(name="buttonDesc" , value="按钮说明")
  @SaturnColumn(description="按钮说明")
  private String buttonDesc;

  /**
   * 是否是系统按钮
   */
  @Column(name = "is_system", columnDefinition = "bit(1) COMMENT '是否是系统按钮'")
  @ApiModelProperty(name="system" , value="是否是系统按钮")
  @SaturnColumn(description="是否是系统按钮")
  private Boolean system;

  /**
   * 创建时间
   */
  @ApiModelProperty("创建时间")
  @SaturnColumn(description = "创建时间")
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime(3) COMMENT '创建时间'")
  private Date createTime;

  /**
   * 更新时间
   */
  @ApiModelProperty("更新时间")
  @SaturnColumn(description = "更新时间")
  @Column(name = "modify_time", nullable = false, columnDefinition = "datetime(3) COMMENT '更新时间'")
  private Date modifyTime;

  /**
   * 关联的接口信息
   */
  @ApiModelProperty("关联的接口信息")
  @ManyToMany(fetch = FetchType.LAZY)
  @SaturnColumn(description = "关联的接口信息")
  @JoinTable(name = "engine_button_competence_mapping", joinColumns = {@JoinColumn(name = "button_id")},
      inverseJoinColumns = {@JoinColumn(name = "competence_id")})
  private Set<CompetenceEntity> competences;

  /**
   * 当前项目名工程名
   */
  @ApiModelProperty("项目名")
  @Column(name="project_name", nullable = false, columnDefinition = "varchar(255) default '' comment '工程名'")
  @SaturnColumn(description = "工程名")
  private String projectName = ApplicationContextUtils.getProjectName();

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public CompetenceEntity getCompetence() {
    return competence;
  }

  public void setCompetence(CompetenceEntity competence) {
    this.competence = competence;
  }

  public Set<RoleEntity> getRoles() {
    return roles;
  }

  public void setRoles(Set<RoleEntity> roles) {
    this.roles = roles;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getButtonDesc() {
    return buttonDesc;
  }

  public void setButtonDesc(String buttonDesc) {
    this.buttonDesc = buttonDesc;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Date getModifyTime() {
    return modifyTime;
  }

  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }

  public Set<CompetenceEntity> getCompetences() {
    return competences;
  }

  public void setCompetences(Set<CompetenceEntity> competences) {
    this.competences = competences;
  }

  public Boolean getSystem() {
    return system;
  }

  public void setSystem(Boolean system) {
    this.system = system;
  }
}
