/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.starter.repository;

import com.bizunited.platform.rbac.server.starter.entity.CompetenceEntity;
import com.bizunited.platform.rbac.server.starter.repository.internal.CompetenceRepositoryCustom;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="CompetenceRepository")
public interface CompetenceRepository
extends JpaRepository<CompetenceEntity, String>,
JpaSpecificationExecutor<CompetenceEntity>,
CompetenceRepositoryCustom {
    @Modifying
    @Query(value="insert into engine_role_competence_mapping(role_id,competence_id) values (:roleId,:competenceId)", nativeQuery=true)
    public void bindCompetence(@Param(value="roleId") String var1, @Param(value="competenceId") String var2);

    @Modifying
    @Query(value="delete from engine_role_competence_mapping where role_id = :roleId and competence_id = :competenceId", nativeQuery=true)
    public void unbindCompetence(@Param(value="roleId") String var1, @Param(value="competenceId") String var2);

    @Query(value="from CompetenceEntity ce left join fetch ce.parent cep where ce.viewItem = :viewItem order by ce.sortIndex ")
    public List<CompetenceEntity> findByViewItem(@Param(value="viewItem") Integer var1);

    @Query(value="from CompetenceEntity ce left join fetch ce.parent cep where ce.viewItem = :viewItem and ce.tstatus = :tstatus order by ce.sortIndex")
    public List<CompetenceEntity> findByViewItemAndStatus(@Param(value="viewItem") Integer var1, @Param(value="tstatus") Integer var2);

    public List<CompetenceEntity> findByResourceAndTstatus(String var1, Integer var2);

    public List<CompetenceEntity> findByResource(String var1);

    public List<CompetenceEntity> findByComment(String var1);

    @Query(value="select distinct c from CompetenceEntity c left join fetch c.parent p left join fetch c.roles r where r.roleName in (:roleNames) and c.viewItem = :viewItem and c.tstatus = :status and c.projectName=:projectName order by c.sortIndex")
    public List<CompetenceEntity> findByViewItemAndRoleNamesAndStatusAndProjectName(@Param(value="viewItem") Integer var1, @Param(value="roleNames") String[] var2, @Param(value="status") Integer var3, @Param(value="projectName") String var4);

    @Query(value="select distinct c from CompetenceEntity c left join fetch c.parent p left join fetch c.roles r where r.roleName in (:roleNames) and c.viewItem = :viewItem order by c.sortIndex")
    public List<CompetenceEntity> findByViewItemAndRoleNames(@Param(value="viewItem") Integer var1, @Param(value="roleNames") String[] var2);

    @Query(value="from CompetenceEntity c where c.parent.id = :parentId order by c.sortIndex")
    public List<CompetenceEntity> findByParentId(@Param(value="parentId") String var1);

    @Query(value="select count(*) from engine_role_competence_mapping where role_id = :roleId and competence_id = :competenceId", nativeQuery=true)
    public Integer countByRoleIdAndCompetenceId(@Param(value="roleId") String var1, @Param(value="competenceId") String var2);

    @Query(value="select count(*) from  CompetenceEntity c where c.viewItem = :viewItem and c.comment = :comment ")
    public long countByCommentAndViewItem(@Param(value="comment") String var1, @Param(value="viewItem") Integer var2);

    @Query(value="select count(*) from  CompetenceEntity c where c.viewItem = :viewItem and c.comment = :comment and c.projectName=:projectName and c.id <> :id ")
    public long countByCommentAndViewItemAndProjectNameExceptId(@Param(value="id") String var1, @Param(value="comment") String var2, @Param(value="projectName") String var3, @Param(value="viewItem") Integer var4);

    @Query(value="select c from CompetenceEntity c inner join c.parent cp where c.comment = :comment and c.viewItem = :viewItem and cp.id = :parentId")
    public CompetenceEntity findByCommentAndViewItemAndParent(@Param(value="comment") String var1, @Param(value="viewItem") int var2, @Param(value="parentId") String var3);

    @Query(value="select c from CompetenceEntity c where c.comment = :comment and c.viewItem = :viewItem and c.parent = null ")
    public CompetenceEntity findByCommentAndViewItemAndNullParent(@Param(value="comment") String var1, @Param(value="viewItem") int var2);

    @Query(value="select c from CompetenceEntity c inner join c.buttons b where b.id = :buttonId ")
    public Set<CompetenceEntity> findByButtonId(@Param(value="buttonId") String var1);

    public CompetenceEntity findByResourceAndMethodsAndProjectName(String var1, String var2, String var3);

    @Query(value="select count(*) from CompetenceEntity c where c.viewItem = :viewItem")
    public long countByViewItem(@Param(value="viewItem") int var1);

    public long countByCodeAndProjectName(String var1, String var2);

    @Query(value="select count(*) from CompetenceEntity c where c.viewItem = :viewItem and c.projectName=:projectName ")
    public long countByViewItemAndProjectName(@Param(value="viewItem") int var1, @Param(value="projectName") String var2);

    @Query(value="select distinct c from  CompetenceEntity c where c.viewItem = :viewItem and c.comment = :comment ")
    public List<CompetenceEntity> findByCommentAndViewItem(@Param(value="comment") String var1, @Param(value="viewItem") Integer var2);
}

