package com.bizunited.platform.rbac.server.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.rbac.server.service.RoleUserMappingService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/v1/nebula/roleUserMapping")
public class RoleUserMappingController extends BaseController {
  /**
   * 配置的那些可以忽略方法级检查的，具有超级管理员性质的角色名
   */
  @Value("${rbac.ignoreMethodCheckRoles:ADMIN}")
  private String[] ignoreMethodCheckRoles;
  @Autowired
  private RoleUserMappingService roleUserMappingService;
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(RoleUserMappingController.class);

  @ApiOperation(value = "按照指定的用户编号，为用户绑定角色信息")
  @PostMapping("/bindUserRoles")
  public ResponseModel bindUserRoles (
      @ApiParam(name = "account", value = "指定的用户账号", required = true)  @RequestParam(name="account") String account,
      @ApiParam(name = "roleCodes", value = "指定的角色编码数组", required = true) @RequestParam(name="roleCodes") String[] roleCodes) {
    try {
      this.roleUserMappingService.bindUserRoles(account, roleCodes);
      return this.buildHttpResult();
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }
  
  @ApiOperation(value = "给指定id的用户重新进行角色绑定，也就是说以前的绑定信息就失效了，按照最新给定的角色编码进行角色绑定")
  @PostMapping("/reBindUserRoles")
  public ResponseModel reBindUserRoles(
      @ApiParam(name = "account", value = "指定的用户账号", required = true) @RequestParam(name="account") String account,
      @ApiParam(name = "roleCodes", value = "指定的角色编码数组", required = true) @RequestParam(name="roleCodes") String[] roleCodes) {
    try {
      this.roleUserMappingService.reBindUserRoles(account, roleCodes);
      return this.buildHttpResult();
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }
}
