package com.bizunited.platform.rbac.server.starter.repository.internal;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.rbac.server.starter.entity.RoleEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.Map;

/**
 * 角色持久化接口实现
 * @Author: zengxingwang
 * @Date: 2020/4/15 15:56
 */
@Repository("RoleRepositoryImpl")
public class RoleRepositoryImpl implements RoleRepositoryCustom, PageRepositoryImpl {

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  private static final String ROLENAME = "roleName";
  private static final String ROLECODE = "roleCode";
  private static final String TSTATUS = "tstatus";

  @Override
  public Page<RoleEntity> findByConditions(Map<String, Object> conditions, Pageable pageable) {
    /*
     * 目前的查询条件是：角色名称（模糊）、角色编码、角色状态
     * */
    StringBuilder hql = new StringBuilder("from RoleEntity r where 1 = 1");
    StringBuilder countHql = new StringBuilder("select count(*) from RoleEntity r where 1 = 1 ");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameter = new HashMap<>();

    // 角色名称
    Object roleName = conditions.get(ROLENAME);
    if(roleName != null) {
      condition.append(" AND r.roleName like CONCAT('%', :roleName, '%') ");
      parameter.put(ROLENAME, roleName);
    }

    //角色编码
    Object roleCode = conditions.get(ROLECODE);
    if(roleCode != null) {
      condition.append(" AND r.roleCode = :roleCode ");
      parameter.put(ROLECODE, roleCode);
    }

    //角色状态
    Object tstatus = conditions.get(TSTATUS);
    if(tstatus != null) {
      condition.append(" AND r.tstatus = :tstatus ");
      parameter.put(TSTATUS, tstatus);
    }
    hql.append(condition).append(" order by r.createDate desc");
    countHql.append(condition);
    return this.queryByConditions(entityManager, hql.toString(), countHql.toString(), parameter, pageable, false, null);
  }
}