/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.rbac.server.service.RoleOrgMappingService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/roleOrgMapping"})
public class RoleOrgMappingController
extends BaseController {
    @Autowired
    private RoleOrgMappingService roleOrgMappingService;
    @Value(value="${rbac.ignoreMethodCheckRoles:ADMIN}")
    private String[] ignoreMethodCheckRoles;
    private static final Logger LOGGER = LoggerFactory.getLogger(RoleOrgMappingController.class);

    @ApiOperation(value="\u5c06\u6307\u5b9a\u89d2\u8272\u7ed1\u5b9a\u4e00\u4e2a\u6216\u591a\u4e2a\u7ec4\u7ec7\u673a\u6784")
    @PatchMapping(value={"bindOrgs"})
    public ResponseModel bindOrgs(@RequestParam @ApiParam(value="\u89d2\u8272ID") String roleId, @RequestParam @ApiParam(value="\u4e00\u4e2a\u6216\u591a\u4e2a\u7ec4\u7ec7\u673a\u6784\u7f16\u7801") String[] orgCodes) {
        try {
            this.roleOrgMappingService.bindOrgs(roleId, orgCodes);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5c06\u6307\u5b9a\u89d2\u8272\u91cd\u65b0\u7ed1\u5b9a\u4e00\u4e2a\u6216\u591a\u4e2a\u7ec4\u7ec7\u673a\u6784")
    @PatchMapping(value={"rebindOrgs"})
    public ResponseModel rebindOrgs(@RequestParam @ApiParam(value="\u89d2\u8272ID") String roleId, @RequestParam(required=false) @ApiParam(value="\u4e00\u4e2a\u6216\u591a\u4e2a\u7ec4\u7ec7\u673a\u6784\u7f16\u7801") String[] orgCodes) {
        try {
            this.roleOrgMappingService.rebindOrgs(roleId, orgCodes);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u89e3\u9664\u6307\u5b9a\u89d2\u8272\u548c\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\u7684\u7ed1\u5b9a\u5173\u7cfb")
    @PatchMapping(value={"unbindOrgs"})
    public ResponseModel unbindOrgs(@RequestParam @ApiParam(value="\u89d2\u8272ID") String roleId, @RequestParam @ApiParam(value="\u5f53\u524d\u9700\u8981\u89e3\u7ed1\u7684\u7ec4\u7ec7\u7f16\u7801") String[] orgCodes) {
        try {
            this.roleOrgMappingService.unbindOrgs(roleId, orgCodes);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5c06\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\u7ed1\u5b9a\u4e00\u4e2a\u6216\u591a\u4e2a\u89d2\u8272")
    @PatchMapping(value={"bindOrgRoles"})
    public ResponseModel bindOrgRoles(@RequestParam @ApiParam(value="\u7ec4\u7ec7\u673a\u6784\u7f16\u7801") String orgCode, @RequestParam @ApiParam(value="\u4e00\u4e2a\u6216\u591a\u4e2a\u89d2\u8272ID") String[] roleIds) {
        try {
            this.roleOrgMappingService.bindOrgRoles(orgCode, roleIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5c06\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\u91cd\u65b0\u7ed1\u5b9a\u4e00\u4e2a\u6216\u591a\u4e2a\u89d2\u8272")
    @PatchMapping(value={"rebindOrgRoles"})
    public ResponseModel rebindOrgRoles(@RequestParam @ApiParam(value="\u7ec4\u7ec7\u673a\u6784\u7f16\u7801") String orgCode, @RequestParam(required=false) @ApiParam(value="\u4e00\u4e2a\u6216\u591a\u4e2a\u89d2\u8272ID") String[] roleIds) {
        try {
            this.roleOrgMappingService.rebindOrgRoles(orgCode, roleIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u89e3\u9664\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\u548c\u89d2\u8272\u7684\u7ed1\u5b9a\u5173\u7cfb")
    @PatchMapping(value={"unbindOrgRoles"})
    public ResponseModel unbindOrgRoles(@RequestParam @ApiParam(value="\u7ec4\u7ec7\u673a\u6784\u7f16\u7801") String orgCode, @RequestParam @ApiParam(value="\u4e00\u4e2a\u6216\u591a\u4e2a\u89d2\u8272ID") String[] roleIds) {
        try {
            this.roleOrgMappingService.unbindOrgRoles(orgCode, roleIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findOrgsByRoleId"})
    @ApiOperation(value="\u6839\u636e\u89d2\u8272ID\u67e5\u8be2\u7ed1\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784")
    public ResponseModel findByRoleId(@RequestParam @ApiParam(value="\u89d2\u8272ID") String roleId) {
        try {
            List orgs = this.roleOrgMappingService.findByRoleId(roleId);
            return this.buildHttpResultW(orgs, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

