/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.starter.service.internal;

import com.bizunited.platform.common.enums.RbacRelationEnum;
import com.bizunited.platform.core.annotations.NebulaServiceMethod;
import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.rbac.server.service.RbacSettingService;
import com.bizunited.platform.rbac.server.service.RolePositionMappingService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.starter.entity.RoleEntity;
import com.bizunited.platform.rbac.server.starter.entity.RolePositionMappingEntity;
import com.bizunited.platform.rbac.server.starter.repository.RolePositionMappingRepository;
import com.bizunited.platform.rbac.server.vo.RbacSettingVo;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.user.common.service.position.PositionService;
import com.bizunited.platform.user.common.vo.PositionVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;

public class RolePositionMappingServiceImpl
implements RolePositionMappingService {
    @Autowired
    private RolePositionMappingRepository rolePositionMappingRepository;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private RbacSettingService rbacSettingService;

    @Transactional
    public void bindPositions(String roleId, String[] positionCodes) {
        Validate.notBlank((CharSequence)roleId, (String)"\u8fdb\u884c\u89d2\u8272-\u5c97\u4f4d\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u89d2\u8272\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((positionCodes != null && positionCodes.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u89d2\u8272-\u5c97\u4f4d\u7ed1\u5b9a\u65f6,\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u5c97\u4f4d\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[0]);
        RoleVo role = this.roleService.findById(roleId);
        Validate.notNull((Object)role, (String)"\u672a\u627e\u5230\u89d2\u8272\u4fe1\u606f\uff1a%s", (Object[])new Object[]{roleId});
        RbacSettingVo rbacSetting = this.rbacSettingService.findRbacSetting();
        for (String positionCode : positionCodes) {
            PositionVo positionVo = this.positionService.findByCode(positionCode);
            Validate.notNull((Object)positionVo, (String)"\u672a\u627e\u5230\u5c97\u4f4d\uff1a%s", (Object[])new Object[]{positionCode});
            this.validateBindPosition(rbacSetting, role, positionVo);
            RolePositionMappingEntity mapping = new RolePositionMappingEntity();
            RoleEntity currentRole = new RoleEntity();
            currentRole.setId(roleId);
            currentRole.setRoleCode(role.getRoleCode());
            mapping.setRole(currentRole);
            mapping.setPositionCode(positionCode);
            this.rolePositionMappingRepository.save((Object)mapping);
        }
    }

    @Transactional
    public void unbindPositions(String roleId, String[] positionCodes) {
        Validate.notBlank((CharSequence)roleId, (String)"\u8fdb\u884c\u89d2\u8272-\u5c97\u4f4d\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u89d2\u8272\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((positionCodes != null && positionCodes.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u89d2\u8272-\u5c97\u4f4d\u7ed1\u5b9a\u65f6,\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u5c97\u4f4d\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[0]);
        RoleVo role = this.roleService.findById(roleId);
        Validate.notNull((Object)role, (String)"\u672a\u627e\u5230\u89d2\u8272\u4fe1\u606f\uff1a%s", (Object[])new Object[]{roleId});
        for (String positionCode : positionCodes) {
            RolePositionMappingEntity mapping = this.rolePositionMappingRepository.findByRoleAndPositionCode(role.getRoleCode(), positionCode);
            if (mapping == null) continue;
            this.rolePositionMappingRepository.delete((Object)mapping);
        }
    }

    @Transactional
    public void unbindAllByRoleId(String roleId) {
        Validate.notBlank((CharSequence)roleId, (String)"\u89d2\u8272\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Set<PositionVo> positionVos = this.findByRoleId(roleId);
        if (CollectionUtils.isEmpty(positionVos)) {
            return;
        }
        String[] positionIdArray = this.getPositionIdArray(positionVos);
        this.unbindPositions(roleId, positionIdArray);
    }

    @Transactional
    public void rebindPositions(String roleId, String[] positionCodes) {
        Validate.notBlank((CharSequence)roleId, (String)"\u4f20\u5165\u7684\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        RoleVo role = this.roleService.findById(roleId);
        Validate.notNull((Object)role, (String)"\u672a\u627e\u5230\u89d2\u8272\u4fe1\u606f\uff1a%s", (Object[])new Object[]{roleId});
        HashSet<String> currentPositionCodes = new HashSet<String>();
        if (positionCodes != null) {
            for (String positionCode : positionCodes) {
                currentPositionCodes.add(positionCode);
            }
        }
        this.rolePositionMappingRepository.unbindRoleCode(role.getRoleCode());
        this.rolePositionMappingRepository.flush();
        RbacSettingVo rbacSetting = this.rbacSettingService.findRbacSetting();
        for (String bindPositionCode : currentPositionCodes) {
            PositionVo positionVo = this.positionService.findByCode(bindPositionCode);
            Validate.notNull((Object)positionVo, (String)"\u672a\u627e\u5230\u5c97\u4f4d\uff1a%s", (Object[])new Object[]{bindPositionCode});
            this.validateBindPosition(rbacSetting, role, positionVo);
            RolePositionMappingEntity mapping = new RolePositionMappingEntity();
            RoleEntity currentRole = new RoleEntity();
            currentRole.setId(roleId);
            currentRole.setRoleCode(role.getRoleCode());
            mapping.setRole(currentRole);
            mapping.setPositionCode(bindPositionCode);
            this.rolePositionMappingRepository.save((Object)mapping);
        }
    }

    private void validateBindPosition(RbacSettingVo rbacSetting, RoleVo role, PositionVo positionVo) {
        long count = this.rolePositionMappingRepository.countByRoleAndPosition(role.getRoleCode(), positionVo.getCode());
        Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u6307\u5b9a\u5c97\u4f4d[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{positionVo.getName()});
        if (rbacSetting.getRolePositionRelation() == RbacRelationEnum.MANY_TO_MANY.getRelation()) {
            count = this.rolePositionMappingRepository.countByRoleAndPosition(role.getRoleCode(), positionVo.getCode());
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u5c97\u4f4d\u591a\u5bf9\u591a\uff0c\u6307\u5b9a\u5c97\u4f4d[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{positionVo.getName()});
        }
        if (rbacSetting.getRolePositionRelation() == RbacRelationEnum.MANY_TO_ONE.getRelation()) {
            count = this.rolePositionMappingRepository.countByRole(role.getRoleCode());
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u5c97\u4f4d\u591a\u5bf9\u4e00\uff0c\u6307\u5b9a\u89d2\u8272[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u5c97\u4f4d\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{role.getRoleName()});
        }
        if (rbacSetting.getRolePositionRelation() == RbacRelationEnum.ONE_TO_MANY.getRelation()) {
            count = this.rolePositionMappingRepository.countByPositionCode(positionVo.getCode());
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u5c97\u4f4d\u4e00\u5bf9\u591a\uff0c\u6307\u5b9a\u5c97\u4f4d[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u89d2\u8272\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{positionVo.getName()});
        }
        if (rbacSetting.getRolePositionRelation() == RbacRelationEnum.ONE_TO_ONE.getRelation()) {
            count = this.rolePositionMappingRepository.countByRole(role.getRoleCode());
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u5c97\u4f4d\u4e00\u5bf9\u4e00\uff0c\u6307\u5b9a\u89d2\u8272[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u5c97\u4f4d\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{role.getRoleName()});
            count = this.rolePositionMappingRepository.countByPositionCode(positionVo.getCode());
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u5c97\u4f4d\u4e00\u5bf9\u4e00\uff0c\u6307\u5b9a\u5c97\u4f4d[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u89d2\u8272\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{positionVo.getName()});
        }
    }

    @Transactional
    public void bindPositionRoles(String positionCode, String[] roleIds) {
        Validate.notBlank((CharSequence)positionCode, (String)"\u8fdb\u884c\u5c97\u4f4d-\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u5c97\u4f4d\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((roleIds != null && roleIds.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5c97\u4f4d-\u89d2\u8272\u7ed1\u5b9a\u65f6,\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u89d2\u8272id\u4fe1\u606f!!", (Object[])new Object[0]);
        RbacSettingVo rbacSetting = this.rbacSettingService.findRbacSetting();
        PositionVo positionVo = this.positionService.findByCode(positionCode);
        Validate.notNull((Object)positionVo, (String)"\u672a\u627e\u5230\u5c97\u4f4d\uff1a%s", (Object[])new Object[]{positionCode});
        for (String roleId : roleIds) {
            RoleVo role = this.roleService.findById(roleId);
            Validate.notNull((Object)role, (String)"\u672a\u627e\u5230\u89d2\u8272\u4fe1\u606f\uff1a%s", (Object[])new Object[]{roleId});
            this.validateBindPosition(rbacSetting, role, positionVo);
            RolePositionMappingEntity mapping = new RolePositionMappingEntity();
            RoleEntity currentRole = new RoleEntity();
            currentRole.setId(roleId);
            currentRole.setRoleCode(role.getRoleCode());
            mapping.setRole(currentRole);
            mapping.setPositionCode(positionCode);
            this.rolePositionMappingRepository.save((Object)mapping);
        }
    }

    @Transactional
    public void unbindPositionRoles(String positionCode, String[] roleIds) {
        Validate.notBlank((CharSequence)positionCode, (String)"\u8fdb\u884c\u5c97\u4f4d-\u89d2\u8272\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u5c97\u4f4d\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((roleIds != null && roleIds.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5c97\u4f4d-\u89d2\u8272\u89e3\u7ed1\u65f6,\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u89d2\u8272id\u4fe1\u606f!!", (Object[])new Object[0]);
        for (String roleId : roleIds) {
            RoleVo role = this.roleService.findById(roleId);
            Validate.notNull((Object)role, (String)"\u672a\u627e\u5230\u89d2\u8272\u4fe1\u606f\uff1a%s", (Object[])new Object[]{roleId});
            RolePositionMappingEntity mapping = this.rolePositionMappingRepository.findByRoleAndPositionCode(role.getRoleCode(), positionCode);
            if (mapping == null) continue;
            this.rolePositionMappingRepository.delete((Object)mapping);
        }
    }

    @Transactional
    public void rebindPositionRoles(String positionCode, String[] roleIds) {
        Validate.notBlank((CharSequence)positionCode, (String)"\u4f20\u5165\u7684\u5c97\u4f4d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        PositionVo positionVo = this.positionService.findByCode(positionCode);
        Validate.notNull((Object)positionVo, (String)"\u672a\u627e\u5230\u5c97\u4f4d\uff1a%s", (Object[])new Object[]{positionCode});
        HashSet<String> currentRoleIds = new HashSet<String>();
        if (roleIds != null) {
            for (String roleId : roleIds) {
                currentRoleIds.add(roleId);
            }
        }
        this.rolePositionMappingRepository.unbindPositionCode(positionCode);
        RbacSettingVo rbacSetting = this.rbacSettingService.findRbacSetting();
        for (String bindRoleId : roleIds) {
            RoleVo role = this.roleService.findById(bindRoleId);
            Validate.notNull((Object)role, (String)"\u672a\u627e\u5230\u89d2\u8272\uff1a%s", (Object[])new Object[]{bindRoleId});
            this.validateBindPosition(rbacSetting, role, positionVo);
            RolePositionMappingEntity mapping = new RolePositionMappingEntity();
            RoleEntity currentRole = new RoleEntity();
            currentRole.setId(bindRoleId);
            currentRole.setRoleCode(role.getRoleCode());
            mapping.setRole(currentRole);
            mapping.setPositionCode(positionCode);
            this.rolePositionMappingRepository.save((Object)mapping);
        }
    }

    public Set<PositionVo> findByRoleId(String roleId) {
        if (StringUtils.isBlank((CharSequence)roleId)) {
            return Sets.newHashSet();
        }
        RoleVo role = this.roleService.findById(roleId);
        if (role == null) {
            return Sets.newHashSet();
        }
        List<RolePositionMappingEntity> mappings = this.rolePositionMappingRepository.findByRole(role.getRoleCode());
        if (mappings == null) {
            return Sets.newHashSet();
        }
        HashSet<PositionVo> positionVos = new HashSet<PositionVo>();
        for (RolePositionMappingEntity mapping : mappings) {
            PositionVo positionVo = this.positionService.findPositionDetailByCode(mapping.getPositionCode());
            if (positionVo == null) continue;
            positionVos.add(positionVo);
        }
        return positionVos;
    }

    @NebulaServiceMethod(name="RolePositionMappingService.findPageByRoleId", desc="\u6839\u636e\u89d2\u8272ID\u67e5\u8be2\u76f4\u63a5\u5173\u8054\u7684\u5c97\u4f4d", returnPropertiesFilter="", scope=NebulaServiceMethod.ScopeType.READ)
    public Page<PositionVo> findPageByRoleId(@ServiceMethodParam(name="id") String roleId, @ServiceMethodParam(name="name") String name, @ServiceMethodParam(name="userName") String userName, @ServiceMethodParam(name="pageable") Pageable pageable) {
        if (StringUtils.isBlank((CharSequence)roleId)) {
            return new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        Set<PositionVo> positionVosInRoleId = this.findByRoleId(roleId);
        if (CollectionUtils.isEmpty(positionVosInRoleId)) {
            return new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        List<String> positionIdArray = this.getPositionIdList(positionVosInRoleId);
        HashMap condition = Maps.newHashMap();
        condition.put("ids", positionIdArray);
        condition.put("name", name);
        condition.put("userName", userName);
        condition.put("flag", 1);
        condition.put("pageable", pageable);
        return this.positionService.findByConditions((Map)condition, pageable);
    }

    @NebulaServiceMethod(name="RolePositionMappingService.findNotBindRole", desc="\u6839\u636e\u89d2\u8272ID\u67e5\u8be2\u6ca1\u6709\u5173\u8054\u8be5\u89d2\u8272\u7684\u5c97\u4f4d", returnPropertiesFilter="organization,positionLevel,parent", scope=NebulaServiceMethod.ScopeType.READ)
    public Page<PositionVo> findNotBindRole(@ServiceMethodParam(name="id") String roleId, @ServiceMethodParam(name="name") String name, @ServiceMethodParam(name="userName") String userName, @ServiceMethodParam(name="pageable") Pageable pageable) {
        if (StringUtils.isBlank((CharSequence)roleId)) {
            return new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        HashSet positionVosInRoleId = this.findByRoleId(roleId);
        if (positionVosInRoleId == null) {
            positionVosInRoleId = Sets.newHashSet();
        }
        List<String> positionIdArray = this.getPositionIdList(positionVosInRoleId);
        HashMap condition = Maps.newHashMap();
        condition.put("ids", positionIdArray);
        condition.put("name", name);
        condition.put("userName", userName);
        condition.put("flag", 0);
        condition.put("pageable", pageable);
        return this.positionService.findByConditions((Map)condition, pageable);
    }

    @NebulaServiceMethod(name="RolePositionMappingService.findNotBindAnyRole", desc="\u5206\u9875\u67e5\u8be2\u6ca1\u6709\u7ed1\u5b9a\u4efb\u4f55\u89d2\u8272\u7684\u804c\u4f4d", returnPropertiesFilter="organization,positionLevel,parent", scope=NebulaServiceMethod.ScopeType.READ)
    public Page<PositionVo> findNotBindAnyRole(@ServiceMethodParam(name="name") String name, @ServiceMethodParam(name="userName") String userName, @ServiceMethodParam(name="pageable") Pageable pageable) {
        List all = this.rolePositionMappingRepository.findAll();
        if (all == null) {
            all = Lists.newLinkedList();
        }
        List<String> codes = this.getPositionCodeListFromMapping(all);
        HashMap condition = Maps.newHashMap();
        condition.put("codes", codes);
        condition.put("name", name);
        condition.put("userName", userName);
        condition.put("flag", 0);
        condition.put("pageable", pageable);
        return this.positionService.findByConditions((Map)condition, pageable);
    }

    @Transactional
    public void rebindPositionsById(String roleId, String rebinRoleId, String[] positionCodes) {
        Validate.notBlank((CharSequence)roleId, (String)"\u89d2\u8272\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)rebinRoleId, (String)"\u66ff\u6362\u7684\u89d2\u8272\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Object[])positionCodes, (String)"\u804c\u4f4d\u5217\u8868\u4e0d\u80fd\u4e3a\u4e3a\u7a7a", (Object[])new Object[0]);
        this.unbindPositions(roleId, positionCodes);
        this.bindPositions(rebinRoleId, positionCodes);
    }

    private List<String> getPositionIdList(Set<PositionVo> positionVos) {
        if (CollectionUtils.isEmpty(positionVos)) {
            return Lists.newLinkedList();
        }
        LinkedList list = Lists.newLinkedList();
        for (PositionVo positionVo : positionVos) {
            list.add(positionVo.getId());
        }
        return list;
    }

    private String[] getPositionIdArray(Set<PositionVo> positionVos) {
        if (CollectionUtils.isEmpty(positionVos)) {
            return new String[0];
        }
        String[] idArray = new String[positionVos.size()];
        Integer count = 0;
        for (PositionVo positionVo : positionVos) {
            idArray[count.intValue()] = positionVo.getId();
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        return idArray;
    }

    private List<String> getPositionCodeListFromMapping(List<RolePositionMappingEntity> rolePositionMappingEntities) {
        if (CollectionUtils.isEmpty(rolePositionMappingEntities)) {
            return Lists.newLinkedList();
        }
        LinkedList list = Lists.newLinkedList();
        for (RolePositionMappingEntity rolePositionMappingEntity : rolePositionMappingEntities) {
            list.add(rolePositionMappingEntity.getPositionCode());
        }
        return list;
    }
}

