
package com.bizunited.platform.rbac.server.starter.entity;


import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;

/**
 * @author: weikangning
 * @Date: 2020/8/14 16:13
 * @Description:角色与职位级别关联模型
 */

@Entity
@ApiModel(value = "RolePositionLevelMappingEntity", description = "角色与职位级别的关联模型")
@Table(name = "engine_role_position_level_mapping", uniqueConstraints = @UniqueConstraint(columnNames = {"role_code", "position_level_code"}))
@org.hibernate.annotations.Table(appliesTo = "engine_role_position_level_mapping", comment = "角色与职位级别的关联模型")
public class RolePositionLevelMappingEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = -3194398970444778651L;

  /**
   * 角色编码
   */
  @ApiModelProperty("角色编码")
  @ManyToOne(fetch = FetchType.LAZY)
  @SaturnColumn(description = "角色编码")
  @JoinColumn(name = "role_code", nullable = false, referencedColumnName = "role_code", columnDefinition = "varchar(64) COMMENT '角色编码'")
  private RoleEntity role;

  /**
   * 职位级别的唯一编号
   */
  @SaturnColumn(description = "职位级别的唯一编号")
  @ApiModelProperty(name = "positionLevelCode", value = "职位级别的唯一编号", required = true)
  @Column(name = "position_level_code", nullable = false, columnDefinition = "varchar(128) COMMENT '职位级别的唯一编号'")
  private String positionLevelCode;

  public RoleEntity getRole() {
    return role;
  }

  public void setRole(RoleEntity role) {
    this.role = role;
  }

  public String getPositionLevelCode() {
    return positionLevelCode;
  }

  public void setPositionLevelCode(String positionLevelCode) {
    this.positionLevelCode = positionLevelCode;
  }
}
