package com.bizunited.platform.rbac.server.starter.entity;


import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import java.util.Date;

/**
 * @ClassName : RoleEXtendEntity
 * @Description : 角色扩展
 * @Author : chengzhongxiang
 * @Date: 2020-09-05 15:06
 */
@ApiModel(value = "RoleEXtendEntity", description = "角色扩展")
@Table(name="engine_role_extend")
@Entity
@org.hibernate.annotations.Table(appliesTo = "engine_role_extend" , comment = "柯伊伯表单引擎用户角色拓展信息")
public class RoleExtendEntity extends UuidEntity {

  /**
   * 
   */
  private static final long serialVersionUID = 7599750513627114210L;

  @ApiModelProperty(name = "roleEntity",value = "角色",required = true)
  @OneToOne(fetch = FetchType.LAZY, targetEntity = RoleEntity.class)
  @JoinColumn(name = "role_id", columnDefinition = "varchar(255) COMMENT '角色id'")
  @SaturnColumn(description="角色id")
  private RoleEntity roleEntity;

  @ApiModelProperty(name = "deleteFlag",value = "逻辑删除标志 1 已逻辑删除，0 未逻辑删除")
  @SaturnColumn(description = "逻辑删除标志",nullable = false)
  private Integer deleteFlag;

  @ApiModelProperty(name = "createUser", value = "创建人", required = true)
  @Column(name = "create_user", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '创建人'")
  @SaturnColumn(description = "创建人", nullable = false)
  private String createUser;

  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间", nullable = false)
  private Date createTime = new Date();

  public RoleEntity getRoleEntity() {
    return roleEntity;
  }

  public void setRoleEntity(RoleEntity roleEntity) {
    this.roleEntity = roleEntity;
  }

  public Integer getDeleteFlag() {
    return deleteFlag;
  }

  public void setDeleteFlag(Integer deleteFlag) {
    this.deleteFlag = deleteFlag;
  }

  public String getCreateUser() {
    return createUser;
  }

  public void setCreateUser(String createUser) {
    this.createUser = createUser;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
}
