package com.bizunited.platform.rbac.server.starter.repository.internal;

import com.bizunited.platform.rbac.server.starter.entity.CompetenceEntity;
import com.bizunited.platform.rbac.server.vo.CompetenceVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository("CompetenceRepositoryCustom")
public interface CompetenceRepositoryCustom {
  /**
   * 这里只准对功能信息中viewItem为false的信息进行分页查询处理（查询条件也只有功能名）
   * @param pageable 
   * @param competence
   * @return
   */
  Page<CompetenceEntity> findByConditions(Pageable pageable, CompetenceVo competence);

  /**
   * 菜单条件查询（不分页,只针对菜单）
   * @param competence
   * @return
   */
  List<CompetenceEntity> findAllByConditions(CompetenceVo competence);
}
