/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.starter.service.init;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.enums.NormalStatusEnum;
import com.bizunited.platform.common.service.init.InitProcessService;
import com.bizunited.platform.rbac.server.service.RbacSettingService;
import com.bizunited.platform.rbac.server.starter.entity.ButtonEntity;
import com.bizunited.platform.rbac.server.starter.entity.CompetenceEntity;
import com.bizunited.platform.rbac.server.starter.entity.RoleEntity;
import com.bizunited.platform.rbac.server.starter.entity.RoleUserMappingEntity;
import com.bizunited.platform.rbac.server.starter.repository.ButtonRepository;
import com.bizunited.platform.rbac.server.starter.repository.CompetenceRepository;
import com.bizunited.platform.rbac.server.starter.repository.RoleRepository;
import com.bizunited.platform.rbac.server.starter.repository.RoleUserMappingRepository;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="rbacInitProcess")
public class RbacInitProcess
implements InitProcessService {
    private static final String ADMIN_NAME = "admin";
    private static final String ADMIN_ROLE_NAME = "ADMIN";
    private static final String BASEROLE_NAME = "BASEROLE";
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private ButtonRepository buttonRepository;
    @Autowired
    private CompetenceRepository competenceRepository;
    @Autowired
    private RbacSettingService rbacSettingService;
    @Autowired
    private RoleUserMappingRepository roleUserMappingRepository;
    @Autowired
    private PlatformContext platformContext;

    public boolean doProcess() {
        return this.roleRepository.findByRoleName(ADMIN_ROLE_NAME) == null || this.roleRepository.findByRoleName(ADMIN_NAME) == null || this.rbacSettingService.findRbacSetting() == null;
    }

    public int sort() {
        return 1;
    }

    public boolean stopOnException() {
        return true;
    }

    @Transactional
    public void init() {
        if (this.roleRepository.findByRoleName(BASEROLE_NAME) == null) {
            this.initBaseRole();
            this.initBaseRoleCompetence();
            this.initBaseRoleButtons();
        }
        if (this.roleRepository.findByRoleName(ADMIN_ROLE_NAME) == null) {
            this.initAdminRole();
        }
        this.rbacSettingService.init();
    }

    private void initBaseRole() {
        RoleEntity role = new RoleEntity();
        role.setComment("\u7528\u6237\u57fa\u7840\u89d2\u8272");
        role.setCreateDate(new Date());
        role.setRoleName(BASEROLE_NAME);
        role.setRoleCode(BASEROLE_NAME);
        role.setTstatus(1);
        role.setIsDeny(true);
        this.roleRepository.saveAndFlush((Object)role);
    }

    private void initBaseRoleButtons() {
        RoleEntity baserole = this.roleRepository.findByRoleName(BASEROLE_NAME);
        Validate.notNull((Object)((Object)baserole), (String)"\u521d\u59cb\u5316\u7528\u6237\u57fa\u7840\u89d2\u8272\u65f6\u672a\u627e\u5230\u57fa\u7840\u89d2\u8272!", (Object[])new Object[0]);
        HashSet<String> buttonCodes = new HashSet<String>();
        buttonCodes.add("home-init");
        buttonCodes.add("account-getPosition");
        buttonCodes.add("account-getRoles");
        buttonCodes.add("account-style");
        buttonCodes.add("account-reset");
        buttonCodes.add("account-search");
        buttonCodes.add("position-style");
        buttonCodes.add("position-reset");
        buttonCodes.add("position-search");
        buttonCodes.add("position-edit");
        buttonCodes.add("userGroup-search");
        buttonCodes.add("userGroup-style");
        buttonCodes.add("userGroup-reset");
        buttonCodes.add("org-style");
        buttonCodes.add("org-search");
        buttonCodes.add("org-reset");
        buttonCodes.add("role-search");
        buttonCodes.add("role-style");
        buttonCodes.add("role-reset");
        buttonCodes.add("role-authBind");
        buttonCodes.add("menuManage-roleRelation");
        buttonCodes.add("menuManage-buttonManage");
        buttonCodes.add("menuManage-reset");
        buttonCodes.add("menuManage-search");
        buttonCodes.add("menuManage-style");
        buttonCodes.add("btnManage-reset");
        buttonCodes.add("btnManage-search");
        buttonCodes.add("btnManage-roleRelation");
        buttonCodes.add("btnManage-style");
        buttonCodes.add("envVariable-view");
        buttonCodes.add("envVariable-search");
        buttonCodes.add("codeRule-view");
        buttonCodes.add("codeRule-search");
        buttonCodes.add("scheduler-search");
        buttonCodes.add("scheduler-log");
        buttonCodes.add("scheduler-detail");
        buttonCodes.add("dataviewmanage-search");
        buttonCodes.add("dataview-previewData");
        buttonCodes.add("remoteservicemanage-search");
        buttonCodes.add("remoteservice-search");
        buttonCodes.add("servicesource-search");
        buttonCodes.add("basicImport-search");
        buttonCodes.add("basicImport-analysisAll");
        buttonCodes.add("formTemplate-search");
        buttonCodes.add("formTemplate-reset");
        buttonCodes.add("formStyle-preview");
        buttonCodes.add("globalfunc-search");
        buttonCodes.add("instance-search");
        buttonCodes.add("instance-form");
        buttonCodes.add("instance-info");
        buttonCodes.add("instance-activity");
        buttonCodes.add("tableManage-search");
        buttonCodes.add("tableManage-reload");
        buttonCodes.add("listTemp-search");
        buttonCodes.add("listTemp-view");
        buttonCodes.add("listTemp-reset");
        buttonCodes.add("formImport-search");
        buttonCodes.add("formImport-analysisAll");
        buttonCodes.add("pageflow-search");
        buttonCodes.add("pageflow-view");
        buttonCodes.add("flowTemplate-search");
        buttonCodes.add("flowTemplate-look");
        buttonCodes.add("flowTemplate-check");
        buttonCodes.add("monitor-search");
        buttonCodes.add("operation-search");
        buttonCodes.add("listFlow-search");
        buttonCodes.add("listFlow-detail");
        buttonCodes.add("useableFlowTemp-search");
        buttonCodes.add("useableFlowTemp-look");
        buttonCodes.add("launchBySelf-search");
        buttonCodes.add("launchBySelf-look");
        buttonCodes.add("doneFlow-search");
        buttonCodes.add("doneFlow-look");
        buttonCodes.add("doneFlow-detail");
        buttonCodes.add("waitingFlow-search");
        buttonCodes.add("copyFlow-search");
        buttonCodes.add("dataAuth-search");
        buttonCodes.add("dictManage-search");
        buttonCodes.add("basicExport-search");
        for (String buttonCode : buttonCodes) {
            ButtonEntity button = this.buttonRepository.findByCodeAndProjectName(buttonCode, this.platformContext.getAppName());
            if (button == null) continue;
            this.buttonRepository.bindButton(baserole.getId(), button.getId());
        }
    }

    private void initBaseRoleCompetence() {
        RoleEntity baserole = this.roleRepository.findByRoleName(BASEROLE_NAME);
        Validate.notNull((Object)((Object)baserole), (String)"\u521d\u59cb\u5316\u7528\u6237\u57fa\u7840\u89d2\u8272\u65f6\u672a\u627e\u5230\u57fa\u7840\u89d2\u8272!", (Object[])new Object[0]);
        HashSet<String> comments = new HashSet<String>();
        comments.add("\u8868\u5355\u5b9e\u4f8b\u5217\u8868");
        comments.add("\u8868\u5355\u6a21\u677f\u7ba1\u7406");
        comments.add("\u8868\u5355\u6837\u5f0f\u7ba1\u7406");
        comments.add("\u8868\u5355\u6a21\u677f\u5217\u8868");
        comments.add("\u8d26\u6237\u7ba1\u7406");
        comments.add("\u9875\u9762\u6d41\u7ba1\u7406");
        comments.add("\u5168\u5c40\u51fd\u6570\u7ba1\u7406");
        comments.add("\u7528\u6237\u4e0e\u6743\u9650");
        comments.add("\u7528\u6237\u7ec4\u7ba1\u7406");
        comments.add("\u8868\u5355\u5f15\u64ce");
        comments.add("\u57fa\u7840\u914d\u7f6e\u5bfc\u5165\u7ba1\u7406");
        comments.add("\u6570\u636e\u89c6\u56fe\u7f16\u8f91");
        comments.add("\u76d1\u542c\u5668\u7ba1\u7406");
        comments.add("\u8fdc\u7aef\u8c03\u7528-\u5730\u5740\u7ba1\u7406");
        comments.add("\u5217\u8868\u529f\u80fd");
        comments.add("\u529f\u80fd\u83dc\u5355\u6743\u9650\u7ba1\u7406");
        comments.add("\u8868\u5355\u5b9e\u4f8b\u7ba1\u7406");
        comments.add("\u53c2\u6570\u7ba1\u7406");
        comments.add("\u89d2\u8272\u7ba1\u7406");
        comments.add("\u6211\u7684\u5f85\u529e");
        comments.add("\u6211\u7684\u5df2\u529e");
        comments.add("\u7f16\u7801\u89c4\u5219\u7ba1\u7406");
        comments.add("\u57fa\u7840\u914d\u7f6e\u5bfc\u51fa\u7ba1\u7406");
        comments.add("\u6570\u636e\u89c6\u56fe-\u6570\u636e\u6e90\u7ba1\u7406");
        comments.add("\u6211\u53ef\u53d1\u8d77\u7684\u6d41\u7a0b");
        comments.add("\u4e1a\u52a1\u6570\u636e\u8868\u7ba1\u7406");
        comments.add("\u7ec4\u7ec7\u673a\u6784\u7ba1\u7406");
        comments.add("\u9996\u9875");
        comments.add("\u6570\u636e\u5bfc\u5165\u7ba1\u7406");
        comments.add("\u8fdc\u7aef\u8c03\u7528\u7ba1\u7406");
        comments.add("\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868");
        comments.add("\u6211\u7684\u6284\u9001");
        comments.add("\u6570\u636e\u5bfc\u51fa\u7ba1\u7406");
        comments.add("\u529f\u80fd\u6309\u94ae\u6743\u9650\u7ba1\u7406");
        comments.add("\u6570\u636e\u6743\u9650");
        comments.add("\u6d41\u7a0b\u6a21\u677f\u7ba1\u7406");
        comments.add("\u6211\u53d1\u8d77\u7684\u6d41\u7a0b");
        comments.add("\u6309\u94ae\u529f\u80fd\u64cd\u4f5c\u7ba1\u7406");
        comments.add("\u6570\u636e\u5b57\u5178\u7ba1\u7406");
        comments.add("\u6570\u636e\u6e90");
        comments.add("\u7cfb\u7edf\u4e3b\u9898\u7ba1\u7406");
        comments.add("\u5b9a\u65f6\u4efb\u52a1\u7ba1\u7406");
        comments.add("\u5c97\u4f4d\u7ba1\u7406");
        comments.add("\u6d41\u7a0b\u6a21\u677f\u5217\u8868");
        comments.add("\u57fa\u7840\u5de5\u5177\u5957\u4ef6");
        comments.add("\u6d41\u7a0b\u5f15\u64ce");
        comments.add("\u6d41\u7a0b\u5b9e\u4f8b\u7ba1\u7406");
        for (String comment : comments) {
            List<CompetenceEntity> competences = this.competenceRepository.findByComment(comment);
            if (CollectionUtils.isEmpty(competences)) continue;
            for (CompetenceEntity competence : competences) {
                this.roleRepository.bindCompetence(competence.getId(), baserole.getId());
            }
        }
    }

    private void initAdminRole() {
        RoleEntity role = new RoleEntity();
        role.setComment("\u7ba1\u7406\u5458\u89d2\u8272");
        role.setCreateDate(new Date());
        role.setRoleName(ADMIN_ROLE_NAME);
        role.setRoleCode(ADMIN_ROLE_NAME);
        role.setTstatus(NormalStatusEnum.ENABLE.getStatus());
        role.setIsDeny(true);
        this.roleRepository.saveAndFlush((Object)role);
        RoleUserMappingEntity entity = new RoleUserMappingEntity();
        entity.setRole(role);
        entity.setUserAccount(ADMIN_NAME);
        this.roleUserMappingRepository.save((Object)entity);
    }
}

