package com.bizunited.platform.rbac.server.starter.controller;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;

import com.bizunited.platform.rbac.server.service.RoleExtendVoService;
import com.bizunited.platform.rbac.server.vo.RoleExtendVo;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * RoleEXtendEntity业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @author saturn
 */
@RestController
@RequestMapping("/v1/nebula/roleExtend")
public class RoleExtendVoController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(RoleExtendVoController.class);

  @Autowired
  private RoleExtendVoService roleExtendVoService;

  /**
   * 创建角色拓展
   * @param roleExtendVo 需要创建的角色拓展
   */
  @ApiOperation(value = "创建角色拓展")
  @RequestMapping(value="/create" , method={RequestMethod.POST})
  public ResponseModel create(@RequestBody @ApiParam("需要创建的角色拓展") RoleExtendVo roleExtendVo) {
    try {
      RoleExtendVo extendVo = this.roleExtendVoService.create(roleExtendVo);
      return this.buildHttpResult(extendVo);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 更新角色拓展
   * @param roleExtendVo 需要更新的角色
   */
  @ApiOperation(value = "更新角色拓展")
  @RequestMapping(value="/update" , method={RequestMethod.PATCH})
  public ResponseModel update(@RequestBody @ApiParam("更新的角色拓展") RoleExtendVo roleExtendVo) {
    try {
      this.roleExtendVoService.update(roleExtendVo);
      return this.buildHttpResult();
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 根据角色编码批量删除角色、并解绑角色菜单、按钮
   * @param roleCodes 角色编码列表
   */
  @ApiOperation(value = "根据角色编码批量删除角色、并解绑角色菜单、按钮")
  @RequestMapping(value="/deleteByRoleCodes" , method={RequestMethod.POST})
  public ResponseModel deleteByRoleCodes(@RequestBody @ApiParam("主键列表") String[] roleCodes) {
    try {
      this.roleExtendVoService.deleteByCodes(roleCodes);
      return this.buildHttpResult();
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 分页条件查询未删除的角色信息
   * @param roleName
   * @return
   */
  @ApiOperation(value = "根据角色名称，或则角色编码，或则角色编码查询角色信息 （角色名称支持模糊查询）")
  @GetMapping(value = "/queryPage")
  public ResponseModel queryPage(@ApiParam(value = "角色名称") @RequestParam(name="roleName", required = false) String roleName,
                                 @ApiParam(value = "角色编码") @RequestParam(name="roleCode", required = false) String roleCode,
                                 @ApiParam(value = "角色状态") @RequestParam(name="tstatus", required = false) Integer tstatus,
                                 @PageableDefault(value = 50) Pageable pageable) {
    try {
      Page<JSONObject> result = this.roleExtendVoService.queryPage(roleName, roleCode, tstatus, pageable);
      return this.buildHttpResultW(result, "parent");
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

} 
