package com.bizunited.platform.rbac.server.starter.repository.internal;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.google.common.collect.Maps;
import org.hibernate.query.internal.NativeQueryImpl;
import org.hibernate.query.spi.NativeQueryImplementor;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName : RolePositionLevelMappingRepositoryCustomImpl
 * @Description :
 * @Author : chengzhongxiang
 * @Date: 2020-09-24 19:52
 */
@Repository("RolePositionLevelMappingRepositoryCustomImpl")
public class RolePositionLevelMappingRepositoryCustomImpl implements RolePositionLevelMappingRepositoryCustom , PageRepositoryImpl {

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;

  private static final String NAME="name";
  private static final String ROLENAME="roleName";

  /**
   * 分页查询
   * @param conditions
   * @param pageable
   * @return
   */
  @Override
  public List<Map<String,Object>> queryPage(Map<String, Object> conditions, Pageable pageable) {
    StringBuilder sql=new StringBuilder("SELECT epl.id id, " +
            "epl.CODE code, " +
            "epl.`name` name, " +
            "GROUP_CONCAT( er.role_code ) roleCode, " +
            "GROUP_CONCAT( er.role_name ) roleName, " +
            "epl.state state  " +
            "FROM " +
            "engine_position_level epl " +
            "INNER JOIN engine_role_position_level_mapping erpl ON erpl.position_level_code = epl.`code` " +
            "INNER JOIN engine_role er ON er.role_code = erpl.role_code " +
            "where epl.delete_flag <> 1");
    StringBuilder condition=new StringBuilder();
    HashMap<String, Object> parameter = Maps.newHashMap();
    Object name = conditions.get(NAME);
    if(name != null){
      condition.append(" AND epl.name like CONCAT('%', :name, '%')");
      parameter.put(NAME,name);
    }
    Object roleName = conditions.get(ROLENAME);
    if(roleName != null){
      condition.append(" AND er.role_name like CONCAT('%', :roleName, '%')");
      parameter.put(ROLENAME,roleName);
    }
    condition.append(" group by epl.id order by epl.create_time DESC");
    sql.append(condition);
    Query nativeQuery = entityManager.createNativeQuery(sql.toString());
    nativeQuery.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    nativeQuery.setMaxResults(pageable.getPageSize());
    parameter.forEach((k, v) -> {
      nativeQuery.setParameter(k, v);
    });
    NativeQueryImplementor nativeQueryImplementor = nativeQuery.unwrap(NativeQueryImpl.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);

    return nativeQueryImplementor.getResultList();
  }
}
