package com.bizunited.platform.rbac.server.starter.repository;


import com.bizunited.platform.rbac.server.starter.entity.RoleExtendEntity;
import com.bizunited.platform.rbac.server.starter.repository.internal.RoleExtendEntityRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * RoleExtendEntity业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_RoleExtendEntityRepository")
public interface RoleExtendEntityRepository
    extends
        JpaRepository<RoleExtendEntity, String>
      , JpaSpecificationExecutor<RoleExtendEntity>
      , RoleExtendEntityRepositoryCustom
  {

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct r from RoleExtendEntity r "
      + " where r.id=:id ")
  public RoleExtendEntity findDetailsById(@Param("id") String id);

    /**
     * 按照角色编码查询
     * @param roleCode
     * @return
     */
  @Query("from RoleExtendEntity f " +
          "left join fetch f.roleEntity re " +
          "where re.roleCode = :roleCode ")
  public RoleExtendEntity findByRoleCode(@Param("roleCode") String roleCode);

    /**
     * 按照角色名称查询
     * @param roleName
     * @return
     */
  @Query("from RoleExtendEntity re " +
          "left join fetch re.roleEntity r " +
          "where r.roleName = :roleName")
  public RoleExtendEntity findByRoleName(@Param("roleName") String roleName);

}