package com.bizunited.platform.rbac.server.starter.repository;

import com.bizunited.platform.rbac.server.starter.entity.RolePositionLevelMappingEntity;
import com.bizunited.platform.rbac.server.starter.repository.internal.RolePositionLevelMappingRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author: weikangning
 * @Date: 2020/8/16 21:23
 * @Description:
 */
@Repository("RolePositionLevelMappingRepository")
public interface RolePositionLevelMappingRepository extends JpaRepository<RolePositionLevelMappingEntity, String>,
        JpaSpecificationExecutor<RolePositionLevelMappingEntity> , RolePositionLevelMappingRepositoryCustom {
  /**
   * 根据角色和职位级别编码查询统计
   *
   * @param role
   * @param positionLevelCode
   * @return
   */
  @Query(value = "SELECT COUNT(*) FROM RolePositionLevelMappingEntity rplm WHERE rplm.role.roleCode = :role AND rplm.positionLevelCode = :positionLevelCode")
  long countByRoleAndPositionLevel(@Param("role") String role, @Param("positionLevelCode") String positionLevelCode);

  /**
   * 根据角色查询统计
   *
   * @param role
   * @return
   */
  @Query(value = "SELECT COUNT(*) FROM RolePositionLevelMappingEntity rplm WHERE rplm.role.roleCode = :role")
  long countByRole(@Param("role") String role);

  /**
   * 根据职位级别编码查询统计
   *
   * @param positionLevelCode
   * @return
   */
  @Query(value = "SELECT COUNT(*) FROM RolePositionLevelMappingEntity rplm WHERE rplm.positionLevelCode = :positionLevelCode")
  long countByPositionLevelCode(@Param("positionLevelCode") String positionLevelCode);

  /**
   * 根据角色和职位级别编码查询
   *
   * @param roleCode
   * @param positionLevelCode
   * @return
   */
  @Query("from RolePositionLevelMappingEntity rplm where rplm.role.roleCode = :roleCode and rplm.positionLevelCode = :positionLevelCode ")
  RolePositionLevelMappingEntity findByRoleAndPositionLevelCode(@Param("roleCode") String roleCode, @Param("positionLevelCode") String positionLevelCode);

  /**
   * 根据角色查询
   *
   * @param role
   * @return
   */
  @Query("from RolePositionLevelMappingEntity rplm where rplm.role.roleCode = :role")
  List<RolePositionLevelMappingEntity> findByRole(@Param("role") String role);

  /**
   * 根据职位级别查询
   *
   * @param positionLevelCode
   * @return
   */
  @Query("from RolePositionLevelMappingEntity rplm where rplm.positionLevelCode = :positionLevelCode ")
  List<RolePositionLevelMappingEntity> findBypositionLevelCode(@Param("positionLevelCode") String positionLevelCode);

  /**
   * 给定一个指定的职位级别信息，解除这个职位级别信息和所有角色的绑定关系
   *
   * @param positionLevelCode
   * @return
   */
  @Modifying
  @Query(value = "DELETE  FROM RolePositionLevelMappingEntity WHERE position_level_code = :positionLevelCode")
  void unbindPositionLevelCode(@Param("positionLevelCode") String positionLevelCode);
}
