package com.bizunited.platform.rbac.server.starter.repository.internal;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.rbac.server.starter.entity.CompetenceEntity;
import com.bizunited.platform.rbac.server.vo.CompetenceVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository("CompetenceRepositoryCustomImpl")
public class CompetenceRepositoryImpl implements CompetenceRepositoryCustom, PageRepositoryImpl {

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  private static final String COMMENT = "comment";
  private static final String RESOURCE = "resource";
  private static final String TSTATUS = "tstatus";
  private static final String METHODS = "methods";

  /* (non-Javadoc)
   * @see com.bizunited.platform.kuiper.starter.repository.internal.CompetenceRepositoryCustom#queryPage(org.springframework.data.domain.Pageable, java.util.Map)
   */
  @Override
  public Page<CompetenceEntity> findByConditions(Pageable pageable, CompetenceVo competence) {
    /*
     * 目前的查询条件是：名称（模糊）、请求方式、状态
     * */
    StringBuilder hql = new StringBuilder("from CompetenceEntity co where co.viewItem = 0");
    StringBuilder countHql = new StringBuilder("select count(*) from CompetenceEntity co where co.viewItem = 0 ");
    StringBuilder condition = new StringBuilder();
    //筛选项目名称
    condition.append(" and co.projectName=:projectName ");
    Map<String, Object> parameter = new HashMap<>();
    parameter.put("projectName", ApplicationContextUtils.getProjectName());
    if(competence != null){
      // 名称
      if(StringUtils.isNotBlank(competence.getComment())) {
        condition.append(" AND co.comment like CONCAT('%', :comment,'%') ");
        parameter.put(COMMENT, competence.getComment());
      }
      //请求方式
      if(StringUtils.isNotBlank(competence.getMethods())) {
        condition.append(" AND co.methods = :methods ");
        parameter.put(METHODS, competence.getMethods());
      }

      //角色状态
      if(competence.getTstatus() != null) {
        condition.append(" AND co.tstatus = :tstatus ");
        parameter.put(TSTATUS, competence.getTstatus());
      }
    }
    hql.append(condition).append(" order by co.sortIndex");
    countHql.append(condition);

    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameter, pageable, false, null);
  }

  @SuppressWarnings("unchecked")
  @Override
  public List<CompetenceEntity> findAllByConditions(CompetenceVo competence) {
    /*
     * 目前的查询条件是：菜单名称（模糊）、菜单类型、状态
     * */
    StringBuilder hql = new StringBuilder("from CompetenceEntity co where co.viewItem = 1");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameter = new HashMap<>();
    condition.append(" AND co.projectName=:projectName ");
    parameter.put("projectName", ApplicationContextUtils.getProjectName());
    if(competence != null){
      // 菜单名称
      if(StringUtils.isNotBlank(competence.getComment())) {
        condition.append(" AND co.comment like CONCAT('%', :comment,'%') ");
        parameter.put(COMMENT, competence.getComment());
      }
      //菜单类型
      if(StringUtils.isNotBlank(competence.getResource())) {
        condition.append(" AND co.resource like CONCAT(:resource,'%')  ");
        parameter.put(RESOURCE, competence.getResource());
      }

      //角色状态
      if(competence.getTstatus() != null) {
        condition.append(" AND co.tstatus = :tstatus ");
        parameter.put(TSTATUS, competence.getTstatus());
      }
    }
    hql.append(condition).append(" order by co.createDate desc");

    Query query = entityManager.createQuery(hql.toString());
    parameter.forEach((k, v) -> {
      query.setParameter(k, v);
    });
    return query.getResultList();
  }
}
