/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.rbac.server.service.RoleExtendVoService;
import com.bizunited.platform.rbac.server.vo.RoleExtendVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/roleExtend"})
public class RoleExtendVoController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoleExtendVoController.class);
    @Autowired
    private RoleExtendVoService roleExtendVoService;

    @ApiOperation(value="\u521b\u5efa\u89d2\u8272\u62d3\u5c55")
    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public ResponseModel create(@RequestBody @ApiParam(value="\u9700\u8981\u521b\u5efa\u7684\u89d2\u8272\u62d3\u5c55") RoleExtendVo roleExtendVo) {
        try {
            RoleExtendVo extendVo = this.roleExtendVoService.create(roleExtendVo);
            return this.buildHttpResult(extendVo);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u89d2\u8272\u62d3\u5c55")
    @RequestMapping(value={"/update"}, method={RequestMethod.PATCH})
    public ResponseModel update(@RequestBody @ApiParam(value="\u66f4\u65b0\u7684\u89d2\u8272\u62d3\u5c55") RoleExtendVo roleExtendVo) {
        try {
            this.roleExtendVoService.update(roleExtendVo);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u7f16\u7801\u6279\u91cf\u5220\u9664\u89d2\u8272\u3001\u5e76\u89e3\u7ed1\u89d2\u8272\u83dc\u5355\u3001\u6309\u94ae")
    @RequestMapping(value={"/deleteByRoleCodes"}, method={RequestMethod.POST})
    public ResponseModel deleteByRoleCodes(@RequestBody @ApiParam(value="\u4e3b\u952e\u5217\u8868") String[] roleCodes) {
        try {
            this.roleExtendVoService.deleteByCodes(roleCodes);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u540d\u79f0\uff0c\u6216\u5219\u89d2\u8272\u7f16\u7801\uff0c\u6216\u5219\u89d2\u8272\u7f16\u7801\u67e5\u8be2\u89d2\u8272\u4fe1\u606f \uff08\u89d2\u8272\u540d\u79f0\u652f\u6301\u6a21\u7cca\u67e5\u8be2\uff09")
    @GetMapping(value={"/queryPage"})
    public ResponseModel queryPage(@ApiParam(value="\u89d2\u8272\u540d\u79f0") @RequestParam(name="roleName", required=false) String roleName, @ApiParam(value="\u89d2\u8272\u7f16\u7801") @RequestParam(name="roleCode", required=false) String roleCode, @ApiParam(value="\u89d2\u8272\u72b6\u6001") @RequestParam(name="tstatus", required=false) Integer tstatus, @PageableDefault(value=50) Pageable pageable) {
        try {
            Page result = this.roleExtendVoService.queryPage(roleName, roleCode, tstatus, pageable);
            return this.buildHttpResultW(result, new String[]{"parent"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

