/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.starter.repository;

import com.bizunited.platform.rbac.server.starter.entity.RoleEntity;
import com.bizunited.platform.rbac.server.starter.repository.internal.RoleRepositoryCustom;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="RoleRepository")
public interface RoleRepository
extends JpaRepository<RoleEntity, String>,
JpaSpecificationExecutor<RoleEntity>,
RoleRepositoryCustom {
    @Modifying
    @Query(value="insert into engine_role_competence_mapping(role_id , competence_id) values (:roleId , :competenceId)", nativeQuery=true)
    public void bindCompetence(@Param(value="competenceId") String var1, @Param(value="roleId") String var2);

    public List<RoleEntity> findByTstatus(@Param(value="useStatus") Integer var1);

    public RoleEntity findByRoleCode(String var1);

    @Query(value="select distinct r from RoleEntity r inner join fetch r.roleUserMapping a where a.userAccount = :userAccount ")
    public List<RoleEntity> findByUserAccount(@Param(value="userAccount") String var1);

    @Query(value="select distinct r from RoleEntity r inner join r.buttons b inner join b.competences c where c.id = :competenceId")
    public List<RoleEntity> findByCompetenceId(@Param(value="competenceId") String var1);

    public RoleEntity findByRoleName(String var1);

    @Query(value="from RoleEntity m where m.id in :ids")
    public Set<RoleEntity> findByIds(@Param(value="ids") List<String> var1);

    public Set<RoleEntity> findByParentIsNull();

    @Query(value="select r from RoleEntity r inner join fetch r.rolePositionMappings rpm where rpm.positionCode = :positionCode ")
    public Set<RoleEntity> findByPosition(@Param(value="positionCode") String var1);

    @Query(value="select  r from RoleEntity r inner join fetch r.rolePositionMappings rpm where rpm.positionCode in :positionCodes ")
    public Set<RoleEntity> findByPositions(@Param(value="positionCodes") List<String> var1);

    @Query(value="select r from RoleEntity r inner join r.roleOrgMappings rom where rom.orgCode = :orgCode ")
    public Set<RoleEntity> findByOrgCode(@Param(value="orgCode") String var1);

    @Query(value="select r  from  RoleEntity r inner join r.roleUserGroupMappings rgm where rgm.groupCode = :userGroupCode ")
    public Set<RoleEntity> findByUserGroupCode(@Param(value="userGroupCode") String var1);

    @Query(value="from RoleEntity r where r.roleName in :roleNames ")
    public Set<RoleEntity> findByRoleNames(@Param(value="roleNames") Set<String> var1);

    @Modifying
    @Query(value="delete from engine_role where role_code = :roleCode ", nativeQuery=true)
    public void deleteByRoleCode(@Param(value="roleCode") String var1);

    @Query(value="from RoleEntity r where r.roleCode in :roleCodes ")
    public Set<RoleEntity> findByRoleCodes(@Param(value="roleCodes") Set<String> var1);
}

