package com.bizunited.platform.rbac.server.starter.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

/**
 * 角色与组织机构的关联模型
 * @Author: Paul Chan
 * @Date: 2020-04-01 11:45
 */
@Entity
@ApiModel(value = "RoleOrgMappingEntity" , description="角色与组织机构的关联模型")
@Table(name = "engine_role_org_mapping", uniqueConstraints = @UniqueConstraint(columnNames = {"role_code", "org_code"}))
@org.hibernate.annotations.Table(appliesTo = "engine_role_org_mapping" , comment = "角色与组织机构的关联模型")
public class RoleOrgMappingEntity extends UuidEntity {

  private static final long serialVersionUID = 5237870037393199631L;

  /**
   * 角色编码
   */
  @ApiModelProperty("角色编码")
  @ManyToOne(fetch = FetchType.LAZY)
  @SaturnColumn(description="角色编码")
  @JoinColumn(name = "role_code", nullable = false, referencedColumnName = "role_code", columnDefinition = "varchar(64) COMMENT '角色编码'")
  private RoleEntity role;

  /**
   * 组织机构编码
   */
  @ApiModelProperty("组织机构编码")
  @SaturnColumn(description="组织机构编码")
  @Column(name = "org_code", nullable = false, columnDefinition = "varchar(128) COMMENT '组织机构编码'")
  private String orgCode;


  public RoleEntity getRole() {
    return role;
  }

  public void setRole(RoleEntity role) {
    this.role = role;
  }

  public String getOrgCode() {
    return orgCode;
  }

  public void setOrgCode(String orgCode) {
    this.orgCode = orgCode;
  }
}
