package com.bizunited.platform.rbac.server.starter.repository.internal;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.user.common.vo.ReturnPositionLevelVo;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName : RolePositionLevelMappingRepositoryCustomImpl
 * @Description :
 * @Author : chengzhongxiang
 * @Date: 2020-09-24 19:52
 */
@Repository("RolePositionLevelMappingRepositoryCustomImpl")
public class RolePositionLevelMappingRepositoryCustomImpl implements RolePositionLevelMappingRepositoryCustom , PageRepositoryImpl {

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;

  private static final String NAME="name";
  private static final String ROLENAME="roleName";

  /**
   * 分页查询
   * @param conditions
   * @param pageable
   * @return
   */
  @Override
  public Page<ReturnPositionLevelVo> queryPage(Map<String, Object> conditions, Pageable pageable) {
    StringBuilder sql=new StringBuilder("SELECT epl.id id, " +
            "epl.CODE code, " +
            "epl.`name` name, " +
            "GROUP_CONCAT( er.role_code ) roleCode, " +
            "GROUP_CONCAT( er.role_name ) roleName, " +
            "epl.state state, " +
            "epl.create_time createTime " +
            "FROM " +
            "engine_position_level epl " +
            "INNER JOIN engine_role_position_level_mapping erpl ON erpl.position_level_code = epl.`code` " +
            "INNER JOIN engine_role er ON er.role_code = erpl.role_code " +
            "where epl.delete_flag <> 1");
    StringBuilder countSql=new StringBuilder("SELECT count(*) " +
            "FROM ( select epl.id from " +
            "engine_position_level epl " +
            "INNER JOIN engine_role_position_level_mapping erpl ON erpl.position_level_code = epl.`code` " +
            "INNER JOIN engine_role er ON er.role_code = erpl.role_code " +
            "where epl.delete_flag <> 1");
    StringBuilder condition=new StringBuilder();
    HashMap<String, Object> parameter = Maps.newHashMap();
    Object name = conditions.get(NAME);
    if(name != null){
      condition.append(" AND epl.name like CONCAT('%', :name, '%')");
      parameter.put(NAME,name);
    }
    Object roleName = conditions.get(ROLENAME);
    if(roleName != null){
      condition.append(" AND er.role_name like CONCAT('%', :roleName, '%')");
      parameter.put(ROLENAME,roleName);
    }
    condition.append(" group by epl.id");
    sql.append(condition).append(" order by epl.create_time DESC");
    countSql.append(condition).append(" ) c");
    return queryByConditions(entityManager, sql.toString(), countSql.toString(), parameter, pageable, true, ReturnPositionLevelVo.class);

  }
}
