/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.starter.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.enums.NormalStatusEnum;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.rbac.server.enums.CompetenceTypeEnum;
import com.bizunited.platform.rbac.server.service.ButtonService;
import com.bizunited.platform.rbac.server.service.CompetenceService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.starter.entity.ButtonEntity;
import com.bizunited.platform.rbac.server.starter.entity.CompetenceEntity;
import com.bizunited.platform.rbac.server.starter.entity.RoleEntity;
import com.bizunited.platform.rbac.server.starter.repository.CompetenceRepository;
import com.bizunited.platform.rbac.server.starter.repository.RoleRepository;
import com.bizunited.platform.rbac.server.vo.ButtonVo;
import com.bizunited.platform.rbac.server.vo.CompetenceVo;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class CompetenceServiceImpl
implements CompetenceService {
    @Autowired
    private CompetenceRepository competenceRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserService userService;
    @Autowired
    private ButtonService buttonService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Value(value="${rbac.ignoreMethodCheckRoles}")
    private String[] ignoreMethodCheckRoles;
    @Autowired
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    private static final String MESS_RESOURCE = "resource";

    @Transactional
    public CompetenceVo create(CompetenceVo comp) {
        this.validCompetence(comp);
        if (comp.getViewItem().equals(NormalStatusEnum.ENABLE.getStatus())) {
            String code = comp.getCode();
            Validate.notNull((Object)code, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            long count = this.competenceRepository.countByCodeAndProjectName(comp.getCode(), ApplicationContextUtils.getProjectName());
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u91cd\u590d", (Object[])new Object[0]);
        }
        comp.setId(null);
        comp.setMethods(comp.getMethods().toUpperCase());
        comp.setTstatus(NormalStatusEnum.ENABLE.getStatus());
        comp.setCreateDate(new Date());
        comp.setModifyDate(new Date());
        if (comp.getSortIndex() == null) {
            comp.setSortIndex(Integer.valueOf(100));
        }
        CompetenceEntity competenceEntity = (CompetenceEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)comp, CompetenceEntity.class, HashSet.class, ArrayList.class, new String[]{"parent"}));
        competenceEntity.setProjectName(ApplicationContextUtils.getProjectName());
        this.competenceRepository.save((Object)competenceEntity);
        comp.setId(competenceEntity.getId());
        return comp;
    }

    @Transactional
    public List<CompetenceVo> createAll(List<CompetenceVo> comps) {
        Validate.isTrue((comps != null && !comps.isEmpty() ? 1 : 0) != 0, (String)"\u6279\u91cf\u6dfb\u52a0\u529f\u80fd\u65f6\uff0c\u5fc5\u987b\u8fdb\u884c\u6279\u91cf\u4f20\u53c2", (Object[])new Object[0]);
        for (CompetenceVo competenceVo : comps) {
            this.create(competenceVo);
        }
        return comps;
    }

    @Transactional
    public CompetenceVo update(CompetenceVo comp) {
        Validate.notNull((Object)comp, (String)"\u5fc5\u987b\u4f20\u5165\u9700\u8981\u4fee\u6539\u7684\u529f\u80fd\u4fe1\u606f!!", (Object[])new Object[0]);
        String compId = comp.getId();
        Validate.notBlank((CharSequence)compId, (String)"\u9519\u8bef\u7684\u529f\u80fd\u4fe1\u606f\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.validCompetence(comp);
        Optional op = this.competenceRepository.findById(compId);
        Validate.isTrue((boolean)op.isPresent(), (String)"id\u4e3a%s\u7684\u529f\u80fd\u5bf9\u8c61\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\uff01", (Object[])new Object[]{compId});
        CompetenceEntity currentComp = (CompetenceEntity)((Object)op.get());
        currentComp.setResource(comp.getResource());
        currentComp.setMethods(comp.getMethods());
        currentComp.setComment(comp.getComment());
        currentComp.setDescription(comp.getDescription());
        currentComp.setType(comp.getType());
        if (comp.getSortIndex() == null) {
            currentComp.setSortIndex(100);
        } else {
            currentComp.setSortIndex(comp.getSortIndex());
        }
        currentComp.setIcon(comp.getIcon());
        currentComp.setModifyDate(new Date());
        currentComp.setMethods(currentComp.getMethods().toUpperCase());
        CompetenceVo parent = comp.getParent();
        CompetenceEntity oldParent = currentComp.getParent();
        if (!(parent == null || oldParent != null && oldParent.getId().equals(parent.getId()))) {
            CompetenceEntity entity = this.competenceRepository.findById(parent.getId()).orElse(null);
            Validate.notNull((Object)((Object)entity), (String)"\u672a\u627e\u5230\u4e0a\u7ea7\u83dc\u5355", (Object[])new Object[0]);
            Validate.isTrue((!parent.getId().equals(currentComp.getId()) ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u5c06\u81ea\u8eab\u8bbe\u7f6e\u4e3a\u4e0a\u7ea7\u83dc\u5355", (Object[])new Object[0]);
            HashSet<String> compStack = new HashSet<String>();
            compStack.add(currentComp.getId());
            this.validCompetenceCircular(entity, compStack);
            currentComp.setParent(entity);
        } else if (parent == null) {
            currentComp.setParent(null);
        }
        this.competenceRepository.saveAndFlush((Object)currentComp);
        return comp;
    }

    private void validCompetenceCircular(CompetenceEntity competence, Set<String> compStack) {
        Validate.notNull((Object)((Object)competence), (String)"\u5fc5\u987b\u4f20\u5165\u83dc\u5355\u4fe1\u606f", (Object[])new Object[0]);
        CompetenceEntity parent = competence.getParent();
        if (parent == null) {
            return;
        }
        Validate.isTrue((!compStack.contains(parent.getId()) ? 1 : 0) != 0, (String)"\u5f62\u6210\u5faa\u73af\u4f9d\u8d56\uff0c\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        compStack.add(parent.getId());
        this.validCompetenceCircular(parent, compStack);
    }

    private void validCompetence(CompetenceVo comp) {
        Validate.notNull((Object)comp, (String)"\u529f\u80fd\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String resource = comp.getResource();
        Validate.notNull((Object)resource, (String)"\u529f\u80fdURL\u4e32\u4e0d\u80fd\u4e3a\u7a7a! \u5982\u679c\u6ca1\u6709\u529f\u80fd\u7684url\uff0c\u8bf7\u4f20\u9012\u7a7a\u5b57\u7b26\u4e32!", (Object[])new Object[0]);
        String method = comp.getMethods();
        Validate.notBlank((CharSequence)method, (String)"\u65b9\u6cd5\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String comment = comp.getComment();
        Validate.notBlank((CharSequence)comment, (String)"\u529f\u80fd\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)comp.getViewItem(), (String)"\u529f\u80fd\u9879\u662f\u5426\u663e\u793a\u5728\u83dc\u5355\u6811\u4e2d\u5fc5\u4f20", (Object[])new Object[0]);
        if (comp.getParent() != null) {
            Validate.notBlank((CharSequence)comp.getParent().getId(), (String)"\u8bbe\u7f6e\u4e0a\u7ea7\u83dc\u5355\u5fc5\u987b\u4f20\u5165\u4e0a\u7ea7\u83dc\u5355id", (Object[])new Object[0]);
        }
    }

    @Transactional
    public CompetenceVo updateStatus(String id, Boolean flag) {
        if (StringUtils.isEmpty((CharSequence)id) || flag == null) {
            throw new IllegalArgumentException("updateStatus\u64cd\u4f5c\u65f6\u53c2\u6570\u9519\u8bef\uff01");
        }
        CompetenceEntity competence = this.recursiveUpdateStatus(id, flag);
        return (CompetenceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)competence, CompetenceVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private CompetenceEntity recursiveUpdateStatus(String parentCompetenceId, Boolean flag) {
        Optional op = this.competenceRepository.findById(parentCompetenceId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        CompetenceEntity competenceEntity = (CompetenceEntity)((Object)op.get());
        if (Boolean.TRUE.equals(flag)) {
            competenceEntity.setTstatus(1);
        } else {
            competenceEntity.setTstatus(0);
        }
        competenceEntity.setModifyDate(new Date());
        this.competenceRepository.save((Object)competenceEntity);
        List<CompetenceEntity> childList = this.competenceRepository.findByParentId(parentCompetenceId);
        for (int index = 0; childList != null && index < childList.size(); ++index) {
            this.recursiveUpdateStatus(childList.get(index).getId(), flag);
        }
        return competenceEntity;
    }

    @Transactional
    public void bindCompetence(String roleId, String[] competenceIds) {
        Validate.notBlank((CharSequence)roleId, (String)"\u8fdb\u884c\u529f\u80fd\u548c\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u89d2\u8272\u7f16\u53f7!!", (Object[])new Object[0]);
        Optional op = this.roleRepository.findById(roleId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((competenceIds != null && competenceIds.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u529f\u80fd\u548c\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u529f\u80fd\u7f16\u53f7!!", (Object[])new Object[0]);
        for (String competenceId : competenceIds) {
            Optional opCompetence = this.competenceRepository.findById(competenceId);
            Validate.isTrue((boolean)opCompetence.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u529f\u80fd\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{competenceId});
            Validate.isTrue((boolean)CompetenceTypeEnum.COMPETENCE_VIEW_ITEM_ONE.getType().equals(((CompetenceEntity)((Object)opCompetence.get())).getViewItem()), (String)"\u53ea\u80fd\u7ed1\u5b9a\u83dc\u5355", (Object[])new Object[0]);
            int count = this.competenceRepository.countByRoleIdAndCompetenceId(roleId, competenceId);
            if (count != 0) continue;
            this.competenceRepository.bindCompetence(roleId, competenceId);
        }
    }

    @Transactional
    public void unbindCompetence(String roleId, String[] competenceIds) {
        Validate.notBlank((CharSequence)roleId, (String)"\u8fdb\u884c\u529f\u80fd\u548c\u89d2\u8272\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u89d2\u8272\u7f16\u53f7!!", (Object[])new Object[0]);
        Optional op = this.roleRepository.findById(roleId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((competenceIds != null && competenceIds.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u529f\u80fd\u548c\u89d2\u8272\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u529f\u80fd\u7f16\u53f7!!", (Object[])new Object[0]);
        for (String competenceId : competenceIds) {
            Optional optional = this.competenceRepository.findById(competenceId);
            Validate.isTrue((boolean)optional.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u529f\u80fd\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{competenceId});
            this.competenceRepository.unbindCompetence(roleId, competenceId);
        }
    }

    @Transactional
    public void unbindAllByRoleId(String roleId) {
        Validate.notBlank((CharSequence)roleId, (String)"\u89d2\u8272\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<CompetenceVo> competenceVos = this.findByRoleId(roleId);
        if (CollectionUtils.isEmpty(competenceVos)) {
            return;
        }
        String[] competenceIds = this.getCompetenceIds(competenceVos);
        this.unbindCompetence(roleId, competenceIds);
    }

    @Transactional
    public void deleteById(String competenceId) {
        Validate.notBlank((CharSequence)competenceId, (String)"\u5220\u9664\u529f\u80fd\u65f6\uff0c\u6307\u5b9a\u7684\u529f\u80fd\u7f16\u53f7\u5fc5\u987b\u4f20\u9012!!", (Object[])new Object[0]);
        Optional op = this.competenceRepository.findById(competenceId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u529f\u80fd\u7f16\u53f7\u7684\u529f\u80fd\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570!!", (Object[])new Object[0]);
        CompetenceEntity currentCompetence = (CompetenceEntity)((Object)op.get());
        Set<RoleEntity> roles = currentCompetence.getRoles();
        Validate.isTrue((roles == null || roles.isEmpty() ? 1 : 0) != 0, (String)"\u6307\u5b9a\u7684\u529f\u80fd\u5df2\u7ecf\u7ed1\u5b9a\u89d2\u8272\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664!!", (Object[])new Object[0]);
        Set<ButtonEntity> buttons = currentCompetence.getButtons();
        for (ButtonEntity button : buttons) {
            this.buttonService.deleteById(button.getId());
        }
        List<CompetenceEntity> childs = this.competenceRepository.findByParentId(competenceId);
        Validate.isTrue((childs == null || childs.isEmpty() ? 1 : 0) != 0, (String)"\u6307\u5b9a\u7684\u529f\u80fd\u5b58\u5728\u5b50\u7ea7\u529f\u80fd\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664!!", (Object[])new Object[0]);
        this.competenceRepository.delete((Object)currentCompetence);
    }

    public JSONArray findByViewItem(Boolean viewItem) {
        if (viewItem == null) {
            return null;
        }
        List<CompetenceEntity> dbResults = Boolean.TRUE.equals(viewItem) ? this.competenceRepository.findByViewItem(1) : this.competenceRepository.findByViewItem(0);
        if (dbResults == null || dbResults.isEmpty()) {
            return null;
        }
        if (Boolean.TRUE.equals(viewItem) && !CollectionUtils.isEmpty(dbResults)) {
            dbResults = dbResults.stream().filter(r -> StringUtils.equals((CharSequence)r.getProjectName(), (CharSequence)ApplicationContextUtils.getProjectName())).collect(Collectors.toList());
        }
        return this.buildParent(dbResults);
    }

    public JSONArray findByViewItemAndStatus(Boolean viewItem, Integer tstatus) {
        if (viewItem == null || tstatus == null) {
            return null;
        }
        List<CompetenceEntity> dbResults = null;
        dbResults = Boolean.TRUE.equals(viewItem) ? this.competenceRepository.findByViewItemAndStatus(1, tstatus) : this.competenceRepository.findByViewItemAndStatus(0, tstatus);
        if (dbResults == null || dbResults.isEmpty()) {
            return null;
        }
        if (Boolean.TRUE.equals(viewItem) && !CollectionUtils.isEmpty(dbResults)) {
            dbResults = dbResults.stream().filter(r -> StringUtils.equals((CharSequence)r.getProjectName(), (CharSequence)ApplicationContextUtils.getProjectName())).collect(Collectors.toList());
        }
        return this.buildParent(dbResults);
    }

    private JSONArray buildParent(List<CompetenceEntity> dbResults) {
        JSONArray jsonResults = new JSONArray();
        for (CompetenceEntity competenceItem : dbResults) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("comment", (Object)competenceItem.getComment());
            jsonObject.put("description", (Object)competenceItem.getDescription());
            jsonObject.put(MESS_RESOURCE, (Object)competenceItem.getResource());
            jsonObject.put("createDate", (Object)competenceItem.getCreateDate());
            jsonObject.put("id", (Object)competenceItem.getId());
            jsonObject.put("methods", (Object)competenceItem.getMethods());
            jsonObject.put("modifyDate", (Object)competenceItem.getModifyDate());
            jsonObject.put("sortIndex", (Object)competenceItem.getSortIndex());
            jsonObject.put("tstatus", (Object)competenceItem.getTstatus());
            jsonObject.put("viewItem", (Object)competenceItem.getViewItem());
            jsonObject.put("extractUri", (Object)competenceItem.getExtractUri());
            jsonObject.put("icon", (Object)competenceItem.getIcon());
            jsonObject.put("tag", (Object)competenceItem.getTag());
            jsonObject.put("type", (Object)competenceItem.getType());
            jsonObject.put("code", (Object)competenceItem.getCode());
            CompetenceEntity parent = competenceItem.getParent();
            if (parent != null) {
                JSONObject parentObject = new JSONObject();
                parentObject.put("id", (Object)parent.getId());
                jsonObject.put("parent", (Object)parentObject);
            } else {
                jsonObject.put("parent", null);
            }
            jsonResults.add((Object)jsonObject);
        }
        return jsonResults;
    }

    public JSONArray findByViewItemAndRoleNamesAndStatus(Boolean viewItem, String[] roleNames, Integer status) {
        Validate.isTrue((roleNames != null && roleNames.length > 0 ? 1 : 0) != 0, (String)"\u8981\u8fdb\u884c\u5224\u5b9a\u7684\u89d2\u8272\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Sets.SetView intersections = Sets.intersection((Set)Sets.newHashSet((Object[])this.ignoreMethodCheckRoles), (Set)Sets.newHashSet((Object[])roleNames));
        List<CompetenceEntity> competences = null;
        if (!CollectionUtils.isEmpty((Collection)intersections)) {
            competences = status != null ? this.competenceRepository.findByViewItemAndStatus(Boolean.TRUE.equals(viewItem) ? 1 : 0, status) : this.competenceRepository.findByViewItem(Boolean.TRUE.equals(viewItem) ? 1 : 0);
            if (!CollectionUtils.isEmpty(competences)) {
                competences = competences.stream().filter(c -> StringUtils.equals((CharSequence)ApplicationContextUtils.getProjectName(), (CharSequence)c.getProjectName())).collect(Collectors.toList());
            }
            return this.buildParent(competences);
        }
        competences = status != null ? this.competenceRepository.findByViewItemAndRoleNamesAndStatusAndProjectName(Boolean.TRUE.equals(viewItem) ? 1 : 0, roleNames, status, ApplicationContextUtils.getProjectName()) : this.competenceRepository.findByViewItemAndRoleNames(Boolean.TRUE.equals(viewItem) ? 1 : 0, roleNames);
        if (CollectionUtils.isEmpty(competences)) {
            return new JSONArray();
        }
        competences = competences.stream().filter(c -> StringUtils.equals((CharSequence)ApplicationContextUtils.getProjectName(), (CharSequence)c.getProjectName())).collect(Collectors.toList());
        return this.buildParent(competences);
    }

    public List<CompetenceVo> findByResource(String resource, Integer tstatus) {
        if (StringUtils.isBlank((CharSequence)resource)) {
            return Lists.newArrayList();
        }
        List<CompetenceEntity> currentCompetences = null;
        currentCompetences = tstatus != null ? this.competenceRepository.findByResourceAndTstatus(resource, tstatus) : this.competenceRepository.findByResource(resource);
        Collection competenceVos = this.nebulaToolkitService.copyCollectionByWhiteList(currentCompetences, CompetenceEntity.class, CompetenceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newLinkedList((Iterable)competenceVos);
    }

    public JSONArray findByUrlResource(String[] resources, Principal userPrincipal) {
        UserVo currentUser = this.userService.findByAccount(userPrincipal.getName());
        JSONArray allCompetences = new JSONArray();
        Validate.isTrue((resources != null && resources.length > 0 ? 1 : 0) != 0, (String)"\u81f3\u5c11\u9700\u8981\u6307\u5b9a\u4e00\u4e2aresources\u53c2\u6570\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull((Object)currentUser, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        List roles = this.roleService.findAllByUserId(currentUser.getId(), Integer.valueOf(0));
        Validate.isTrue((roles != null && !roles.isEmpty() ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u4efb\u4f55\u89d2\u8272\u5c5e\u6027\u4fe1\u5fc3\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set<String> roleNames = roles.stream().map(RoleVo::getRoleName).collect(Collectors.toSet());
        HashSet ignoreRoles = Sets.newHashSet((Object[])this.ignoreMethodCheckRoles);
        JSONArray results = new JSONArray();
        if (ignoreRoles != null && !Sets.intersection(roleNames, (Set)ignoreRoles).isEmpty()) {
            for (String resource : resources) {
                JSONObject node = new JSONObject();
                node.put(MESS_RESOURCE, (Object)resource);
                node.put("flag", (Object)true);
                results.add((Object)node);
            }
            return results;
        }
        JSONArray noViewItemCompetences = this.findByViewItemAndRoleNamesAndStatus(false, roleNames.toArray(new String[0]), null);
        JSONArray viewItemCompetences = this.findByViewItemAndRoleNamesAndStatus(true, roleNames.toArray(new String[0]), null);
        if (noViewItemCompetences != null) {
            allCompetences.addAll((Collection)noViewItemCompetences);
        }
        if (viewItemCompetences != null) {
            allCompetences.addAll((Collection)viewItemCompetences);
        }
        if (CollectionUtils.isEmpty((Collection)allCompetences)) {
            for (String resource : resources) {
                JSONObject node = new JSONObject();
                node.put(MESS_RESOURCE, (Object)resource);
                node.put("flag", (Object)false);
                results.add((Object)node);
            }
            return results;
        }
        PathMatcher pathMatcher = this.requestMappingHandlerMapping.getPathMatcher();
        LinkedHashMap<String, Boolean> resourceMapping = new LinkedHashMap<String, Boolean>();
        for (String resource : resources) {
            boolean matcher = false;
            for (int index = 0; index < allCompetences.size(); ++index) {
                JSONObject competenceItem = allCompetences.getJSONObject(index);
                Integer extractUri = competenceItem.getInteger("extractUri");
                Integer tstatus = competenceItem.getInteger("tstatus");
                String currentResource = competenceItem.getString(MESS_RESOURCE);
                if (tstatus != 1) continue;
                if (extractUri == 1) {
                    try {
                        Map pathMatcherMapping = pathMatcher.extractUriTemplateVariables(currentResource, resource);
                        if (pathMatcherMapping == null) continue;
                        matcher = true;
                        break;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                if (extractUri != 0 || !StringUtils.equals((CharSequence)currentResource, (CharSequence)resource)) continue;
                matcher = true;
                break;
            }
            resourceMapping.put(resource, matcher);
        }
        Set keys = resourceMapping.keySet();
        for (String resource : keys) {
            JSONObject node = new JSONObject();
            node.put(MESS_RESOURCE, (Object)resource);
            node.put("flag", resourceMapping.get(resource));
            results.add((Object)node);
        }
        return results;
    }

    public Page<CompetenceVo> findByConditions(CompetenceVo competence, Pageable pageable) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        Page competenceEntityPage = this.competenceRepository.findByConditions(pageable, competence);
        List competenceEntitys = competenceEntityPage.getContent();
        PageImpl competenceVoPage = null;
        if (!CollectionUtils.isEmpty((Collection)competenceEntitys)) {
            Collection competenceVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)competenceEntitys, CompetenceEntity.class, CompetenceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            competenceVoPage = new PageImpl(new ArrayList(competenceVos), pageable, competenceEntityPage.getTotalElements());
        } else {
            competenceVoPage = new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        return competenceVoPage;
    }

    public CompetenceVo findById(String competenceId) {
        if (StringUtils.isBlank((CharSequence)competenceId)) {
            return null;
        }
        Optional op = this.competenceRepository.findById(competenceId);
        if (!op.isPresent()) {
            return null;
        }
        return (CompetenceVo)this.nebulaToolkitService.copyObjectByWhiteList(op.get(), CompetenceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<CompetenceVo> findAll() {
        List competences = this.competenceRepository.findAll();
        if (competences == null || competences.isEmpty()) {
            return Lists.newArrayList();
        }
        Collection competenceVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)competences, CompetenceEntity.class, CompetenceVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"parent"});
        return Lists.newArrayList((Iterable)competenceVos);
    }

    public Set<CompetenceVo> findByButtonId(String buttonId) {
        if (StringUtils.isBlank((CharSequence)buttonId)) {
            return Sets.newHashSet();
        }
        Set<CompetenceEntity> competences = this.competenceRepository.findByButtonId(buttonId);
        Collection competenceVos = this.nebulaToolkitService.copyCollectionByWhiteList(competences, CompetenceEntity.class, CompetenceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Sets.newHashSet((Iterable)competenceVos);
    }

    public Set<CompetenceVo> findByUserId(String userId) {
        if (StringUtils.isBlank((CharSequence)userId)) {
            return Sets.newHashSet();
        }
        HashSet<CompetenceVo> competenceVos = new HashSet<CompetenceVo>();
        Set buttonVos = this.buttonService.findByUserId(userId);
        for (ButtonVo button : buttonVos) {
            Set<CompetenceVo> competences = this.findByButtonId(button.getId());
            if (CollectionUtils.isEmpty(competences)) continue;
            competenceVos.addAll(competences);
        }
        return competenceVos;
    }

    public CompetenceVo findByCommentAndViewItemAndParent(String comment, int viewItem, String parentId) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{comment, parentId})) {
            return null;
        }
        CompetenceEntity competence = this.competenceRepository.findByCommentAndViewItemAndParent(comment, viewItem, parentId);
        if (competence != null && viewItem == 1) {
            competence = StringUtils.equals((CharSequence)competence.getProjectName(), (CharSequence)ApplicationContextUtils.getProjectName()) ? competence : null;
        }
        return competence == null ? null : (CompetenceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)competence, CompetenceVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public CompetenceVo findByCommentAndViewItemAndNullParent(String comment, int viewItem) {
        if (StringUtils.isBlank((CharSequence)comment)) {
            return null;
        }
        CompetenceEntity competence = this.competenceRepository.findByCommentAndViewItemAndNullParent(comment, viewItem);
        if (competence != null && viewItem == 1) {
            competence = StringUtils.equals((CharSequence)competence.getProjectName(), (CharSequence)ApplicationContextUtils.getProjectName()) ? competence : null;
        }
        return competence == null ? null : (CompetenceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)competence, CompetenceVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public CompetenceVo findByResourceAndMethods(String resource, String methods) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{resource, methods})) {
            return null;
        }
        CompetenceEntity competence = this.competenceRepository.findByResourceAndMethodsAndProjectName(resource, methods, ApplicationContextUtils.getProjectName());
        return competence == null ? null : (CompetenceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)competence, CompetenceVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public long count() {
        return this.competenceRepository.count();
    }

    public List<CompetenceVo> findAllByConditions(CompetenceVo competence) {
        List competences = this.competenceRepository.findAllByConditions(competence);
        if (CollectionUtils.isEmpty((Collection)competences)) {
            return Lists.newArrayList();
        }
        Collection competenceVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)competences, CompetenceEntity.class, CompetenceVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"parent"});
        return Lists.newArrayList((Iterable)competenceVos);
    }

    public long countByViewItem(int viewItem) {
        return this.competenceRepository.countByViewItemAndProjectName(viewItem, ApplicationContextUtils.getProjectName());
    }

    public List<CompetenceVo> findByRoleId(String roleId) {
        if (StringUtils.isBlank((CharSequence)roleId)) {
            return Lists.newArrayList();
        }
        List<CompetenceEntity> competenceEntities = this.competenceRepository.findByRoleId(roleId);
        if (CollectionUtils.isEmpty(competenceEntities)) {
            return Lists.newArrayList();
        }
        Collection competenceVos = this.nebulaToolkitService.copyCollectionByWhiteList(competenceEntities, CompetenceEntity.class, CompetenceVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"parent"});
        return Lists.newArrayList((Iterable)competenceVos);
    }

    private String[] getCompetenceIds(List<CompetenceVo> competenceVos) {
        Validate.notEmpty(competenceVos, (String)"\u7ed1\u5b9a\u7684\u83dc\u5355\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        String[] competenceIdArray = new String[competenceVos.size()];
        int i = 0;
        for (CompetenceVo competence : competenceVos) {
            String id = competence.getId();
            Validate.notBlank((CharSequence)id, (String)"\u7ed1\u5b9a\u7684\u83dc\u5355\u4e3b\u952e\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            competenceIdArray[i] = id;
            ++i;
        }
        return competenceIdArray;
    }
}

