/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.starter.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.rbac.server.service.ButtonService;
import com.bizunited.platform.rbac.server.service.CompetenceService;
import com.bizunited.platform.rbac.server.service.RoleExtendVoService;
import com.bizunited.platform.rbac.server.service.RolePositionMappingService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.starter.entity.RoleEntity;
import com.bizunited.platform.rbac.server.starter.entity.RoleExtendEntity;
import com.bizunited.platform.rbac.server.starter.repository.RoleExtendEntityRepository;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.rbac.server.vo.RoleExtendVo;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.user.common.vo.UserVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="RoleExtendVoServiceImpl")
public class RoleExtendVoServiceImpl
implements RoleExtendVoService {
    @Autowired
    private RoleExtendEntityRepository roleExtendEntityRepository;
    @Autowired
    private CompetenceService competenceService;
    @Autowired
    private ButtonService buttonService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private RolePositionMappingService rolePositionMappingService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Transactional
    public RoleExtendVo create(RoleExtendVo roleExtendVo) {
        RoleExtendVo current = this.createForm(roleExtendVo);
        return current;
    }

    @Transactional
    public RoleExtendVo createForm(RoleExtendVo roleExtendVo) {
        this.createValidation(roleExtendVo);
        RoleVo roleVo = roleExtendVo.getRoleVo();
        roleVo = this.initRoleVo(roleVo);
        Validate.notBlank((CharSequence)roleVo.getRoleCode(), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        boolean flag = false;
        if (roleVo.getTstatus() == 0) {
            flag = true;
            roleVo.setTstatus(Integer.valueOf(1));
        }
        RoleVo currentRoleVo = this.roleService.create(roleVo);
        if (flag) {
            this.roleService.disable(new String[]{roleVo.getId()});
        }
        RoleEntity roleEntity = (RoleEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)currentRoleVo, RoleEntity.class, HashSet.class, ArrayList.class, new String[0]));
        RoleExtendEntity entity = this.initRoleExtendEntity(roleExtendVo);
        entity.setRoleEntity(roleEntity);
        this.roleExtendEntityRepository.saveAndFlush((Object)entity);
        return this.extendCopy(entity);
    }

    private void createValidation(RoleExtendVo roleExtendVo) {
        Validate.notNull((Object)roleExtendVo, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        RoleVo roleVo = roleExtendVo.getRoleVo();
        Validate.notNull((Object)roleVo, (String)"\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)roleExtendVo.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        roleExtendVo.setId(null);
        String roleName = roleVo.getRoleName();
        Validate.notBlank((CharSequence)roleName, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        RoleExtendEntity entityByName = this.roleExtendEntityRepository.findByRoleName(roleName);
        Validate.isTrue((entityByName == null || entityByName.getDeleteFlag() == 1 ? 1 : 0) != 0, (String)"\u540d\u79f0\u4e3a[%s]\u7684\u89d2\u8272\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5", (Object[])new Object[]{roleName});
    }

    private RoleExtendEntity initRoleExtendEntity(RoleExtendVo roleExtendVo) {
        RoleExtendEntity entity = (RoleExtendEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)roleExtendVo, RoleExtendEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setDeleteFlag(0);
        UserVo currentUser = SecurityUtils.getCurrentUser();
        Validate.notNull((Object)currentUser, (String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5", (Object[])new Object[0]);
        String account = currentUser.getAccount();
        entity.setCreateUser(account);
        return entity;
    }

    @Transactional
    public RoleExtendVo update(RoleExtendVo roleExtendVo) {
        RoleExtendVo current = this.updateForm(roleExtendVo);
        return current;
    }

    @Transactional
    public RoleExtendVo updateForm(RoleExtendVo roleExtendVo) {
        this.updateValidation(roleExtendVo);
        String currentId = roleExtendVo.getId();
        Optional op_currentRoleExtendEntity = this.roleExtendEntityRepository.findById(currentId);
        RoleExtendEntity currentRoleExtendEntity = op_currentRoleExtendEntity.orElse(null);
        Validate.notNull((Object)((Object)currentRoleExtendEntity), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1\u606f", (Object[])new Object[0]);
        RoleVo roleVo = roleExtendVo.getRoleVo();
        RoleVo roleVoParent = roleVo.getParent();
        if (roleVoParent != null && StringUtils.isBlank((CharSequence)roleVoParent.getId())) {
            roleVo.setParent(null);
        }
        RoleVo currentRoleVo = this.roleService.update(roleVo);
        RoleEntity roleEntity = (RoleEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)currentRoleVo, RoleEntity.class, HashSet.class, ArrayList.class, new String[0]));
        currentRoleExtendEntity.setRoleEntity(roleEntity);
        this.roleExtendEntityRepository.saveAndFlush((Object)currentRoleExtendEntity);
        return this.extendCopy(currentRoleExtendEntity);
    }

    private void updateValidation(RoleExtendVo roleExtendVo) {
        RoleVo roleVo = roleExtendVo.getRoleVo();
        Validate.notNull((Object)roleVo, (String)"\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String id = roleExtendVo.getId();
        Validate.isTrue((!StringUtils.isBlank((CharSequence)id) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        String roleName = roleVo.getRoleName();
        String roleVoId = roleVo.getId();
        Validate.notBlank((CharSequence)roleName, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8868\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)roleVoId, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        RoleExtendEntity entityByName = this.roleExtendEntityRepository.findByRoleName(roleName);
        if (entityByName != null && entityByName.getDeleteFlag() == 0) {
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)entityByName.getId(), (CharSequence)id), (String)"\u540d\u79f0\u4e3a[%s]\u7684\u89d2\u8272\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5", (Object[])new Object[]{roleName});
        }
    }

    private RoleVo initRoleVo(RoleVo roleVo) {
        RoleVo roleVoParent = roleVo.getParent();
        if (roleVoParent != null && StringUtils.isBlank((CharSequence)roleVoParent.getId())) {
            roleVo.setParent(null);
        }
        roleVo.setIsDeny(Boolean.valueOf(false));
        return roleVo;
    }

    public RoleExtendVo findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        RoleExtendEntity current = this.roleExtendEntityRepository.findDetailsById(id);
        if (current == null) {
            return null;
        }
        RoleExtendVo roleExtendVo = (RoleExtendVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, RoleExtendVo.class, HashSet.class, ArrayList.class, new String[]{"roleVo"});
        return roleExtendVo;
    }

    public RoleExtendVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        RoleExtendEntity roleExtendEntity = this.roleExtendEntityRepository.findById(id).orElse(null);
        return this.extendCopy(roleExtendEntity);
    }

    public Page<JSONObject> queryPage(String roleName, String roleCode, Integer tstatus, Pageable pageable) {
        Page roleExtendEntities;
        List list;
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)roleName)) {
            conditions.put("roleName", roleName);
        }
        if (StringUtils.isNotBlank((CharSequence)roleCode)) {
            conditions.put("roleCode", roleCode);
        }
        if (tstatus != null) {
            conditions.put("tstatus", tstatus);
        }
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        if ((list = (roleExtendEntities = this.roleExtendEntityRepository.queryPage(conditions, pageable)).getContent()).isEmpty()) {
            return new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        List<JSONObject> jsonObjectList = this.extendEntityToJson(list);
        return new PageImpl(jsonObjectList, pageable, roleExtendEntities.getTotalElements());
    }

    @Transactional
    public void deleteByRoleCode(String roleCode) {
        Validate.notBlank((CharSequence)roleCode, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RoleExtendEntity roleExtendEntity = this.roleExtendEntityRepository.findByRoleCode(roleCode);
        Validate.notNull((Object)((Object)roleExtendEntity), (String)"\u672a\u627e\u5230\u7f16\u7801\u3010%s\u3011\u7684\u89d2\u8272\u62d3\u5c55\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{roleCode});
        RoleEntity roleEntity = roleExtendEntity.getRoleEntity();
        Validate.notNull((Object)((Object)roleEntity), (String)"\u672a\u627e\u5230\u7f16\u7801\u3010%s\u3011\u7684\u89d2\u8272\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{roleCode});
        String id = roleEntity.getId();
        this.buttonService.unbindAllByRoleId(id);
        this.competenceService.unbindAllByRoleId(id);
        this.rolePositionMappingService.unbindAllByRoleId(id);
        roleExtendEntity.setDeleteFlag(1);
        this.roleExtendEntityRepository.save((Object)roleExtendEntity);
    }

    @Transactional
    public void deleteByCodes(String[] roleCodes) {
        Validate.notEmpty((Object[])roleCodes, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (int i = 0; i < roleCodes.length; ++i) {
            this.deleteByRoleCode(roleCodes[i]);
        }
    }

    private RoleExtendVo extendCopy(RoleExtendEntity roleExtendEntity) {
        Validate.notNull((Object)((Object)roleExtendEntity), (String)"\u89d2\u8272\u62d3\u5c55\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RoleEntity roleEntity = roleExtendEntity.getRoleEntity();
        Validate.notNull((Object)((Object)roleEntity), (String)"\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RoleExtendVo roleExtendVo = (RoleExtendVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)roleExtendEntity, RoleExtendVo.class, HashSet.class, ArrayList.class, new String[]{"roleVo"});
        RoleVo roleVo = (RoleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)roleEntity, RoleVo.class, HashSet.class, ArrayList.class, new String[]{"parent"});
        roleExtendVo.setRoleVo(roleVo);
        return roleExtendVo;
    }

    private List<JSONObject> extendEntityToJson(List<RoleExtendEntity> list) {
        LinkedList jsonList = Lists.newLinkedList();
        if (CollectionUtils.isEmpty(list)) {
            return jsonList;
        }
        list.forEach(roleExtendEntity -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)roleExtendEntity.getId());
            jsonObject.put("createTime", (Object)roleExtendEntity.getCreateTime());
            jsonObject.put("createUser", (Object)roleExtendEntity.getCreateUser());
            RoleEntity roleEntity = roleExtendEntity.getRoleEntity();
            if (roleEntity == null) {
                roleEntity = new RoleEntity();
            }
            jsonObject.put("roleId", (Object)roleEntity.getId());
            jsonObject.put("comment", (Object)roleEntity.getComment());
            jsonObject.put("roleCode", (Object)roleEntity.getRoleCode());
            jsonObject.put("roleName", (Object)roleEntity.getRoleName());
            jsonObject.put("roleType", (Object)roleEntity.getRoleType());
            jsonObject.put("tstatus", (Object)roleEntity.getTstatus());
            jsonList.add(jsonObject);
        });
        return jsonList;
    }
}

