/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.rbac.server.service.RolePositionMappingService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/rolePositionMapping"})
public class RolePositionMappingController
extends BaseController {
    @Autowired
    private RolePositionMappingService rolePositionMappingService;
    @Value(value="${rbac.ignoreMethodCheckRoles:ADMIN}")
    private String[] ignoreMethodCheckRoles;
    private static final Logger LOGGER = LoggerFactory.getLogger(RolePositionMappingController.class);

    @ApiOperation(value="\u5c06\u6307\u5b9a\u89d2\u8272\u7ed1\u5b9a\u4e00\u4e2a\u6216\u591a\u4e2a\u5c97\u4f4d")
    @PatchMapping(value={"bindPositions"})
    public ResponseModel bindPositions(@RequestParam @ApiParam(value="\u89d2\u8272id") String roleId, @RequestParam @ApiParam(value="\u5f53\u524d\u8981\u7ed1\u5b9a\u7684\u4e00\u4e2a\u6216\u591a\u4e2a\u5c97\u4f4d\u7f16\u7801") String[] positionCodes) {
        try {
            this.rolePositionMappingService.bindPositions(roleId, positionCodes);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u89e3\u9664\u6307\u5b9a\u89d2\u8272\u548c\u4e00\u4e2a\u6216\u591a\u4e2a\u5c97\u4f4d\u7684\u7ed1\u5b9a\u5173\u7cfb")
    @PatchMapping(value={"unbindPositions"})
    public ResponseModel unbindPositions(@RequestParam @ApiParam(value="\u89d2\u8272id") String roleId, @RequestParam @ApiParam(value="\u5f53\u524d\u8981\u89e3\u7ed1\u7684\u4e00\u4e2a\u6216\u591a\u4e2a\u5c97\u4f4d\u7f16\u7801") String[] positionCodes) {
        try {
            this.rolePositionMappingService.unbindPositions(roleId, positionCodes);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5c06\u6307\u5b9a\u89d2\u8272\u91cd\u65b0\u7ed1\u5b9a\u4e00\u4e2a\u6216\u591a\u4e2a\u5c97\u4f4d")
    @PatchMapping(value={"rebindPositions"})
    public ResponseModel rebindPositions(@RequestParam @ApiParam(value="\u89d2\u8272id") String roleId, @RequestParam(required=false) @ApiParam(value="\u5f53\u524d\u8981\u7ed1\u5b9a\u7684\u4e00\u4e2a\u6216\u591a\u4e2a\u5c97\u4f4d\u7f16\u7801") String[] positionCodes) {
        try {
            this.rolePositionMappingService.rebindPositions(roleId, positionCodes);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5c06\u6307\u5b9a\u5c97\u4f4d\u7ed1\u5b9a\u4e00\u4e2a\u6216\u591a\u4e2a\u89d2\u8272")
    @PatchMapping(value={"bindPositionRoles"})
    public ResponseModel bindPositionRoles(@RequestParam @ApiParam(value="\u5c97\u4f4d\u7f16\u7801") String positionCode, @RequestParam @ApiParam(value="\u5f53\u524d\u8981\u7ed1\u5b9a\u7684\u4e00\u4e2a\u6216\u591a\u4e2a\u89d2\u8272id") String[] roleIds) {
        try {
            this.rolePositionMappingService.bindPositionRoles(positionCode, roleIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5c06\u6307\u5b9a\u5c97\u4f4d\u89e3\u9664\u4e00\u4e2a\u6216\u591a\u4e2a\u89d2\u8272\u7684\u7ed1\u5b9a")
    @PatchMapping(value={"unbindPositionRoles"})
    public ResponseModel unbindPositionRoles(@RequestParam @ApiParam(value="\u5c97\u4f4d\u7f16\u7801") String positionCode, @RequestParam @ApiParam(value="\u5f53\u524d\u8981\u89e3\u7ed1\u5b9a\u7684\u4e00\u4e2a\u6216\u591a\u4e2a\u89d2\u8272id") String[] roleIds) {
        try {
            this.rolePositionMappingService.unbindPositionRoles(positionCode, roleIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5c06\u6307\u5b9a\u5c97\u4f4d\u91cd\u65b0\u7ed1\u5b9a\u4e00\u4e2a\u6216\u591a\u4e2a\u89d2\u8272")
    @PatchMapping(value={"rebindPositionRoles"})
    public ResponseModel rebindPositionRoles(@RequestParam @ApiParam(value="\u5c97\u4f4d\u7f16\u7801") String positionCode, @RequestParam(required=false) @ApiParam(value="\u5f53\u524d\u8981\u7ed1\u5b9a\u7684\u4e00\u4e2a\u6216\u591a\u4e2a\u89d2\u8272id") String[] roleIds) {
        try {
            this.rolePositionMappingService.rebindPositionRoles(positionCode, roleIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5c06\u6307\u5b9a\u5c97\u4f4d\u91cd\u65b0\u7ed1\u5b9a\u4e00\u4e2a\u6216\u591a\u4e2a\u89d2\u8272")
    @PatchMapping(value={"rebindPositionsById"})
    public ResponseModel rebindPositionsById(@RequestParam(value="roleId") @ApiParam(value="\u88ab\u66ff\u6362\u7684\u89d2\u8272\u4e3b\u952e") String roleId, @RequestParam(value="rebinRoleId") @ApiParam(value="\u66ff\u6362\u7684\u89d2\u8272\u4e3b\u952e") String rebinRoleId, @RequestParam(value="positionCodes") @ApiParam(value="\u9700\u8981\u66ff\u6362\u7684\u5c97\u4f4d\u7f16\u7801") String[] positionCodes) {
        try {
            this.rolePositionMappingService.rebindPositionsById(roleId, rebinRoleId, positionCodes);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272ID\u67e5\u8be2\u76f4\u63a5\u5173\u8054\u7684\u5c97\u4f4d")
    @GetMapping(value={"findPositionsByRoleId"})
    public ResponseModel findByRoleId(@ApiParam(value="\u6307\u5b9a\u7684\u89d2\u8272\u7f16\u53f7") @RequestParam(value="roleId") String roleId) {
        try {
            Set result = this.rolePositionMappingService.findByRoleId(roleId);
            return this.buildHttpResult(result);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272ID\u67e5\u8be2\u76f4\u63a5\u5173\u8054\u7684\u5c97\u4f4d")
    @GetMapping(value={"findPageByRoleId"})
    public ResponseModel findPageByRoleId(@ApiParam(value="\u6307\u5b9a\u7684\u89d2\u8272\u7f16\u53f7") @RequestParam(value="roleId") String roleId, @ApiParam(value="\u89d2\u8272\u540d\u79f0") @RequestParam(name="name", required=false) String name, @ApiParam(value="\u7528\u6237\u540d\u79f0") @RequestParam(name="userName", required=false) String userName, @PageableDefault(value=50) @ApiParam(name="pageable", value="\u5206\u9875\u4fe1\u606f") Pageable pageable) {
        try {
            Page result = this.rolePositionMappingService.findPageByRoleId(roleId, name, userName, pageable);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272ID\u67e5\u8be2\u6ca1\u6709\u5173\u8054\u8be5\u89d2\u8272\u7684\u5c97\u4f4d")
    @GetMapping(value={"findNotBindRole"})
    public ResponseModel findNotBindRole(@ApiParam(value="\u6307\u5b9a\u7684\u89d2\u8272\u4e3b\u952e") @RequestParam(value="roleId") String roleId, @ApiParam(value="\u89d2\u8272\u540d\u79f0") @RequestParam(name="name", required=false) String name, @ApiParam(value="\u7528\u6237\u540d\u79f0") @RequestParam(name="userName", required=false) String userName, @PageableDefault(value=50) @ApiParam(name="pageable", value="\u5206\u9875\u4fe1\u606f") Pageable pageable) {
        try {
            Page result = this.rolePositionMappingService.findNotBindRole(roleId, name, userName, pageable);
            return this.buildHttpResultW(result, new String[]{"organization", "users", "positionLevel", "parent"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6ca1\u6709\u7ed1\u5b9a\u4efb\u4f55\u89d2\u8272\u7684\u804c\u4f4d")
    @GetMapping(value={"findNotBindAnyRole"})
    public ResponseModel findNotBindAnyRole(@ApiParam(value="\u89d2\u8272\u540d\u79f0") @RequestParam(name="name", required=false) String name, @ApiParam(value="\u7528\u6237\u540d\u79f0") @RequestParam(name="userName", required=false) String userName, @PageableDefault(value=50) @ApiParam(name="pageable", value="\u5206\u9875\u4fe1\u606f") Pageable pageable) {
        try {
            Page result = this.rolePositionMappingService.findNotBindAnyRole(name, userName, pageable);
            return this.buildHttpResultW(result, new String[]{"organization", "users", "positionLevel", "parent"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

