/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.starter.service.internal;

import com.bizunited.platform.common.enums.RbacRelationEnum;
import com.bizunited.platform.rbac.server.service.RbacSettingService;
import com.bizunited.platform.rbac.server.service.RolePositionLevelMappingService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.starter.entity.RoleEntity;
import com.bizunited.platform.rbac.server.starter.entity.RolePositionLevelMappingEntity;
import com.bizunited.platform.rbac.server.starter.repository.RolePositionLevelMappingRepository;
import com.bizunited.platform.rbac.server.vo.RbacSettingVo;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.user.common.service.position.PositionLevelService;
import com.bizunited.platform.user.common.service.position.PositionService;
import com.bizunited.platform.user.common.vo.PositionLevelSimpleVo;
import com.bizunited.platform.user.common.vo.PositionLevelVo;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RolePositionLevelMappingServiceImpl
implements RolePositionLevelMappingService {
    @Autowired
    private RolePositionLevelMappingRepository rolePositionLevelMappingRepository;
    @Autowired
    private PositionLevelService positionLevelService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private RbacSettingService rbacSettingService;
    @Autowired
    private RoleService roleService;

    @Transactional
    public void bindPositionLevelRoles(String positionLevelCode, String[] roleIds) {
        Validate.notBlank((CharSequence)positionLevelCode, (String)"\u8fdb\u884c\u804c\u4f4d\u7ea7\u522b-\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u804c\u4f4d\u7ea7\u522b\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((roleIds != null && roleIds.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u804c\u4f4d\u7ea7\u522b-\u89d2\u8272\u7ed1\u5b9a\u65f6,\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u89d2\u8272id\u4fe1\u606f!!", (Object[])new Object[0]);
        RbacSettingVo rbacSetting = this.rbacSettingService.findRbacSetting();
        PositionLevelVo positionLevelVo = this.positionLevelService.findByCode(positionLevelCode);
        Validate.notNull((Object)positionLevelVo, (String)"\u672a\u627e\u5230\u804c\u4f4d\u7ea7\u522b\uff1a%s", (Object[])new Object[]{positionLevelCode});
        for (String roleId : roleIds) {
            RoleVo role = this.roleService.findById(roleId);
            Validate.notNull((Object)role, (String)"\u672a\u627e\u5230\u89d2\u8272\u4fe1\u606f\uff1a%s", (Object[])new Object[]{roleId});
            this.validateBindPosition(rbacSetting, role, positionLevelVo);
            RolePositionLevelMappingEntity mapping = new RolePositionLevelMappingEntity();
            RoleEntity currentRole = new RoleEntity();
            currentRole.setId(roleId);
            currentRole.setRoleCode(role.getRoleCode());
            mapping.setRole(currentRole);
            mapping.setPositionLevelCode(positionLevelCode);
            this.rolePositionLevelMappingRepository.save((Object)mapping);
        }
    }

    @Transactional
    public void rebindPositionLevelRoles(String positionLevelCode, String[] roleIds) {
        Validate.notBlank((CharSequence)positionLevelCode, (String)"\u4f20\u5165\u7684\u804c\u4f4d\u7ea7\u522b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        PositionLevelVo positionLevelVo = this.positionLevelService.findByCode(positionLevelCode);
        Validate.notNull((Object)positionLevelVo, (String)"\u672a\u627e\u5230\u804c\u4f4d\u7ea7\u522b\uff1a%s", (Object[])new Object[]{positionLevelCode});
        HashSet<String> currentRoleIds = new HashSet<String>();
        if (roleIds != null) {
            for (String roleId : roleIds) {
                currentRoleIds.add(roleId);
            }
        }
        this.rolePositionLevelMappingRepository.unbindPositionLevelCode(positionLevelCode);
        this.bindPositionLevelRoles(positionLevelCode, roleIds);
    }

    @Transactional
    public void unbindPositionLevelRoles(String positionLevelCode, String[] roleIds) {
        Validate.notBlank((CharSequence)positionLevelCode, (String)"\u8fdb\u884c\u804c\u4f4d\u7ea7\u522b-\u89d2\u8272\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u804c\u4f4d\u7ea7\u522b\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((roleIds != null && roleIds.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u804c\u4f4d\u7ea7\u522b-\u89d2\u8272\u89e3\u7ed1\u65f6,\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u89d2\u8272id\u4fe1\u606f!!", (Object[])new Object[0]);
        for (String roleId : roleIds) {
            RoleVo role = this.roleService.findById(roleId);
            Validate.notNull((Object)role, (String)"\u672a\u627e\u5230\u89d2\u8272\u4fe1\u606f\uff1a%s", (Object[])new Object[]{roleId});
            RolePositionLevelMappingEntity mapping = this.rolePositionLevelMappingRepository.findByRoleAndPositionLevelCode(role.getRoleCode(), positionLevelCode);
            if (mapping == null) continue;
            this.rolePositionLevelMappingRepository.delete((Object)mapping);
        }
    }

    @Transactional
    public void unbindPositionLevels(String[] positionLevelCodes) {
        Validate.notEmpty((Object[])positionLevelCodes, (String)"\u8fdb\u884c\u804c\u4f4d\u7ea7\u522b\u89e3\u7ed1\u5168\u90e8\u89d2\u8272\u65f6,\u804c\u4f4d\u7ea7\u522b\u7f16\u7801\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        for (String positionLevelCode : positionLevelCodes) {
            List<RolePositionLevelMappingEntity> list = this.rolePositionLevelMappingRepository.findByPositionLevelCode(positionLevelCode);
            for (RolePositionLevelMappingEntity rolePositionLevelMappingEntity : list) {
                this.rolePositionLevelMappingRepository.delete((Object)rolePositionLevelMappingEntity);
            }
        }
    }

    @Transactional
    public void deletePositionLevelUnbindRole(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u804c\u7ea7\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Set positionVos = this.positionService.findByPositionLevelIds(new String[]{id});
        Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)positionVos), (String)"\u5b58\u5728\u5df2\u7ed1\u5b9a\u7684\u804c\u4f4d", (Object[])new Object[0]);
        PositionLevelVo positionLevelVo = this.positionLevelService.findById(id);
        Validate.notNull((Object)positionLevelVo, (String)("\u901a\u8fc7\u4e3b\u952e\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u804c\u7ea7 : " + id), (Object[])new Object[0]);
        String positionLevelCode = positionLevelVo.getCode();
        String[] codes = new String[]{positionLevelCode};
        this.unbindPositionLevels(codes);
        String[] idArray = new String[]{id};
        this.positionLevelService.deleteByIds(idArray);
    }

    @Transactional
    public void deletePositionLevelsUnbindRole(String[] ids) {
        Validate.notEmpty((Object[])ids, (String)"\u804c\u7ea7\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Set positionVos = this.positionService.findByPositionLevelIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)positionVos), (String)"\u5df2\u5b58\u5728\u5173\u8054\u7684\u804c\u4f4d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Object[] codes = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            String id = ids[i];
            PositionLevelVo positionLevelVo = this.positionLevelService.findById(id);
            Validate.notNull((Object)positionLevelVo, (String)("\u901a\u8fc7\u4e3b\u952e\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u804c\u7ea7 : " + id), (Object[])new Object[0]);
            codes[i] = positionLevelVo.getCode();
        }
        Validate.notEmpty((Object[])codes, (String)"\u804c\u7ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.unbindPositionLevels((String[])codes);
        this.positionLevelService.deleteByIds(ids);
    }

    public Page<PositionLevelSimpleVo> findByConditions(Map<String, Object> condition, Pageable pageable) {
        if (condition == null) {
            condition = Maps.newHashMap();
        }
        return this.rolePositionLevelMappingRepository.findByConditions(condition, pageable);
    }

    public List<PositionLevelSimpleVo> findByNameAndRoleName(String name, String roleName) {
        List positionLevelVos = this.positionLevelService.findAll();
        if (CollectionUtils.isEmpty((Collection)positionLevelVos)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        positionLevelVos.forEach(p -> {
            List<PositionLevelSimpleVo> returnPositionLevelVos = this.buildResultByNameAndRoleName((PositionLevelVo)p, name, roleName);
            if (!CollectionUtils.isEmpty(returnPositionLevelVos)) {
                result.addAll(returnPositionLevelVos);
            }
        });
        return result;
    }

    public List<PositionLevelSimpleVo> findByPositionLevelCode(String positionLevelCode) {
        if (StringUtils.isBlank((CharSequence)positionLevelCode)) {
            return Lists.newArrayList();
        }
        return this.rolePositionLevelMappingRepository.findDetailsByPositionLevelCode(positionLevelCode);
    }

    private List<PositionLevelSimpleVo> buildResultByNameAndRoleName(PositionLevelVo positionLevelVo, String name, String roleName) {
        List<RolePositionLevelMappingEntity> rolePositionLevelMappingEntities = this.rolePositionLevelMappingRepository.findByPositionLevelCode(positionLevelVo.getCode());
        if (CollectionUtils.isEmpty(rolePositionLevelMappingEntities)) {
            return Lists.newArrayList();
        }
        ArrayList roleEntities = Lists.newArrayList();
        rolePositionLevelMappingEntities.forEach(mapping -> roleEntities.add(mapping.getRole()));
        Validate.notBlank((CharSequence)positionLevelVo.getName(), (String)"\u6570\u636e\u5f02\u5e38\uff0c\u804c\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (!StringUtils.isBlank((CharSequence)name) && !positionLevelVo.getName().contains(name)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        roleEntities.forEach(role -> {
            if (StringUtils.isBlank((CharSequence)roleName) || StringUtils.equals((CharSequence)roleName, (CharSequence)role.getRoleName())) {
                PositionLevelSimpleVo returnPositionLevelVo = new PositionLevelSimpleVo();
                returnPositionLevelVo.setCode(positionLevelVo.getCode());
                returnPositionLevelVo.setName(positionLevelVo.getName());
                returnPositionLevelVo.setRoleCode(role.getRoleCode());
                returnPositionLevelVo.setRoleName(role.getRoleName());
                returnPositionLevelVo.setState(positionLevelVo.getState());
                returnPositionLevelVo.setId(positionLevelVo.getId());
                result.add(returnPositionLevelVo);
            }
        });
        return result;
    }

    private void validateBindPosition(RbacSettingVo rbacSetting, RoleVo role, PositionLevelVo positionLevelVo) {
        long count = this.rolePositionLevelMappingRepository.countByRoleAndPositionLevel(role.getRoleCode(), positionLevelVo.getCode());
        Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u6307\u5b9a\u804c\u4f4d\u7ea7\u522b[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{positionLevelVo.getName()});
        if (rbacSetting.getRolePositionRelation() == RbacRelationEnum.MANY_TO_ONE.getRelation()) {
            count = this.rolePositionLevelMappingRepository.countByRole(role.getRoleCode());
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5728\u6279\u91cf\u7ed1\u5b9a\u65f6,\u89d2\u8272\u548c\u804c\u4f4d\u7ea7\u522b\u591a\u5bf9\u4e00\uff0c\u6307\u5b9a\u89d2\u8272[%s]\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u804c\u4f4d\u7ea7\u522b\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{role.getRoleName()});
        }
    }
}

