/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.server.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.rbac.server.service.RolePositionLevelMappingService;
import com.bizunited.platform.rbac.server.starter.controller.RolePositionMappingController;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/rolePositionLevelMapping"})
public class RolePositionLevelMappingController
extends BaseController {
    @Autowired
    private RolePositionLevelMappingService rolePositionLevelMappingService;
    private static final Logger LOGGER = LoggerFactory.getLogger(RolePositionMappingController.class);

    @ApiOperation(value="\u5c06\u6307\u5b9a\u804c\u4f4d\u7ea7\u522b\u7ed1\u5b9a\u4e00\u4e2a\u6216\u591a\u4e2a\u89d2\u8272")
    @PatchMapping(value={"bindPositionLevelRoles"})
    public ResponseModel bindPositionLevelRoles(@RequestParam @ApiParam(value="\u804c\u4f4d\u7ea7\u522b\u7f16\u7801") String positionLevelCode, @RequestParam @ApiParam(value="\u5f53\u524d\u8981\u7ed1\u5b9a\u7684\u4e00\u4e2a\u6216\u591a\u4e2a\u89d2\u8272id") String[] roleIds) {
        try {
            this.rolePositionLevelMappingService.bindPositionLevelRoles(positionLevelCode, roleIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5c06\u6307\u5b9a\u804c\u4f4d\u7ea7\u522b\u91cd\u65b0\u7ed1\u5b9a\u4e00\u4e2a\u6216\u591a\u4e2a\u89d2\u8272")
    @PatchMapping(value={"rebindPositionLevelRoles"})
    public ResponseModel rebindPositionLevelRoles(@RequestParam @ApiParam(value="\u804c\u4f4d\u7ea7\u522b\u7f16\u7801") String positionLevelCode, @RequestParam(required=false) @ApiParam(value="\u5f53\u524d\u8981\u7ed1\u5b9a\u7684\u4e00\u4e2a\u6216\u591a\u4e2a\u89d2\u8272id") String[] roleIds) {
        try {
            this.rolePositionLevelMappingService.rebindPositionLevelRoles(positionLevelCode, roleIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5c06\u6307\u5b9a\u804c\u4f4d\u7ea7\u522b\u89e3\u9664\u4e00\u4e2a\u6216\u591a\u4e2a\u89d2\u8272\u7684\u7ed1\u5b9a")
    @PatchMapping(value={"unbindPositionLevelRoles"})
    public ResponseModel unbindPositionLevelRoles(@RequestParam @ApiParam(value="\u804c\u4f4d\u7ea7\u522b\u7f16\u7801") String positionLevelCode, @RequestParam @ApiParam(value="\u5f53\u524d\u8981\u89e3\u7ed1\u5b9a\u7684\u4e00\u4e2a\u6216\u591a\u4e2a\u89d2\u8272id") String[] roleIds) {
        try {
            this.rolePositionLevelMappingService.unbindPositionLevelRoles(positionLevelCode, roleIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u89e3\u7ed1\u4e00\u4e2a\u6216\u591a\u4e2a\u804c\u4f4d\u7ea7\u522b\u7684\u5168\u90e8\u89d2\u8272")
    @PatchMapping(value={"unbindPositionLevels"})
    public ResponseModel unbindPositionLevels(@RequestParam @ApiParam(value="\u804c\u4f4d\u7ea7\u522b\u7f16\u7801\u6570\u7ec4") String[] positionLevelCodes) {
        try {
            this.rolePositionLevelMappingService.unbindPositionLevels(positionLevelCodes);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6279\u91cf\u6839\u636e\u804c\u7ea7Id,\u5220\u9664\u804c\u7ea7\u3001\u89e3\u7ed1\u89d2\u8272")
    @PostMapping(value={"/deletePositionLevelsUnbindRole"})
    public ResponseModel deletePositionLevelsUnbindRole(@RequestParam(value="roleIds") @ApiParam(value="\u89d2\u8272Id\u5217\u8868") String[] roleIds) {
        try {
            this.rolePositionLevelMappingService.deletePositionLevelsUnbindRole(roleIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u804c\u7ea7Id,\u5220\u9664\u804c\u7ea7\u3001\u89e3\u7ed1\u89d2\u8272")
    @PostMapping(value={"/deletePositionLevelUnbindRole"})
    public ResponseModel deletePositionLevelUnbindRole(@RequestParam(value="roleId") @ApiParam(value="\u89d2\u8272Id") String roleId) {
        try {
            this.rolePositionLevelMappingService.deletePositionLevelUnbindRole(roleId);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/findByConditions"})
    public ResponseModel findByConditions(@RequestBody(required=false) Map<String, Object> conditions, @PageableDefault(value=50) @ApiParam(name="pageable", value="\u5206\u9875\u4fe1\u606f") Pageable pageable) {
        try {
            Page result = this.rolePositionLevelMappingService.findByConditions(conditions, pageable);
            return this.buildHttpResult(result);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2")
    @GetMapping(value={"/findByNameAndRoleName"})
    public ResponseModel findByNameAndRoleName(@RequestParam(value="\u804c\u7ea7\u540d\u79f0", required=false) @ApiParam(value="\u804c\u7ea7\u540d\u79f0") String name, @RequestParam(value="\u89d2\u8272\u540d\u79f0", required=false) @ApiParam(value="\u89d2\u8272\u540d\u79f0") String roleName) {
        try {
            List result = this.rolePositionLevelMappingService.findByNameAndRoleName(name, roleName);
            return this.buildHttpResult(result);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u804c\u7ea7\u7f16\u7801\u67e5\u8be2\u89d2\u8272\u548c\u804c\u7ea7\u4fe1\u606f")
    @GetMapping(value={"/findByPositionLevelCode"})
    public ResponseModel findByPositionLevelCode(@RequestParam(name="positionLevelCode") @ApiParam(value="\u804c\u7ea7\u7f16\u7801") String positionLevelCode) {
        try {
            List result = this.rolePositionLevelMappingService.findByPositionLevelCode(positionLevelCode);
            return this.buildHttpResult(result);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

