package com.bizunited.platform.rbac.server.service;

import com.bizunited.platform.rbac.server.vo.UserVo;

/**
 * UserService用户信息服务的适配器，该适配器主要用于自定义RBAC部分的实现，且一般来说不需要实现“写”性质的接口方法
 * @author yinwenjie
 */
public abstract class AbstractUserServiceAdapter implements UserService {

  /* (non-Javadoc)
   * @see com.bizunited.platform.rbac.server.service.UserService#create(com.bizunited.platform.rbac.server.vo.UserVo)
   */
  @Override
  public UserVo create(UserVo user) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现UserService.create接口");
  }

  @Override
  public UserVo update(UserVo user) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现UserService.update接口");
  }

  @Override
  public UserVo updatePassword(String userId, String newPassword) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现UserService.updatePassword接口");
  }

  @Override
  public UserVo updatePassword(String userId, String newPassword, String oldPassword) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现UserService.updatePassword接口");
  }

  @Override
  public UserVo enabled(String account) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现UserService.enabled接口");
  }

  @Override
  public UserVo disable(String account) {
    throw new IllegalArgumentException("自定义功能资源服务并未实现UserService.disable接口");
  }
}